/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v281.group.OPL_O37_CONTAINER;
import ca.uhn.hl7v2.model.v281.group.OPL_O37_OBSERVATION_REQUEST;
import ca.uhn.hl7v2.model.v281.group.OPL_O37_SPECIMEN_OBSERVATION;
import ca.uhn.hl7v2.model.v281.segment.SPM;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class OPL_O37_SPECIMEN
extends AbstractGroup {
    public OPL_O37_SPECIMEN(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SPM.class, true, false, false);
            this.add(OPL_O37_SPECIMEN_OBSERVATION.class, false, true, false);
            this.add(OPL_O37_CONTAINER.class, false, true, false);
            this.add(OPL_O37_OBSERVATION_REQUEST.class, true, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OPL_O37_SPECIMEN - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.8.1";
    }

    public SPM getSPM() {
        SPM retVal = this.getTyped("SPM", SPM.class);
        return retVal;
    }

    public OPL_O37_SPECIMEN_OBSERVATION getSPECIMEN_OBSERVATION() {
        OPL_O37_SPECIMEN_OBSERVATION retVal = this.getTyped("SPECIMEN_OBSERVATION", OPL_O37_SPECIMEN_OBSERVATION.class);
        return retVal;
    }

    public OPL_O37_SPECIMEN_OBSERVATION getSPECIMEN_OBSERVATION(int rep) {
        OPL_O37_SPECIMEN_OBSERVATION retVal = this.getTyped("SPECIMEN_OBSERVATION", rep, OPL_O37_SPECIMEN_OBSERVATION.class);
        return retVal;
    }

    public int getSPECIMEN_OBSERVATIONReps() {
        return this.getReps("SPECIMEN_OBSERVATION");
    }

    public List<OPL_O37_SPECIMEN_OBSERVATION> getSPECIMEN_OBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("SPECIMEN_OBSERVATION", OPL_O37_SPECIMEN_OBSERVATION.class);
    }

    public void insertSPECIMEN_OBSERVATION(OPL_O37_SPECIMEN_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("SPECIMEN_OBSERVATION", structure, rep);
    }

    public OPL_O37_SPECIMEN_OBSERVATION insertSPECIMEN_OBSERVATION(int rep) throws HL7Exception {
        return (OPL_O37_SPECIMEN_OBSERVATION)super.insertRepetition("SPECIMEN_OBSERVATION", rep);
    }

    public OPL_O37_SPECIMEN_OBSERVATION removeSPECIMEN_OBSERVATION(int rep) throws HL7Exception {
        return (OPL_O37_SPECIMEN_OBSERVATION)super.removeRepetition("SPECIMEN_OBSERVATION", rep);
    }

    public OPL_O37_CONTAINER getCONTAINER() {
        OPL_O37_CONTAINER retVal = this.getTyped("CONTAINER", OPL_O37_CONTAINER.class);
        return retVal;
    }

    public OPL_O37_CONTAINER getCONTAINER(int rep) {
        OPL_O37_CONTAINER retVal = this.getTyped("CONTAINER", rep, OPL_O37_CONTAINER.class);
        return retVal;
    }

    public int getCONTAINERReps() {
        return this.getReps("CONTAINER");
    }

    public List<OPL_O37_CONTAINER> getCONTAINERAll() throws HL7Exception {
        return this.getAllAsList("CONTAINER", OPL_O37_CONTAINER.class);
    }

    public void insertCONTAINER(OPL_O37_CONTAINER structure, int rep) throws HL7Exception {
        super.insertRepetition("CONTAINER", structure, rep);
    }

    public OPL_O37_CONTAINER insertCONTAINER(int rep) throws HL7Exception {
        return (OPL_O37_CONTAINER)super.insertRepetition("CONTAINER", rep);
    }

    public OPL_O37_CONTAINER removeCONTAINER(int rep) throws HL7Exception {
        return (OPL_O37_CONTAINER)super.removeRepetition("CONTAINER", rep);
    }

    public OPL_O37_OBSERVATION_REQUEST getOBSERVATION_REQUEST() {
        OPL_O37_OBSERVATION_REQUEST retVal = this.getTyped("OBSERVATION_REQUEST", OPL_O37_OBSERVATION_REQUEST.class);
        return retVal;
    }

    public OPL_O37_OBSERVATION_REQUEST getOBSERVATION_REQUEST(int rep) {
        OPL_O37_OBSERVATION_REQUEST retVal = this.getTyped("OBSERVATION_REQUEST", rep, OPL_O37_OBSERVATION_REQUEST.class);
        return retVal;
    }

    public int getOBSERVATION_REQUESTReps() {
        return this.getReps("OBSERVATION_REQUEST");
    }

    public List<OPL_O37_OBSERVATION_REQUEST> getOBSERVATION_REQUESTAll() throws HL7Exception {
        return this.getAllAsList("OBSERVATION_REQUEST", OPL_O37_OBSERVATION_REQUEST.class);
    }

    public void insertOBSERVATION_REQUEST(OPL_O37_OBSERVATION_REQUEST structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION_REQUEST", structure, rep);
    }

    public OPL_O37_OBSERVATION_REQUEST insertOBSERVATION_REQUEST(int rep) throws HL7Exception {
        return (OPL_O37_OBSERVATION_REQUEST)super.insertRepetition("OBSERVATION_REQUEST", rep);
    }

    public OPL_O37_OBSERVATION_REQUEST removeOBSERVATION_REQUEST(int rep) throws HL7Exception {
        return (OPL_O37_OBSERVATION_REQUEST)super.removeRepetition("OBSERVATION_REQUEST", rep);
    }
}

