/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v281.datatype.CWE;
import ca.uhn.hl7v2.model.v281.datatype.NR;
import ca.uhn.hl7v2.model.v281.datatype.ST;
import ca.uhn.hl7v2.model.v281.datatype.TX;

public class RFR
extends AbstractComposite {
    private Type[] data;

    public RFR(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[7];
        this.data[0] = new NR(this.getMessage());
        this.data[1] = new CWE(this.getMessage());
        this.data[2] = new NR(this.getMessage());
        this.data[3] = new NR(this.getMessage());
        this.data[4] = new ST(this.getMessage());
        this.data[5] = new ST(this.getMessage());
        this.data[6] = new TX(this.getMessage());
    }

    @Override
    public Type[] getComponents() {
        return this.data;
    }

    @Override
    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + this.getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public NR getNumericRange() {
        return this.getTyped(0, NR.class);
    }

    public NR getRfr1_NumericRange() {
        return this.getTyped(0, NR.class);
    }

    public CWE getAdministrativeSex() {
        return this.getTyped(1, CWE.class);
    }

    public CWE getRfr2_AdministrativeSex() {
        return this.getTyped(1, CWE.class);
    }

    public NR getAgeRange() {
        return this.getTyped(2, NR.class);
    }

    public NR getRfr3_AgeRange() {
        return this.getTyped(2, NR.class);
    }

    public NR getGestationalAgeRange() {
        return this.getTyped(3, NR.class);
    }

    public NR getRfr4_GestationalAgeRange() {
        return this.getTyped(3, NR.class);
    }

    public ST getSpecies() {
        return this.getTyped(4, ST.class);
    }

    public ST getRfr5_Species() {
        return this.getTyped(4, ST.class);
    }

    public ST getRaceSubspecies() {
        return this.getTyped(5, ST.class);
    }

    public ST getRfr6_RaceSubspecies() {
        return this.getTyped(5, ST.class);
    }

    public TX getConditions() {
        return this.getTyped(6, TX.class);
    }

    public TX getRfr7_Conditions() {
        return this.getTyped(6, TX.class);
    }
}

