/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v28.datatype.CWE;
import ca.uhn.hl7v2.model.v28.datatype.DLT;
import ca.uhn.hl7v2.model.v28.datatype.NM;
import ca.uhn.hl7v2.model.v28.datatype.RFR;
import ca.uhn.hl7v2.model.v28.datatype.TX;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class OM2
extends AbstractSegment {
    public OM2(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Sequence Number - Test/Observation Master File");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Units of Measure");
            this.add(NM.class, false, 0, 0, new Object[]{this.getMessage()}, "Range of Decimal Precision");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Corresponding SI Units of Measure");
            this.add(TX.class, false, 1, 0, new Object[]{this.getMessage()}, "SI Conversion Factor");
            this.add(RFR.class, false, 0, 0, new Object[]{this.getMessage()}, "Reference (Normal) Range for Ordinal and Continuous Observations");
            this.add(RFR.class, false, 0, 0, new Object[]{this.getMessage()}, "Critical Range for Ordinal and Continuous Observations");
            this.add(RFR.class, false, 1, 0, new Object[]{this.getMessage()}, "Absolute Range for Ordinal and Continuous Observations");
            this.add(DLT.class, false, 0, 0, new Object[]{this.getMessage()}, "Delta Check Criteria");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Minimum Meaningful Increments");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OM2 - this is probably a bug in the source code generator.", e);
        }
    }

    public NM getSequenceNumberTestObservationMasterFile() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getOm21_SequenceNumberTestObservationMasterFile() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getUnitsOfMeasure() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getOm22_UnitsOfMeasure() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public NM[] getRangeOfDecimalPrecision() {
        NM[] retVal = (NM[])this.getTypedField(3, new NM[0]);
        return retVal;
    }

    public NM[] getOm23_RangeOfDecimalPrecision() {
        NM[] retVal = (NM[])this.getTypedField(3, new NM[0]);
        return retVal;
    }

    public int getRangeOfDecimalPrecisionReps() {
        return this.getReps(3);
    }

    public NM getRangeOfDecimalPrecision(int rep) {
        NM retVal = (NM)this.getTypedField(3, rep);
        return retVal;
    }

    public NM getOm23_RangeOfDecimalPrecision(int rep) {
        NM retVal = (NM)this.getTypedField(3, rep);
        return retVal;
    }

    public int getOm23_RangeOfDecimalPrecisionReps() {
        return this.getReps(3);
    }

    public NM insertRangeOfDecimalPrecision(int rep) throws HL7Exception {
        return (NM)super.insertRepetition(3, rep);
    }

    public NM insertOm23_RangeOfDecimalPrecision(int rep) throws HL7Exception {
        return (NM)super.insertRepetition(3, rep);
    }

    public NM removeRangeOfDecimalPrecision(int rep) throws HL7Exception {
        return (NM)super.removeRepetition(3, rep);
    }

    public NM removeOm23_RangeOfDecimalPrecision(int rep) throws HL7Exception {
        return (NM)super.removeRepetition(3, rep);
    }

    public CWE getCorrespondingSIUnitsOfMeasure() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getOm24_CorrespondingSIUnitsOfMeasure() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public TX getSIConversionFactor() {
        TX retVal = (TX)this.getTypedField(5, 0);
        return retVal;
    }

    public TX getOm25_SIConversionFactor() {
        TX retVal = (TX)this.getTypedField(5, 0);
        return retVal;
    }

    public RFR[] getReferenceNormalRangeForOrdinalAndContinuousObservations() {
        RFR[] retVal = (RFR[])this.getTypedField(6, new RFR[0]);
        return retVal;
    }

    public RFR[] getOm26_ReferenceNormalRangeForOrdinalAndContinuousObservations() {
        RFR[] retVal = (RFR[])this.getTypedField(6, new RFR[0]);
        return retVal;
    }

    public int getReferenceNormalRangeForOrdinalAndContinuousObservationsReps() {
        return this.getReps(6);
    }

    public RFR getReferenceNormalRangeForOrdinalAndContinuousObservations(int rep) {
        RFR retVal = (RFR)this.getTypedField(6, rep);
        return retVal;
    }

    public RFR getOm26_ReferenceNormalRangeForOrdinalAndContinuousObservations(int rep) {
        RFR retVal = (RFR)this.getTypedField(6, rep);
        return retVal;
    }

    public int getOm26_ReferenceNormalRangeForOrdinalAndContinuousObservationsReps() {
        return this.getReps(6);
    }

    public RFR insertReferenceNormalRangeForOrdinalAndContinuousObservations(int rep) throws HL7Exception {
        return (RFR)super.insertRepetition(6, rep);
    }

    public RFR insertOm26_ReferenceNormalRangeForOrdinalAndContinuousObservations(int rep) throws HL7Exception {
        return (RFR)super.insertRepetition(6, rep);
    }

    public RFR removeReferenceNormalRangeForOrdinalAndContinuousObservations(int rep) throws HL7Exception {
        return (RFR)super.removeRepetition(6, rep);
    }

    public RFR removeOm26_ReferenceNormalRangeForOrdinalAndContinuousObservations(int rep) throws HL7Exception {
        return (RFR)super.removeRepetition(6, rep);
    }

    public RFR[] getCriticalRangeForOrdinalAndContinuousObservations() {
        RFR[] retVal = (RFR[])this.getTypedField(7, new RFR[0]);
        return retVal;
    }

    public RFR[] getOm27_CriticalRangeForOrdinalAndContinuousObservations() {
        RFR[] retVal = (RFR[])this.getTypedField(7, new RFR[0]);
        return retVal;
    }

    public int getCriticalRangeForOrdinalAndContinuousObservationsReps() {
        return this.getReps(7);
    }

    public RFR getCriticalRangeForOrdinalAndContinuousObservations(int rep) {
        RFR retVal = (RFR)this.getTypedField(7, rep);
        return retVal;
    }

    public RFR getOm27_CriticalRangeForOrdinalAndContinuousObservations(int rep) {
        RFR retVal = (RFR)this.getTypedField(7, rep);
        return retVal;
    }

    public int getOm27_CriticalRangeForOrdinalAndContinuousObservationsReps() {
        return this.getReps(7);
    }

    public RFR insertCriticalRangeForOrdinalAndContinuousObservations(int rep) throws HL7Exception {
        return (RFR)super.insertRepetition(7, rep);
    }

    public RFR insertOm27_CriticalRangeForOrdinalAndContinuousObservations(int rep) throws HL7Exception {
        return (RFR)super.insertRepetition(7, rep);
    }

    public RFR removeCriticalRangeForOrdinalAndContinuousObservations(int rep) throws HL7Exception {
        return (RFR)super.removeRepetition(7, rep);
    }

    public RFR removeOm27_CriticalRangeForOrdinalAndContinuousObservations(int rep) throws HL7Exception {
        return (RFR)super.removeRepetition(7, rep);
    }

    public RFR getAbsoluteRangeForOrdinalAndContinuousObservations() {
        RFR retVal = (RFR)this.getTypedField(8, 0);
        return retVal;
    }

    public RFR getOm28_AbsoluteRangeForOrdinalAndContinuousObservations() {
        RFR retVal = (RFR)this.getTypedField(8, 0);
        return retVal;
    }

    public DLT[] getDeltaCheckCriteria() {
        DLT[] retVal = (DLT[])this.getTypedField(9, new DLT[0]);
        return retVal;
    }

    public DLT[] getOm29_DeltaCheckCriteria() {
        DLT[] retVal = (DLT[])this.getTypedField(9, new DLT[0]);
        return retVal;
    }

    public int getDeltaCheckCriteriaReps() {
        return this.getReps(9);
    }

    public DLT getDeltaCheckCriteria(int rep) {
        DLT retVal = (DLT)this.getTypedField(9, rep);
        return retVal;
    }

    public DLT getOm29_DeltaCheckCriteria(int rep) {
        DLT retVal = (DLT)this.getTypedField(9, rep);
        return retVal;
    }

    public int getOm29_DeltaCheckCriteriaReps() {
        return this.getReps(9);
    }

    public DLT insertDeltaCheckCriteria(int rep) throws HL7Exception {
        return (DLT)super.insertRepetition(9, rep);
    }

    public DLT insertOm29_DeltaCheckCriteria(int rep) throws HL7Exception {
        return (DLT)super.insertRepetition(9, rep);
    }

    public DLT removeDeltaCheckCriteria(int rep) throws HL7Exception {
        return (DLT)super.removeRepetition(9, rep);
    }

    public DLT removeOm29_DeltaCheckCriteria(int rep) throws HL7Exception {
        return (DLT)super.removeRepetition(9, rep);
    }

    public NM getMinimumMeaningfulIncrements() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public NM getOm210_MinimumMeaningfulIncrements() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new NM(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new NM(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
            case 4: {
                return new TX(this.getMessage());
            }
            case 5: {
                return new RFR(this.getMessage());
            }
            case 6: {
                return new RFR(this.getMessage());
            }
            case 7: {
                return new RFR(this.getMessage());
            }
            case 8: {
                return new DLT(this.getMessage());
            }
            case 9: {
                return new NM(this.getMessage());
            }
        }
        return null;
    }
}

