/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v28.group.DER_O44_DONOR;
import ca.uhn.hl7v2.model.v28.group.DER_O44_DONOR_ORDER;
import ca.uhn.hl7v2.model.v28.segment.MSH;
import ca.uhn.hl7v2.model.v28.segment.SFT;
import ca.uhn.hl7v2.model.v28.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class DER_O44
extends AbstractMessage {
    public DER_O44() {
        this(new DefaultModelClassFactory());
    }

    public DER_O44(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(DER_O44_DONOR.class, false, false);
            this.add(DER_O44_DONOR_ORDER.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating DER_O44 - this is probably a bug in the source code generator.", e);
        }
    }

    @Override
    public String getVersion() {
        return "2.8";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return this.getTyped("UAC", UAC.class);
    }

    public DER_O44_DONOR getDONOR() {
        return this.getTyped("DONOR", DER_O44_DONOR.class);
    }

    public DER_O44_DONOR_ORDER getDONOR_ORDER() {
        return this.getTyped("DONOR_ORDER", DER_O44_DONOR_ORDER.class);
    }

    public DER_O44_DONOR_ORDER getDONOR_ORDER(int rep) {
        return this.getTyped("DONOR_ORDER", rep, DER_O44_DONOR_ORDER.class);
    }

    public int getDONOR_ORDERReps() {
        return this.getReps("DONOR_ORDER");
    }

    public List<DER_O44_DONOR_ORDER> getDONOR_ORDERAll() throws HL7Exception {
        return this.getAllAsList("DONOR_ORDER", DER_O44_DONOR_ORDER.class);
    }

    public void insertDONOR_ORDER(DER_O44_DONOR_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("DONOR_ORDER", structure, rep);
    }

    public DER_O44_DONOR_ORDER insertDONOR_ORDER(int rep) throws HL7Exception {
        return (DER_O44_DONOR_ORDER)super.insertRepetition("DONOR_ORDER", rep);
    }

    public DER_O44_DONOR_ORDER removeDONOR_ORDER(int rep) throws HL7Exception {
        return (DER_O44_DONOR_ORDER)super.removeRepetition("DONOR_ORDER", rep);
    }
}

