/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v28.group.OMS_O05_INSURANCE;
import ca.uhn.hl7v2.model.v28.group.OMS_O05_PATIENT_VISIT;
import ca.uhn.hl7v2.model.v28.segment.AL1;
import ca.uhn.hl7v2.model.v28.segment.ARV;
import ca.uhn.hl7v2.model.v28.segment.GT1;
import ca.uhn.hl7v2.model.v28.segment.NTE;
import ca.uhn.hl7v2.model.v28.segment.PD1;
import ca.uhn.hl7v2.model.v28.segment.PID;
import ca.uhn.hl7v2.model.v28.segment.PRT;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class OMS_O05_PATIENT
extends AbstractGroup {
    public OMS_O05_PATIENT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PID.class, true, false, false);
            this.add(PD1.class, false, false, false);
            this.add(PRT.class, false, true, false);
            this.add(ARV.class, false, true, false);
            this.add(NTE.class, false, true, false);
            this.add(OMS_O05_PATIENT_VISIT.class, false, false, false);
            this.add(OMS_O05_INSURANCE.class, false, true, false);
            this.add(GT1.class, false, false, false);
            this.add(AL1.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OMS_O05_PATIENT - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.8";
    }

    public PID getPID() {
        PID retVal = this.getTyped("PID", PID.class);
        return retVal;
    }

    public PD1 getPD1() {
        PD1 retVal = this.getTyped("PD1", PD1.class);
        return retVal;
    }

    public PRT getPRT() {
        PRT retVal = this.getTyped("PRT", PRT.class);
        return retVal;
    }

    public PRT getPRT(int rep) {
        PRT retVal = this.getTyped("PRT", rep, PRT.class);
        return retVal;
    }

    public int getPRTReps() {
        return this.getReps("PRT");
    }

    public List<PRT> getPRTAll() throws HL7Exception {
        return this.getAllAsList("PRT", PRT.class);
    }

    public void insertPRT(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT", structure, rep);
    }

    public PRT insertPRT(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT", rep);
    }

    public PRT removePRT(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT", rep);
    }

    public ARV getARV() {
        ARV retVal = this.getTyped("ARV", ARV.class);
        return retVal;
    }

    public ARV getARV(int rep) {
        ARV retVal = this.getTyped("ARV", rep, ARV.class);
        return retVal;
    }

    public int getARVReps() {
        return this.getReps("ARV");
    }

    public List<ARV> getARVAll() throws HL7Exception {
        return this.getAllAsList("ARV", ARV.class);
    }

    public void insertARV(ARV structure, int rep) throws HL7Exception {
        super.insertRepetition("ARV", structure, rep);
    }

    public ARV insertARV(int rep) throws HL7Exception {
        return (ARV)super.insertRepetition("ARV", rep);
    }

    public ARV removeARV(int rep) throws HL7Exception {
        return (ARV)super.removeRepetition("ARV", rep);
    }

    public NTE getNTE() {
        NTE retVal = this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public OMS_O05_PATIENT_VISIT getPATIENT_VISIT() {
        OMS_O05_PATIENT_VISIT retVal = this.getTyped("PATIENT_VISIT", OMS_O05_PATIENT_VISIT.class);
        return retVal;
    }

    public OMS_O05_INSURANCE getINSURANCE() {
        OMS_O05_INSURANCE retVal = this.getTyped("INSURANCE", OMS_O05_INSURANCE.class);
        return retVal;
    }

    public OMS_O05_INSURANCE getINSURANCE(int rep) {
        OMS_O05_INSURANCE retVal = this.getTyped("INSURANCE", rep, OMS_O05_INSURANCE.class);
        return retVal;
    }

    public int getINSURANCEReps() {
        return this.getReps("INSURANCE");
    }

    public List<OMS_O05_INSURANCE> getINSURANCEAll() throws HL7Exception {
        return this.getAllAsList("INSURANCE", OMS_O05_INSURANCE.class);
    }

    public void insertINSURANCE(OMS_O05_INSURANCE structure, int rep) throws HL7Exception {
        super.insertRepetition("INSURANCE", structure, rep);
    }

    public OMS_O05_INSURANCE insertINSURANCE(int rep) throws HL7Exception {
        return (OMS_O05_INSURANCE)super.insertRepetition("INSURANCE", rep);
    }

    public OMS_O05_INSURANCE removeINSURANCE(int rep) throws HL7Exception {
        return (OMS_O05_INSURANCE)super.removeRepetition("INSURANCE", rep);
    }

    public GT1 getGT1() {
        GT1 retVal = this.getTyped("GT1", GT1.class);
        return retVal;
    }

    public AL1 getAL1() {
        AL1 retVal = this.getTyped("AL1", AL1.class);
        return retVal;
    }

    public AL1 getAL1(int rep) {
        AL1 retVal = this.getTyped("AL1", rep, AL1.class);
        return retVal;
    }

    public int getAL1Reps() {
        return this.getReps("AL1");
    }

    public List<AL1> getAL1All() throws HL7Exception {
        return this.getAllAsList("AL1", AL1.class);
    }

    public void insertAL1(AL1 structure, int rep) throws HL7Exception {
        super.insertRepetition("AL1", structure, rep);
    }

    public AL1 insertAL1(int rep) throws HL7Exception {
        return (AL1)super.insertRepetition("AL1", rep);
    }

    public AL1 removeAL1(int rep) throws HL7Exception {
        return (AL1)super.removeRepetition("AL1", rep);
    }
}

