/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v28.group.CQU_I19_PATHWAY_OBSERVATION;
import ca.uhn.hl7v2.model.v28.group.CQU_I19_ROLE_PATHWAY;
import ca.uhn.hl7v2.model.v28.segment.PTH;
import ca.uhn.hl7v2.model.v28.segment.VAR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class CQU_I19_PATHWAY
extends AbstractGroup {
    public CQU_I19_PATHWAY(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PTH.class, true, false, false);
            this.add(VAR.class, false, true, false);
            this.add(CQU_I19_ROLE_PATHWAY.class, false, true, false);
            this.add(CQU_I19_PATHWAY_OBSERVATION.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating CQU_I19_PATHWAY - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.8";
    }

    public PTH getPTH() {
        PTH retVal = this.getTyped("PTH", PTH.class);
        return retVal;
    }

    public VAR getVAR() {
        VAR retVal = this.getTyped("VAR", VAR.class);
        return retVal;
    }

    public VAR getVAR(int rep) {
        VAR retVal = this.getTyped("VAR", rep, VAR.class);
        return retVal;
    }

    public int getVARReps() {
        return this.getReps("VAR");
    }

    public List<VAR> getVARAll() throws HL7Exception {
        return this.getAllAsList("VAR", VAR.class);
    }

    public void insertVAR(VAR structure, int rep) throws HL7Exception {
        super.insertRepetition("VAR", structure, rep);
    }

    public VAR insertVAR(int rep) throws HL7Exception {
        return (VAR)super.insertRepetition("VAR", rep);
    }

    public VAR removeVAR(int rep) throws HL7Exception {
        return (VAR)super.removeRepetition("VAR", rep);
    }

    public CQU_I19_ROLE_PATHWAY getROLE_PATHWAY() {
        CQU_I19_ROLE_PATHWAY retVal = this.getTyped("ROLE_PATHWAY", CQU_I19_ROLE_PATHWAY.class);
        return retVal;
    }

    public CQU_I19_ROLE_PATHWAY getROLE_PATHWAY(int rep) {
        CQU_I19_ROLE_PATHWAY retVal = this.getTyped("ROLE_PATHWAY", rep, CQU_I19_ROLE_PATHWAY.class);
        return retVal;
    }

    public int getROLE_PATHWAYReps() {
        return this.getReps("ROLE_PATHWAY");
    }

    public List<CQU_I19_ROLE_PATHWAY> getROLE_PATHWAYAll() throws HL7Exception {
        return this.getAllAsList("ROLE_PATHWAY", CQU_I19_ROLE_PATHWAY.class);
    }

    public void insertROLE_PATHWAY(CQU_I19_ROLE_PATHWAY structure, int rep) throws HL7Exception {
        super.insertRepetition("ROLE_PATHWAY", structure, rep);
    }

    public CQU_I19_ROLE_PATHWAY insertROLE_PATHWAY(int rep) throws HL7Exception {
        return (CQU_I19_ROLE_PATHWAY)super.insertRepetition("ROLE_PATHWAY", rep);
    }

    public CQU_I19_ROLE_PATHWAY removeROLE_PATHWAY(int rep) throws HL7Exception {
        return (CQU_I19_ROLE_PATHWAY)super.removeRepetition("ROLE_PATHWAY", rep);
    }

    public CQU_I19_PATHWAY_OBSERVATION getPATHWAY_OBSERVATION() {
        CQU_I19_PATHWAY_OBSERVATION retVal = this.getTyped("PATHWAY_OBSERVATION", CQU_I19_PATHWAY_OBSERVATION.class);
        return retVal;
    }

    public CQU_I19_PATHWAY_OBSERVATION getPATHWAY_OBSERVATION(int rep) {
        CQU_I19_PATHWAY_OBSERVATION retVal = this.getTyped("PATHWAY_OBSERVATION", rep, CQU_I19_PATHWAY_OBSERVATION.class);
        return retVal;
    }

    public int getPATHWAY_OBSERVATIONReps() {
        return this.getReps("PATHWAY_OBSERVATION");
    }

    public List<CQU_I19_PATHWAY_OBSERVATION> getPATHWAY_OBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("PATHWAY_OBSERVATION", CQU_I19_PATHWAY_OBSERVATION.class);
    }

    public void insertPATHWAY_OBSERVATION(CQU_I19_PATHWAY_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("PATHWAY_OBSERVATION", structure, rep);
    }

    public CQU_I19_PATHWAY_OBSERVATION insertPATHWAY_OBSERVATION(int rep) throws HL7Exception {
        return (CQU_I19_PATHWAY_OBSERVATION)super.insertRepetition("PATHWAY_OBSERVATION", rep);
    }

    public CQU_I19_PATHWAY_OBSERVATION removePATHWAY_OBSERVATION(int rep) throws HL7Exception {
        return (CQU_I19_PATHWAY_OBSERVATION)super.removeRepetition("PATHWAY_OBSERVATION", rep);
    }
}

