/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v27.datatype.CWE;
import ca.uhn.hl7v2.model.v27.datatype.DT;
import ca.uhn.hl7v2.model.v27.datatype.ID;
import ca.uhn.hl7v2.model.v27.datatype.PIP;
import ca.uhn.hl7v2.model.v27.datatype.PLN;
import ca.uhn.hl7v2.model.v27.datatype.SI;
import ca.uhn.hl7v2.model.v27.datatype.SPD;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PRA
extends AbstractSegment {
    public PRA(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Primary Key Value - PRA");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Practitioner Group");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Practitioner Category");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(187)}, "Provider Billing");
            this.add(SPD.class, false, 0, 0, new Object[]{this.getMessage()}, "Specialty");
            this.add(PLN.class, false, 0, 0, new Object[]{this.getMessage()}, "Practitioner ID Numbers");
            this.add(PIP.class, false, 0, 0, new Object[]{this.getMessage()}, "Privileges");
            this.add(DT.class, false, 1, 0, new Object[]{this.getMessage()}, "Date Entered Practice");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Institution");
            this.add(DT.class, false, 1, 0, new Object[]{this.getMessage()}, "Date Left Practice");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Government Reimbursement Billing Eligibility");
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage()}, "Set ID - PRA");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PRA - this is probably a bug in the source code generator.", e);
        }
    }

    public CWE getPrimaryKeyValuePRA() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getPra1_PrimaryKeyValuePRA() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE[] getPractitionerGroup() {
        CWE[] retVal = (CWE[])this.getTypedField(2, new CWE[0]);
        return retVal;
    }

    public CWE[] getPra2_PractitionerGroup() {
        CWE[] retVal = (CWE[])this.getTypedField(2, new CWE[0]);
        return retVal;
    }

    public int getPractitionerGroupReps() {
        return this.getReps(2);
    }

    public CWE getPractitionerGroup(int rep) {
        CWE retVal = (CWE)this.getTypedField(2, rep);
        return retVal;
    }

    public CWE getPra2_PractitionerGroup(int rep) {
        CWE retVal = (CWE)this.getTypedField(2, rep);
        return retVal;
    }

    public int getPra2_PractitionerGroupReps() {
        return this.getReps(2);
    }

    public CWE insertPractitionerGroup(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(2, rep);
    }

    public CWE insertPra2_PractitionerGroup(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(2, rep);
    }

    public CWE removePractitionerGroup(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(2, rep);
    }

    public CWE removePra2_PractitionerGroup(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(2, rep);
    }

    public CWE[] getPractitionerCategory() {
        CWE[] retVal = (CWE[])this.getTypedField(3, new CWE[0]);
        return retVal;
    }

    public CWE[] getPra3_PractitionerCategory() {
        CWE[] retVal = (CWE[])this.getTypedField(3, new CWE[0]);
        return retVal;
    }

    public int getPractitionerCategoryReps() {
        return this.getReps(3);
    }

    public CWE getPractitionerCategory(int rep) {
        CWE retVal = (CWE)this.getTypedField(3, rep);
        return retVal;
    }

    public CWE getPra3_PractitionerCategory(int rep) {
        CWE retVal = (CWE)this.getTypedField(3, rep);
        return retVal;
    }

    public int getPra3_PractitionerCategoryReps() {
        return this.getReps(3);
    }

    public CWE insertPractitionerCategory(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(3, rep);
    }

    public CWE insertPra3_PractitionerCategory(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(3, rep);
    }

    public CWE removePractitionerCategory(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(3, rep);
    }

    public CWE removePra3_PractitionerCategory(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(3, rep);
    }

    public ID getProviderBilling() {
        ID retVal = (ID)this.getTypedField(4, 0);
        return retVal;
    }

    public ID getPra4_ProviderBilling() {
        ID retVal = (ID)this.getTypedField(4, 0);
        return retVal;
    }

    public SPD[] getSpecialty() {
        SPD[] retVal = (SPD[])this.getTypedField(5, new SPD[0]);
        return retVal;
    }

    public SPD[] getPra5_Specialty() {
        SPD[] retVal = (SPD[])this.getTypedField(5, new SPD[0]);
        return retVal;
    }

    public int getSpecialtyReps() {
        return this.getReps(5);
    }

    public SPD getSpecialty(int rep) {
        SPD retVal = (SPD)this.getTypedField(5, rep);
        return retVal;
    }

    public SPD getPra5_Specialty(int rep) {
        SPD retVal = (SPD)this.getTypedField(5, rep);
        return retVal;
    }

    public int getPra5_SpecialtyReps() {
        return this.getReps(5);
    }

    public SPD insertSpecialty(int rep) throws HL7Exception {
        return (SPD)super.insertRepetition(5, rep);
    }

    public SPD insertPra5_Specialty(int rep) throws HL7Exception {
        return (SPD)super.insertRepetition(5, rep);
    }

    public SPD removeSpecialty(int rep) throws HL7Exception {
        return (SPD)super.removeRepetition(5, rep);
    }

    public SPD removePra5_Specialty(int rep) throws HL7Exception {
        return (SPD)super.removeRepetition(5, rep);
    }

    public PLN[] getPractitionerIDNumbers() {
        PLN[] retVal = (PLN[])this.getTypedField(6, new PLN[0]);
        return retVal;
    }

    public PLN[] getPra6_PractitionerIDNumbers() {
        PLN[] retVal = (PLN[])this.getTypedField(6, new PLN[0]);
        return retVal;
    }

    public int getPractitionerIDNumbersReps() {
        return this.getReps(6);
    }

    public PLN getPractitionerIDNumbers(int rep) {
        PLN retVal = (PLN)this.getTypedField(6, rep);
        return retVal;
    }

    public PLN getPra6_PractitionerIDNumbers(int rep) {
        PLN retVal = (PLN)this.getTypedField(6, rep);
        return retVal;
    }

    public int getPra6_PractitionerIDNumbersReps() {
        return this.getReps(6);
    }

    public PLN insertPractitionerIDNumbers(int rep) throws HL7Exception {
        return (PLN)super.insertRepetition(6, rep);
    }

    public PLN insertPra6_PractitionerIDNumbers(int rep) throws HL7Exception {
        return (PLN)super.insertRepetition(6, rep);
    }

    public PLN removePractitionerIDNumbers(int rep) throws HL7Exception {
        return (PLN)super.removeRepetition(6, rep);
    }

    public PLN removePra6_PractitionerIDNumbers(int rep) throws HL7Exception {
        return (PLN)super.removeRepetition(6, rep);
    }

    public PIP[] getPrivileges() {
        PIP[] retVal = (PIP[])this.getTypedField(7, new PIP[0]);
        return retVal;
    }

    public PIP[] getPra7_Privileges() {
        PIP[] retVal = (PIP[])this.getTypedField(7, new PIP[0]);
        return retVal;
    }

    public int getPrivilegesReps() {
        return this.getReps(7);
    }

    public PIP getPrivileges(int rep) {
        PIP retVal = (PIP)this.getTypedField(7, rep);
        return retVal;
    }

    public PIP getPra7_Privileges(int rep) {
        PIP retVal = (PIP)this.getTypedField(7, rep);
        return retVal;
    }

    public int getPra7_PrivilegesReps() {
        return this.getReps(7);
    }

    public PIP insertPrivileges(int rep) throws HL7Exception {
        return (PIP)super.insertRepetition(7, rep);
    }

    public PIP insertPra7_Privileges(int rep) throws HL7Exception {
        return (PIP)super.insertRepetition(7, rep);
    }

    public PIP removePrivileges(int rep) throws HL7Exception {
        return (PIP)super.removeRepetition(7, rep);
    }

    public PIP removePra7_Privileges(int rep) throws HL7Exception {
        return (PIP)super.removeRepetition(7, rep);
    }

    public DT getDateEnteredPractice() {
        DT retVal = (DT)this.getTypedField(8, 0);
        return retVal;
    }

    public DT getPra8_DateEnteredPractice() {
        DT retVal = (DT)this.getTypedField(8, 0);
        return retVal;
    }

    public CWE getInstitution() {
        CWE retVal = (CWE)this.getTypedField(9, 0);
        return retVal;
    }

    public CWE getPra9_Institution() {
        CWE retVal = (CWE)this.getTypedField(9, 0);
        return retVal;
    }

    public DT getDateLeftPractice() {
        DT retVal = (DT)this.getTypedField(10, 0);
        return retVal;
    }

    public DT getPra10_DateLeftPractice() {
        DT retVal = (DT)this.getTypedField(10, 0);
        return retVal;
    }

    public CWE[] getGovernmentReimbursementBillingEligibility() {
        CWE[] retVal = (CWE[])this.getTypedField(11, new CWE[0]);
        return retVal;
    }

    public CWE[] getPra11_GovernmentReimbursementBillingEligibility() {
        CWE[] retVal = (CWE[])this.getTypedField(11, new CWE[0]);
        return retVal;
    }

    public int getGovernmentReimbursementBillingEligibilityReps() {
        return this.getReps(11);
    }

    public CWE getGovernmentReimbursementBillingEligibility(int rep) {
        CWE retVal = (CWE)this.getTypedField(11, rep);
        return retVal;
    }

    public CWE getPra11_GovernmentReimbursementBillingEligibility(int rep) {
        CWE retVal = (CWE)this.getTypedField(11, rep);
        return retVal;
    }

    public int getPra11_GovernmentReimbursementBillingEligibilityReps() {
        return this.getReps(11);
    }

    public CWE insertGovernmentReimbursementBillingEligibility(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(11, rep);
    }

    public CWE insertPra11_GovernmentReimbursementBillingEligibility(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(11, rep);
    }

    public CWE removeGovernmentReimbursementBillingEligibility(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(11, rep);
    }

    public CWE removePra11_GovernmentReimbursementBillingEligibility(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(11, rep);
    }

    public SI getSetIDPRA() {
        SI retVal = (SI)this.getTypedField(12, 0);
        return retVal;
    }

    public SI getPra12_SetIDPRA() {
        SI retVal = (SI)this.getTypedField(12, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CWE(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new ID(this.getMessage(), new Integer(187));
            }
            case 4: {
                return new SPD(this.getMessage());
            }
            case 5: {
                return new PLN(this.getMessage());
            }
            case 6: {
                return new PIP(this.getMessage());
            }
            case 7: {
                return new DT(this.getMessage());
            }
            case 8: {
                return new CWE(this.getMessage());
            }
            case 9: {
                return new DT(this.getMessage());
            }
            case 10: {
                return new CWE(this.getMessage());
            }
            case 11: {
                return new SI(this.getMessage());
            }
        }
        return null;
    }
}

