/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v27.datatype.CNE;
import ca.uhn.hl7v2.model.v27.datatype.CQ;
import ca.uhn.hl7v2.model.v27.datatype.CWE;
import ca.uhn.hl7v2.model.v27.datatype.CX;
import ca.uhn.hl7v2.model.v27.datatype.DTM;
import ca.uhn.hl7v2.model.v27.datatype.EI;
import ca.uhn.hl7v2.model.v27.datatype.EIP;
import ca.uhn.hl7v2.model.v27.datatype.ID;
import ca.uhn.hl7v2.model.v27.datatype.MOC;
import ca.uhn.hl7v2.model.v27.datatype.NDL;
import ca.uhn.hl7v2.model.v27.datatype.NM;
import ca.uhn.hl7v2.model.v27.datatype.NULLDT;
import ca.uhn.hl7v2.model.v27.datatype.PRL;
import ca.uhn.hl7v2.model.v27.datatype.SI;
import ca.uhn.hl7v2.model.v27.datatype.ST;
import ca.uhn.hl7v2.model.v27.datatype.XCN;
import ca.uhn.hl7v2.model.v27.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class OBR
extends AbstractSegment {
    public OBR(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage()}, "Set ID - OBR");
            this.add(EI.class, false, 1, 0, new Object[]{this.getMessage()}, "Placer Order Number");
            this.add(EI.class, false, 1, 0, new Object[]{this.getMessage()}, "Filler Order Number");
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "Universal Service Identifier");
            this.add(NULLDT.class, false, 1, 0, new Object[]{this.getMessage()}, "Priority");
            this.add(NULLDT.class, false, 1, 0, new Object[]{this.getMessage()}, "Requested Date/Time");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Observation Date/Time #");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Observation End Date/Time #");
            this.add(CQ.class, false, 1, 0, new Object[]{this.getMessage()}, "Collection Volume *");
            this.add(XCN.class, false, 0, 0, new Object[]{this.getMessage()}, "Collector Identifier *");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(65)}, "Specimen Action Code *");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Danger Code");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Relevant Clinical Information");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Specimen Received Date/Time");
            this.add(NULLDT.class, false, 1, 0, new Object[]{this.getMessage()}, "Specimen Source");
            this.add(XCN.class, false, 0, 0, new Object[]{this.getMessage()}, "Ordering Provider");
            this.add(XTN.class, false, 2, 0, new Object[]{this.getMessage()}, "Order Callback Phone Number");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Placer Field 1");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Placer Field 2");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Filler Field 1 +");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Filler Field 2 +");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Results Rpt/Status Chng - Date/Time +");
            this.add(MOC.class, false, 1, 0, new Object[]{this.getMessage()}, "Charge to Practice +");
            this.add(ID.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(74)}, "Diagnostic Serv Sect ID");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(123)}, "Result Status +");
            this.add(PRL.class, false, 1, 0, new Object[]{this.getMessage()}, "Parent Result +");
            this.add(NULLDT.class, false, 0, 0, new Object[]{this.getMessage()}, "Quantity/Timing");
            this.add(XCN.class, false, 0, 0, new Object[]{this.getMessage()}, "Result Copies To");
            this.add(EIP.class, false, 1, 0, new Object[]{this.getMessage()}, "Parent");
            this.add(ID.class, false, 1, 4, new Object[]{this.getMessage(), new Integer(124)}, "Transportation Mode");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Reason for Study");
            this.add(NDL.class, false, 1, 0, new Object[]{this.getMessage()}, "Principal Result Interpreter +");
            this.add(NDL.class, false, 0, 0, new Object[]{this.getMessage()}, "Assistant Result Interpreter +");
            this.add(NDL.class, false, 0, 0, new Object[]{this.getMessage()}, "Technician +");
            this.add(NDL.class, false, 0, 0, new Object[]{this.getMessage()}, "Transcriptionist +");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Scheduled Date/Time +");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Number of Sample Containers *");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Transport Logistics of Collected Sample *");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Collector's Comment *");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Transport Arrangement Responsibility");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(224)}, "Transport Arranged");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(225)}, "Escort Required");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Planned Patient Transport Comment");
            this.add(CNE.class, false, 1, 0, new Object[]{this.getMessage()}, "Procedure Code");
            this.add(CNE.class, false, 0, 0, new Object[]{this.getMessage()}, "Procedure Code Modifier");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Placer Supplemental Service Information");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Filler Supplemental Service Information");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Medically Necessary Duplicate Procedure Reason");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Result Handling");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Parent Universal Service Identifier");
            this.add(EI.class, false, 1, 0, new Object[]{this.getMessage()}, "Observation Group ID");
            this.add(EI.class, false, 1, 0, new Object[]{this.getMessage()}, "Parent Observation Group ID");
            this.add(CX.class, false, 0, 0, new Object[]{this.getMessage()}, "Alternate Placer Order Number");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OBR - this is probably a bug in the source code generator.", e);
        }
    }

    public SI getSetIDOBR() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getObr1_SetIDOBR() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getPlacerOrderNumber() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public EI getObr2_PlacerOrderNumber() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public EI getFillerOrderNumber() {
        EI retVal = (EI)this.getTypedField(3, 0);
        return retVal;
    }

    public EI getObr3_FillerOrderNumber() {
        EI retVal = (EI)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getUniversalServiceIdentifier() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getObr4_UniversalServiceIdentifier() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public NULLDT getPriority() {
        NULLDT retVal = (NULLDT)this.getTypedField(5, 0);
        return retVal;
    }

    public NULLDT getObr5_Priority() {
        NULLDT retVal = (NULLDT)this.getTypedField(5, 0);
        return retVal;
    }

    public NULLDT getRequestedDateTime() {
        NULLDT retVal = (NULLDT)this.getTypedField(6, 0);
        return retVal;
    }

    public NULLDT getObr6_RequestedDateTime() {
        NULLDT retVal = (NULLDT)this.getTypedField(6, 0);
        return retVal;
    }

    public DTM getObservationDateTime() {
        DTM retVal = (DTM)this.getTypedField(7, 0);
        return retVal;
    }

    public DTM getObr7_ObservationDateTime() {
        DTM retVal = (DTM)this.getTypedField(7, 0);
        return retVal;
    }

    public DTM getObservationEndDateTime() {
        DTM retVal = (DTM)this.getTypedField(8, 0);
        return retVal;
    }

    public DTM getObr8_ObservationEndDateTime() {
        DTM retVal = (DTM)this.getTypedField(8, 0);
        return retVal;
    }

    public CQ getCollectionVolume() {
        CQ retVal = (CQ)this.getTypedField(9, 0);
        return retVal;
    }

    public CQ getObr9_CollectionVolume() {
        CQ retVal = (CQ)this.getTypedField(9, 0);
        return retVal;
    }

    public XCN[] getCollectorIdentifier() {
        XCN[] retVal = (XCN[])this.getTypedField(10, new XCN[0]);
        return retVal;
    }

    public XCN[] getObr10_CollectorIdentifier() {
        XCN[] retVal = (XCN[])this.getTypedField(10, new XCN[0]);
        return retVal;
    }

    public int getCollectorIdentifierReps() {
        return this.getReps(10);
    }

    public XCN getCollectorIdentifier(int rep) {
        XCN retVal = (XCN)this.getTypedField(10, rep);
        return retVal;
    }

    public XCN getObr10_CollectorIdentifier(int rep) {
        XCN retVal = (XCN)this.getTypedField(10, rep);
        return retVal;
    }

    public int getObr10_CollectorIdentifierReps() {
        return this.getReps(10);
    }

    public XCN insertCollectorIdentifier(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(10, rep);
    }

    public XCN insertObr10_CollectorIdentifier(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(10, rep);
    }

    public XCN removeCollectorIdentifier(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(10, rep);
    }

    public XCN removeObr10_CollectorIdentifier(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(10, rep);
    }

    public ID getSpecimenActionCode() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public ID getObr11_SpecimenActionCode() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public CWE getDangerCode() {
        CWE retVal = (CWE)this.getTypedField(12, 0);
        return retVal;
    }

    public CWE getObr12_DangerCode() {
        CWE retVal = (CWE)this.getTypedField(12, 0);
        return retVal;
    }

    public ST getRelevantClinicalInformation() {
        ST retVal = (ST)this.getTypedField(13, 0);
        return retVal;
    }

    public ST getObr13_RelevantClinicalInformation() {
        ST retVal = (ST)this.getTypedField(13, 0);
        return retVal;
    }

    public DTM getSpecimenReceivedDateTime() {
        DTM retVal = (DTM)this.getTypedField(14, 0);
        return retVal;
    }

    public DTM getObr14_SpecimenReceivedDateTime() {
        DTM retVal = (DTM)this.getTypedField(14, 0);
        return retVal;
    }

    public NULLDT getSpecimenSource() {
        NULLDT retVal = (NULLDT)this.getTypedField(15, 0);
        return retVal;
    }

    public NULLDT getObr15_SpecimenSource() {
        NULLDT retVal = (NULLDT)this.getTypedField(15, 0);
        return retVal;
    }

    public XCN[] getOrderingProvider() {
        XCN[] retVal = (XCN[])this.getTypedField(16, new XCN[0]);
        return retVal;
    }

    public XCN[] getObr16_OrderingProvider() {
        XCN[] retVal = (XCN[])this.getTypedField(16, new XCN[0]);
        return retVal;
    }

    public int getOrderingProviderReps() {
        return this.getReps(16);
    }

    public XCN getOrderingProvider(int rep) {
        XCN retVal = (XCN)this.getTypedField(16, rep);
        return retVal;
    }

    public XCN getObr16_OrderingProvider(int rep) {
        XCN retVal = (XCN)this.getTypedField(16, rep);
        return retVal;
    }

    public int getObr16_OrderingProviderReps() {
        return this.getReps(16);
    }

    public XCN insertOrderingProvider(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(16, rep);
    }

    public XCN insertObr16_OrderingProvider(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(16, rep);
    }

    public XCN removeOrderingProvider(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(16, rep);
    }

    public XCN removeObr16_OrderingProvider(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(16, rep);
    }

    public XTN[] getOrderCallbackPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(17, new XTN[0]);
        return retVal;
    }

    public XTN[] getObr17_OrderCallbackPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(17, new XTN[0]);
        return retVal;
    }

    public int getOrderCallbackPhoneNumberReps() {
        return this.getReps(17);
    }

    public XTN getOrderCallbackPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(17, rep);
        return retVal;
    }

    public XTN getObr17_OrderCallbackPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(17, rep);
        return retVal;
    }

    public int getObr17_OrderCallbackPhoneNumberReps() {
        return this.getReps(17);
    }

    public XTN insertOrderCallbackPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(17, rep);
    }

    public XTN insertObr17_OrderCallbackPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(17, rep);
    }

    public XTN removeOrderCallbackPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(17, rep);
    }

    public XTN removeObr17_OrderCallbackPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(17, rep);
    }

    public ST getPlacerField1() {
        ST retVal = (ST)this.getTypedField(18, 0);
        return retVal;
    }

    public ST getObr18_PlacerField1() {
        ST retVal = (ST)this.getTypedField(18, 0);
        return retVal;
    }

    public ST getPlacerField2() {
        ST retVal = (ST)this.getTypedField(19, 0);
        return retVal;
    }

    public ST getObr19_PlacerField2() {
        ST retVal = (ST)this.getTypedField(19, 0);
        return retVal;
    }

    public ST getFillerField1() {
        ST retVal = (ST)this.getTypedField(20, 0);
        return retVal;
    }

    public ST getObr20_FillerField1() {
        ST retVal = (ST)this.getTypedField(20, 0);
        return retVal;
    }

    public ST getFillerField2() {
        ST retVal = (ST)this.getTypedField(21, 0);
        return retVal;
    }

    public ST getObr21_FillerField2() {
        ST retVal = (ST)this.getTypedField(21, 0);
        return retVal;
    }

    public DTM getResultsRptStatusChngDateTime() {
        DTM retVal = (DTM)this.getTypedField(22, 0);
        return retVal;
    }

    public DTM getObr22_ResultsRptStatusChngDateTime() {
        DTM retVal = (DTM)this.getTypedField(22, 0);
        return retVal;
    }

    public MOC getChargeToPractice() {
        MOC retVal = (MOC)this.getTypedField(23, 0);
        return retVal;
    }

    public MOC getObr23_ChargeToPractice() {
        MOC retVal = (MOC)this.getTypedField(23, 0);
        return retVal;
    }

    public ID getDiagnosticServSectID() {
        ID retVal = (ID)this.getTypedField(24, 0);
        return retVal;
    }

    public ID getObr24_DiagnosticServSectID() {
        ID retVal = (ID)this.getTypedField(24, 0);
        return retVal;
    }

    public ID getResultStatus() {
        ID retVal = (ID)this.getTypedField(25, 0);
        return retVal;
    }

    public ID getObr25_ResultStatus() {
        ID retVal = (ID)this.getTypedField(25, 0);
        return retVal;
    }

    public PRL getParentResult() {
        PRL retVal = (PRL)this.getTypedField(26, 0);
        return retVal;
    }

    public PRL getObr26_ParentResult() {
        PRL retVal = (PRL)this.getTypedField(26, 0);
        return retVal;
    }

    public NULLDT[] getQuantityTiming() {
        NULLDT[] retVal = (NULLDT[])this.getTypedField(27, new NULLDT[0]);
        return retVal;
    }

    public NULLDT[] getObr27_QuantityTiming() {
        NULLDT[] retVal = (NULLDT[])this.getTypedField(27, new NULLDT[0]);
        return retVal;
    }

    public int getQuantityTimingReps() {
        return this.getReps(27);
    }

    public NULLDT getQuantityTiming(int rep) {
        NULLDT retVal = (NULLDT)this.getTypedField(27, rep);
        return retVal;
    }

    public NULLDT getObr27_QuantityTiming(int rep) {
        NULLDT retVal = (NULLDT)this.getTypedField(27, rep);
        return retVal;
    }

    public int getObr27_QuantityTimingReps() {
        return this.getReps(27);
    }

    public NULLDT insertQuantityTiming(int rep) throws HL7Exception {
        return (NULLDT)super.insertRepetition(27, rep);
    }

    public NULLDT insertObr27_QuantityTiming(int rep) throws HL7Exception {
        return (NULLDT)super.insertRepetition(27, rep);
    }

    public NULLDT removeQuantityTiming(int rep) throws HL7Exception {
        return (NULLDT)super.removeRepetition(27, rep);
    }

    public NULLDT removeObr27_QuantityTiming(int rep) throws HL7Exception {
        return (NULLDT)super.removeRepetition(27, rep);
    }

    public XCN[] getResultCopiesTo() {
        XCN[] retVal = (XCN[])this.getTypedField(28, new XCN[0]);
        return retVal;
    }

    public XCN[] getObr28_ResultCopiesTo() {
        XCN[] retVal = (XCN[])this.getTypedField(28, new XCN[0]);
        return retVal;
    }

    public int getResultCopiesToReps() {
        return this.getReps(28);
    }

    public XCN getResultCopiesTo(int rep) {
        XCN retVal = (XCN)this.getTypedField(28, rep);
        return retVal;
    }

    public XCN getObr28_ResultCopiesTo(int rep) {
        XCN retVal = (XCN)this.getTypedField(28, rep);
        return retVal;
    }

    public int getObr28_ResultCopiesToReps() {
        return this.getReps(28);
    }

    public XCN insertResultCopiesTo(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(28, rep);
    }

    public XCN insertObr28_ResultCopiesTo(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(28, rep);
    }

    public XCN removeResultCopiesTo(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(28, rep);
    }

    public XCN removeObr28_ResultCopiesTo(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(28, rep);
    }

    public EIP getOBRParent() {
        EIP retVal = (EIP)this.getTypedField(29, 0);
        return retVal;
    }

    public EIP getObr29_Parent() {
        EIP retVal = (EIP)this.getTypedField(29, 0);
        return retVal;
    }

    public ID getTransportationMode() {
        ID retVal = (ID)this.getTypedField(30, 0);
        return retVal;
    }

    public ID getObr30_TransportationMode() {
        ID retVal = (ID)this.getTypedField(30, 0);
        return retVal;
    }

    public CWE[] getReasonForStudy() {
        CWE[] retVal = (CWE[])this.getTypedField(31, new CWE[0]);
        return retVal;
    }

    public CWE[] getObr31_ReasonForStudy() {
        CWE[] retVal = (CWE[])this.getTypedField(31, new CWE[0]);
        return retVal;
    }

    public int getReasonForStudyReps() {
        return this.getReps(31);
    }

    public CWE getReasonForStudy(int rep) {
        CWE retVal = (CWE)this.getTypedField(31, rep);
        return retVal;
    }

    public CWE getObr31_ReasonForStudy(int rep) {
        CWE retVal = (CWE)this.getTypedField(31, rep);
        return retVal;
    }

    public int getObr31_ReasonForStudyReps() {
        return this.getReps(31);
    }

    public CWE insertReasonForStudy(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(31, rep);
    }

    public CWE insertObr31_ReasonForStudy(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(31, rep);
    }

    public CWE removeReasonForStudy(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(31, rep);
    }

    public CWE removeObr31_ReasonForStudy(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(31, rep);
    }

    public NDL getPrincipalResultInterpreter() {
        NDL retVal = (NDL)this.getTypedField(32, 0);
        return retVal;
    }

    public NDL getObr32_PrincipalResultInterpreter() {
        NDL retVal = (NDL)this.getTypedField(32, 0);
        return retVal;
    }

    public NDL[] getAssistantResultInterpreter() {
        NDL[] retVal = (NDL[])this.getTypedField(33, new NDL[0]);
        return retVal;
    }

    public NDL[] getObr33_AssistantResultInterpreter() {
        NDL[] retVal = (NDL[])this.getTypedField(33, new NDL[0]);
        return retVal;
    }

    public int getAssistantResultInterpreterReps() {
        return this.getReps(33);
    }

    public NDL getAssistantResultInterpreter(int rep) {
        NDL retVal = (NDL)this.getTypedField(33, rep);
        return retVal;
    }

    public NDL getObr33_AssistantResultInterpreter(int rep) {
        NDL retVal = (NDL)this.getTypedField(33, rep);
        return retVal;
    }

    public int getObr33_AssistantResultInterpreterReps() {
        return this.getReps(33);
    }

    public NDL insertAssistantResultInterpreter(int rep) throws HL7Exception {
        return (NDL)super.insertRepetition(33, rep);
    }

    public NDL insertObr33_AssistantResultInterpreter(int rep) throws HL7Exception {
        return (NDL)super.insertRepetition(33, rep);
    }

    public NDL removeAssistantResultInterpreter(int rep) throws HL7Exception {
        return (NDL)super.removeRepetition(33, rep);
    }

    public NDL removeObr33_AssistantResultInterpreter(int rep) throws HL7Exception {
        return (NDL)super.removeRepetition(33, rep);
    }

    public NDL[] getTechnician() {
        NDL[] retVal = (NDL[])this.getTypedField(34, new NDL[0]);
        return retVal;
    }

    public NDL[] getObr34_Technician() {
        NDL[] retVal = (NDL[])this.getTypedField(34, new NDL[0]);
        return retVal;
    }

    public int getTechnicianReps() {
        return this.getReps(34);
    }

    public NDL getTechnician(int rep) {
        NDL retVal = (NDL)this.getTypedField(34, rep);
        return retVal;
    }

    public NDL getObr34_Technician(int rep) {
        NDL retVal = (NDL)this.getTypedField(34, rep);
        return retVal;
    }

    public int getObr34_TechnicianReps() {
        return this.getReps(34);
    }

    public NDL insertTechnician(int rep) throws HL7Exception {
        return (NDL)super.insertRepetition(34, rep);
    }

    public NDL insertObr34_Technician(int rep) throws HL7Exception {
        return (NDL)super.insertRepetition(34, rep);
    }

    public NDL removeTechnician(int rep) throws HL7Exception {
        return (NDL)super.removeRepetition(34, rep);
    }

    public NDL removeObr34_Technician(int rep) throws HL7Exception {
        return (NDL)super.removeRepetition(34, rep);
    }

    public NDL[] getTranscriptionist() {
        NDL[] retVal = (NDL[])this.getTypedField(35, new NDL[0]);
        return retVal;
    }

    public NDL[] getObr35_Transcriptionist() {
        NDL[] retVal = (NDL[])this.getTypedField(35, new NDL[0]);
        return retVal;
    }

    public int getTranscriptionistReps() {
        return this.getReps(35);
    }

    public NDL getTranscriptionist(int rep) {
        NDL retVal = (NDL)this.getTypedField(35, rep);
        return retVal;
    }

    public NDL getObr35_Transcriptionist(int rep) {
        NDL retVal = (NDL)this.getTypedField(35, rep);
        return retVal;
    }

    public int getObr35_TranscriptionistReps() {
        return this.getReps(35);
    }

    public NDL insertTranscriptionist(int rep) throws HL7Exception {
        return (NDL)super.insertRepetition(35, rep);
    }

    public NDL insertObr35_Transcriptionist(int rep) throws HL7Exception {
        return (NDL)super.insertRepetition(35, rep);
    }

    public NDL removeTranscriptionist(int rep) throws HL7Exception {
        return (NDL)super.removeRepetition(35, rep);
    }

    public NDL removeObr35_Transcriptionist(int rep) throws HL7Exception {
        return (NDL)super.removeRepetition(35, rep);
    }

    public DTM getScheduledDateTime() {
        DTM retVal = (DTM)this.getTypedField(36, 0);
        return retVal;
    }

    public DTM getObr36_ScheduledDateTime() {
        DTM retVal = (DTM)this.getTypedField(36, 0);
        return retVal;
    }

    public NM getNumberOfSampleContainers() {
        NM retVal = (NM)this.getTypedField(37, 0);
        return retVal;
    }

    public NM getObr37_NumberOfSampleContainers() {
        NM retVal = (NM)this.getTypedField(37, 0);
        return retVal;
    }

    public CWE[] getTransportLogisticsOfCollectedSample() {
        CWE[] retVal = (CWE[])this.getTypedField(38, new CWE[0]);
        return retVal;
    }

    public CWE[] getObr38_TransportLogisticsOfCollectedSample() {
        CWE[] retVal = (CWE[])this.getTypedField(38, new CWE[0]);
        return retVal;
    }

    public int getTransportLogisticsOfCollectedSampleReps() {
        return this.getReps(38);
    }

    public CWE getTransportLogisticsOfCollectedSample(int rep) {
        CWE retVal = (CWE)this.getTypedField(38, rep);
        return retVal;
    }

    public CWE getObr38_TransportLogisticsOfCollectedSample(int rep) {
        CWE retVal = (CWE)this.getTypedField(38, rep);
        return retVal;
    }

    public int getObr38_TransportLogisticsOfCollectedSampleReps() {
        return this.getReps(38);
    }

    public CWE insertTransportLogisticsOfCollectedSample(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(38, rep);
    }

    public CWE insertObr38_TransportLogisticsOfCollectedSample(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(38, rep);
    }

    public CWE removeTransportLogisticsOfCollectedSample(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(38, rep);
    }

    public CWE removeObr38_TransportLogisticsOfCollectedSample(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(38, rep);
    }

    public CWE[] getCollectorSComment() {
        CWE[] retVal = (CWE[])this.getTypedField(39, new CWE[0]);
        return retVal;
    }

    public CWE[] getObr39_CollectorSComment() {
        CWE[] retVal = (CWE[])this.getTypedField(39, new CWE[0]);
        return retVal;
    }

    public int getCollectorSCommentReps() {
        return this.getReps(39);
    }

    public CWE getCollectorSComment(int rep) {
        CWE retVal = (CWE)this.getTypedField(39, rep);
        return retVal;
    }

    public CWE getObr39_CollectorSComment(int rep) {
        CWE retVal = (CWE)this.getTypedField(39, rep);
        return retVal;
    }

    public int getObr39_CollectorSCommentReps() {
        return this.getReps(39);
    }

    public CWE insertCollectorSComment(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(39, rep);
    }

    public CWE insertObr39_CollectorSComment(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(39, rep);
    }

    public CWE removeCollectorSComment(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(39, rep);
    }

    public CWE removeObr39_CollectorSComment(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(39, rep);
    }

    public CWE getTransportArrangementResponsibility() {
        CWE retVal = (CWE)this.getTypedField(40, 0);
        return retVal;
    }

    public CWE getObr40_TransportArrangementResponsibility() {
        CWE retVal = (CWE)this.getTypedField(40, 0);
        return retVal;
    }

    public ID getTransportArranged() {
        ID retVal = (ID)this.getTypedField(41, 0);
        return retVal;
    }

    public ID getObr41_TransportArranged() {
        ID retVal = (ID)this.getTypedField(41, 0);
        return retVal;
    }

    public ID getEscortRequired() {
        ID retVal = (ID)this.getTypedField(42, 0);
        return retVal;
    }

    public ID getObr42_EscortRequired() {
        ID retVal = (ID)this.getTypedField(42, 0);
        return retVal;
    }

    public CWE[] getPlannedPatientTransportComment() {
        CWE[] retVal = (CWE[])this.getTypedField(43, new CWE[0]);
        return retVal;
    }

    public CWE[] getObr43_PlannedPatientTransportComment() {
        CWE[] retVal = (CWE[])this.getTypedField(43, new CWE[0]);
        return retVal;
    }

    public int getPlannedPatientTransportCommentReps() {
        return this.getReps(43);
    }

    public CWE getPlannedPatientTransportComment(int rep) {
        CWE retVal = (CWE)this.getTypedField(43, rep);
        return retVal;
    }

    public CWE getObr43_PlannedPatientTransportComment(int rep) {
        CWE retVal = (CWE)this.getTypedField(43, rep);
        return retVal;
    }

    public int getObr43_PlannedPatientTransportCommentReps() {
        return this.getReps(43);
    }

    public CWE insertPlannedPatientTransportComment(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(43, rep);
    }

    public CWE insertObr43_PlannedPatientTransportComment(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(43, rep);
    }

    public CWE removePlannedPatientTransportComment(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(43, rep);
    }

    public CWE removeObr43_PlannedPatientTransportComment(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(43, rep);
    }

    public CNE getProcedureCode() {
        CNE retVal = (CNE)this.getTypedField(44, 0);
        return retVal;
    }

    public CNE getObr44_ProcedureCode() {
        CNE retVal = (CNE)this.getTypedField(44, 0);
        return retVal;
    }

    public CNE[] getProcedureCodeModifier() {
        CNE[] retVal = (CNE[])this.getTypedField(45, new CNE[0]);
        return retVal;
    }

    public CNE[] getObr45_ProcedureCodeModifier() {
        CNE[] retVal = (CNE[])this.getTypedField(45, new CNE[0]);
        return retVal;
    }

    public int getProcedureCodeModifierReps() {
        return this.getReps(45);
    }

    public CNE getProcedureCodeModifier(int rep) {
        CNE retVal = (CNE)this.getTypedField(45, rep);
        return retVal;
    }

    public CNE getObr45_ProcedureCodeModifier(int rep) {
        CNE retVal = (CNE)this.getTypedField(45, rep);
        return retVal;
    }

    public int getObr45_ProcedureCodeModifierReps() {
        return this.getReps(45);
    }

    public CNE insertProcedureCodeModifier(int rep) throws HL7Exception {
        return (CNE)super.insertRepetition(45, rep);
    }

    public CNE insertObr45_ProcedureCodeModifier(int rep) throws HL7Exception {
        return (CNE)super.insertRepetition(45, rep);
    }

    public CNE removeProcedureCodeModifier(int rep) throws HL7Exception {
        return (CNE)super.removeRepetition(45, rep);
    }

    public CNE removeObr45_ProcedureCodeModifier(int rep) throws HL7Exception {
        return (CNE)super.removeRepetition(45, rep);
    }

    public CWE[] getPlacerSupplementalServiceInformation() {
        CWE[] retVal = (CWE[])this.getTypedField(46, new CWE[0]);
        return retVal;
    }

    public CWE[] getObr46_PlacerSupplementalServiceInformation() {
        CWE[] retVal = (CWE[])this.getTypedField(46, new CWE[0]);
        return retVal;
    }

    public int getPlacerSupplementalServiceInformationReps() {
        return this.getReps(46);
    }

    public CWE getPlacerSupplementalServiceInformation(int rep) {
        CWE retVal = (CWE)this.getTypedField(46, rep);
        return retVal;
    }

    public CWE getObr46_PlacerSupplementalServiceInformation(int rep) {
        CWE retVal = (CWE)this.getTypedField(46, rep);
        return retVal;
    }

    public int getObr46_PlacerSupplementalServiceInformationReps() {
        return this.getReps(46);
    }

    public CWE insertPlacerSupplementalServiceInformation(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(46, rep);
    }

    public CWE insertObr46_PlacerSupplementalServiceInformation(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(46, rep);
    }

    public CWE removePlacerSupplementalServiceInformation(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(46, rep);
    }

    public CWE removeObr46_PlacerSupplementalServiceInformation(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(46, rep);
    }

    public CWE[] getFillerSupplementalServiceInformation() {
        CWE[] retVal = (CWE[])this.getTypedField(47, new CWE[0]);
        return retVal;
    }

    public CWE[] getObr47_FillerSupplementalServiceInformation() {
        CWE[] retVal = (CWE[])this.getTypedField(47, new CWE[0]);
        return retVal;
    }

    public int getFillerSupplementalServiceInformationReps() {
        return this.getReps(47);
    }

    public CWE getFillerSupplementalServiceInformation(int rep) {
        CWE retVal = (CWE)this.getTypedField(47, rep);
        return retVal;
    }

    public CWE getObr47_FillerSupplementalServiceInformation(int rep) {
        CWE retVal = (CWE)this.getTypedField(47, rep);
        return retVal;
    }

    public int getObr47_FillerSupplementalServiceInformationReps() {
        return this.getReps(47);
    }

    public CWE insertFillerSupplementalServiceInformation(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(47, rep);
    }

    public CWE insertObr47_FillerSupplementalServiceInformation(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(47, rep);
    }

    public CWE removeFillerSupplementalServiceInformation(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(47, rep);
    }

    public CWE removeObr47_FillerSupplementalServiceInformation(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(47, rep);
    }

    public CWE getMedicallyNecessaryDuplicateProcedureReason() {
        CWE retVal = (CWE)this.getTypedField(48, 0);
        return retVal;
    }

    public CWE getObr48_MedicallyNecessaryDuplicateProcedureReason() {
        CWE retVal = (CWE)this.getTypedField(48, 0);
        return retVal;
    }

    public CWE getResultHandling() {
        CWE retVal = (CWE)this.getTypedField(49, 0);
        return retVal;
    }

    public CWE getObr49_ResultHandling() {
        CWE retVal = (CWE)this.getTypedField(49, 0);
        return retVal;
    }

    public CWE getParentUniversalServiceIdentifier() {
        CWE retVal = (CWE)this.getTypedField(50, 0);
        return retVal;
    }

    public CWE getObr50_ParentUniversalServiceIdentifier() {
        CWE retVal = (CWE)this.getTypedField(50, 0);
        return retVal;
    }

    public EI getObservationGroupID() {
        EI retVal = (EI)this.getTypedField(51, 0);
        return retVal;
    }

    public EI getObr51_ObservationGroupID() {
        EI retVal = (EI)this.getTypedField(51, 0);
        return retVal;
    }

    public EI getParentObservationGroupID() {
        EI retVal = (EI)this.getTypedField(52, 0);
        return retVal;
    }

    public EI getObr52_ParentObservationGroupID() {
        EI retVal = (EI)this.getTypedField(52, 0);
        return retVal;
    }

    public CX[] getAlternatePlacerOrderNumber() {
        CX[] retVal = (CX[])this.getTypedField(53, new CX[0]);
        return retVal;
    }

    public CX[] getObr53_AlternatePlacerOrderNumber() {
        CX[] retVal = (CX[])this.getTypedField(53, new CX[0]);
        return retVal;
    }

    public int getAlternatePlacerOrderNumberReps() {
        return this.getReps(53);
    }

    public CX getAlternatePlacerOrderNumber(int rep) {
        CX retVal = (CX)this.getTypedField(53, rep);
        return retVal;
    }

    public CX getObr53_AlternatePlacerOrderNumber(int rep) {
        CX retVal = (CX)this.getTypedField(53, rep);
        return retVal;
    }

    public int getObr53_AlternatePlacerOrderNumberReps() {
        return this.getReps(53);
    }

    public CX insertAlternatePlacerOrderNumber(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(53, rep);
    }

    public CX insertObr53_AlternatePlacerOrderNumber(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(53, rep);
    }

    public CX removeAlternatePlacerOrderNumber(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(53, rep);
    }

    public CX removeObr53_AlternatePlacerOrderNumber(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(53, rep);
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new EI(this.getMessage());
            }
            case 2: {
                return new EI(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
            case 4: {
                return new NULLDT(this.getMessage());
            }
            case 5: {
                return new NULLDT(this.getMessage());
            }
            case 6: {
                return new DTM(this.getMessage());
            }
            case 7: {
                return new DTM(this.getMessage());
            }
            case 8: {
                return new CQ(this.getMessage());
            }
            case 9: {
                return new XCN(this.getMessage());
            }
            case 10: {
                return new ID(this.getMessage(), new Integer(65));
            }
            case 11: {
                return new CWE(this.getMessage());
            }
            case 12: {
                return new ST(this.getMessage());
            }
            case 13: {
                return new DTM(this.getMessage());
            }
            case 14: {
                return new NULLDT(this.getMessage());
            }
            case 15: {
                return new XCN(this.getMessage());
            }
            case 16: {
                return new XTN(this.getMessage());
            }
            case 17: {
                return new ST(this.getMessage());
            }
            case 18: {
                return new ST(this.getMessage());
            }
            case 19: {
                return new ST(this.getMessage());
            }
            case 20: {
                return new ST(this.getMessage());
            }
            case 21: {
                return new DTM(this.getMessage());
            }
            case 22: {
                return new MOC(this.getMessage());
            }
            case 23: {
                return new ID(this.getMessage(), new Integer(74));
            }
            case 24: {
                return new ID(this.getMessage(), new Integer(123));
            }
            case 25: {
                return new PRL(this.getMessage());
            }
            case 26: {
                return new NULLDT(this.getMessage());
            }
            case 27: {
                return new XCN(this.getMessage());
            }
            case 28: {
                return new EIP(this.getMessage());
            }
            case 29: {
                return new ID(this.getMessage(), new Integer(124));
            }
            case 30: {
                return new CWE(this.getMessage());
            }
            case 31: {
                return new NDL(this.getMessage());
            }
            case 32: {
                return new NDL(this.getMessage());
            }
            case 33: {
                return new NDL(this.getMessage());
            }
            case 34: {
                return new NDL(this.getMessage());
            }
            case 35: {
                return new DTM(this.getMessage());
            }
            case 36: {
                return new NM(this.getMessage());
            }
            case 37: {
                return new CWE(this.getMessage());
            }
            case 38: {
                return new CWE(this.getMessage());
            }
            case 39: {
                return new CWE(this.getMessage());
            }
            case 40: {
                return new ID(this.getMessage(), new Integer(224));
            }
            case 41: {
                return new ID(this.getMessage(), new Integer(225));
            }
            case 42: {
                return new CWE(this.getMessage());
            }
            case 43: {
                return new CNE(this.getMessage());
            }
            case 44: {
                return new CNE(this.getMessage());
            }
            case 45: {
                return new CWE(this.getMessage());
            }
            case 46: {
                return new CWE(this.getMessage());
            }
            case 47: {
                return new CWE(this.getMessage());
            }
            case 48: {
                return new CWE(this.getMessage());
            }
            case 49: {
                return new CWE(this.getMessage());
            }
            case 50: {
                return new EI(this.getMessage());
            }
            case 51: {
                return new EI(this.getMessage());
            }
            case 52: {
                return new CX(this.getMessage());
            }
        }
        return null;
    }
}

