/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v27.datatype.EI;
import ca.uhn.hl7v2.model.v27.datatype.ID;
import ca.uhn.hl7v2.model.v27.datatype.ST;
import ca.uhn.hl7v2.model.v27.datatype.XAD;
import ca.uhn.hl7v2.model.v27.datatype.XCN;
import ca.uhn.hl7v2.model.v27.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class FAC
extends AbstractSegment {
    public FAC(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(EI.class, true, 1, 0, new Object[]{this.getMessage()}, "Facility ID-FAC");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(331)}, "Facility Type");
            this.add(XAD.class, true, 0, 0, new Object[]{this.getMessage()}, "Facility Address");
            this.add(XTN.class, true, 1, 0, new Object[]{this.getMessage()}, "Facility Telecommunication");
            this.add(XCN.class, false, 0, 0, new Object[]{this.getMessage()}, "Contact Person");
            this.add(ST.class, false, 0, 0, new Object[]{this.getMessage()}, "Contact Title");
            this.add(XAD.class, false, 0, 0, new Object[]{this.getMessage()}, "Contact Address");
            this.add(XTN.class, false, 0, 0, new Object[]{this.getMessage()}, "Contact Telecommunication");
            this.add(XCN.class, true, 0, 0, new Object[]{this.getMessage()}, "Signature Authority");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Signature Authority Title");
            this.add(XAD.class, false, 0, 0, new Object[]{this.getMessage()}, "Signature Authority Address");
            this.add(XTN.class, false, 1, 0, new Object[]{this.getMessage()}, "Signature Authority Telecommunication");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating FAC - this is probably a bug in the source code generator.", e);
        }
    }

    public EI getFacilityIDFAC() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getFac1_FacilityIDFAC() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getFacilityType() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getFac2_FacilityType() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public XAD[] getFacilityAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(3, new XAD[0]);
        return retVal;
    }

    public XAD[] getFac3_FacilityAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(3, new XAD[0]);
        return retVal;
    }

    public int getFacilityAddressReps() {
        return this.getReps(3);
    }

    public XAD getFacilityAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(3, rep);
        return retVal;
    }

    public XAD getFac3_FacilityAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(3, rep);
        return retVal;
    }

    public int getFac3_FacilityAddressReps() {
        return this.getReps(3);
    }

    public XAD insertFacilityAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(3, rep);
    }

    public XAD insertFac3_FacilityAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(3, rep);
    }

    public XAD removeFacilityAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(3, rep);
    }

    public XAD removeFac3_FacilityAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(3, rep);
    }

    public XTN getFacilityTelecommunication() {
        XTN retVal = (XTN)this.getTypedField(4, 0);
        return retVal;
    }

    public XTN getFac4_FacilityTelecommunication() {
        XTN retVal = (XTN)this.getTypedField(4, 0);
        return retVal;
    }

    public XCN[] getContactPerson() {
        XCN[] retVal = (XCN[])this.getTypedField(5, new XCN[0]);
        return retVal;
    }

    public XCN[] getFac5_ContactPerson() {
        XCN[] retVal = (XCN[])this.getTypedField(5, new XCN[0]);
        return retVal;
    }

    public int getContactPersonReps() {
        return this.getReps(5);
    }

    public XCN getContactPerson(int rep) {
        XCN retVal = (XCN)this.getTypedField(5, rep);
        return retVal;
    }

    public XCN getFac5_ContactPerson(int rep) {
        XCN retVal = (XCN)this.getTypedField(5, rep);
        return retVal;
    }

    public int getFac5_ContactPersonReps() {
        return this.getReps(5);
    }

    public XCN insertContactPerson(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(5, rep);
    }

    public XCN insertFac5_ContactPerson(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(5, rep);
    }

    public XCN removeContactPerson(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(5, rep);
    }

    public XCN removeFac5_ContactPerson(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(5, rep);
    }

    public ST[] getContactTitle() {
        ST[] retVal = (ST[])this.getTypedField(6, new ST[0]);
        return retVal;
    }

    public ST[] getFac6_ContactTitle() {
        ST[] retVal = (ST[])this.getTypedField(6, new ST[0]);
        return retVal;
    }

    public int getContactTitleReps() {
        return this.getReps(6);
    }

    public ST getContactTitle(int rep) {
        ST retVal = (ST)this.getTypedField(6, rep);
        return retVal;
    }

    public ST getFac6_ContactTitle(int rep) {
        ST retVal = (ST)this.getTypedField(6, rep);
        return retVal;
    }

    public int getFac6_ContactTitleReps() {
        return this.getReps(6);
    }

    public ST insertContactTitle(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(6, rep);
    }

    public ST insertFac6_ContactTitle(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(6, rep);
    }

    public ST removeContactTitle(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(6, rep);
    }

    public ST removeFac6_ContactTitle(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(6, rep);
    }

    public XAD[] getContactAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(7, new XAD[0]);
        return retVal;
    }

    public XAD[] getFac7_ContactAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(7, new XAD[0]);
        return retVal;
    }

    public int getContactAddressReps() {
        return this.getReps(7);
    }

    public XAD getContactAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(7, rep);
        return retVal;
    }

    public XAD getFac7_ContactAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(7, rep);
        return retVal;
    }

    public int getFac7_ContactAddressReps() {
        return this.getReps(7);
    }

    public XAD insertContactAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(7, rep);
    }

    public XAD insertFac7_ContactAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(7, rep);
    }

    public XAD removeContactAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(7, rep);
    }

    public XAD removeFac7_ContactAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(7, rep);
    }

    public XTN[] getContactTelecommunication() {
        XTN[] retVal = (XTN[])this.getTypedField(8, new XTN[0]);
        return retVal;
    }

    public XTN[] getFac8_ContactTelecommunication() {
        XTN[] retVal = (XTN[])this.getTypedField(8, new XTN[0]);
        return retVal;
    }

    public int getContactTelecommunicationReps() {
        return this.getReps(8);
    }

    public XTN getContactTelecommunication(int rep) {
        XTN retVal = (XTN)this.getTypedField(8, rep);
        return retVal;
    }

    public XTN getFac8_ContactTelecommunication(int rep) {
        XTN retVal = (XTN)this.getTypedField(8, rep);
        return retVal;
    }

    public int getFac8_ContactTelecommunicationReps() {
        return this.getReps(8);
    }

    public XTN insertContactTelecommunication(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(8, rep);
    }

    public XTN insertFac8_ContactTelecommunication(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(8, rep);
    }

    public XTN removeContactTelecommunication(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(8, rep);
    }

    public XTN removeFac8_ContactTelecommunication(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(8, rep);
    }

    public XCN[] getSignatureAuthority() {
        XCN[] retVal = (XCN[])this.getTypedField(9, new XCN[0]);
        return retVal;
    }

    public XCN[] getFac9_SignatureAuthority() {
        XCN[] retVal = (XCN[])this.getTypedField(9, new XCN[0]);
        return retVal;
    }

    public int getSignatureAuthorityReps() {
        return this.getReps(9);
    }

    public XCN getSignatureAuthority(int rep) {
        XCN retVal = (XCN)this.getTypedField(9, rep);
        return retVal;
    }

    public XCN getFac9_SignatureAuthority(int rep) {
        XCN retVal = (XCN)this.getTypedField(9, rep);
        return retVal;
    }

    public int getFac9_SignatureAuthorityReps() {
        return this.getReps(9);
    }

    public XCN insertSignatureAuthority(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(9, rep);
    }

    public XCN insertFac9_SignatureAuthority(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(9, rep);
    }

    public XCN removeSignatureAuthority(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(9, rep);
    }

    public XCN removeFac9_SignatureAuthority(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(9, rep);
    }

    public ST getSignatureAuthorityTitle() {
        ST retVal = (ST)this.getTypedField(10, 0);
        return retVal;
    }

    public ST getFac10_SignatureAuthorityTitle() {
        ST retVal = (ST)this.getTypedField(10, 0);
        return retVal;
    }

    public XAD[] getSignatureAuthorityAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(11, new XAD[0]);
        return retVal;
    }

    public XAD[] getFac11_SignatureAuthorityAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(11, new XAD[0]);
        return retVal;
    }

    public int getSignatureAuthorityAddressReps() {
        return this.getReps(11);
    }

    public XAD getSignatureAuthorityAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(11, rep);
        return retVal;
    }

    public XAD getFac11_SignatureAuthorityAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(11, rep);
        return retVal;
    }

    public int getFac11_SignatureAuthorityAddressReps() {
        return this.getReps(11);
    }

    public XAD insertSignatureAuthorityAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(11, rep);
    }

    public XAD insertFac11_SignatureAuthorityAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(11, rep);
    }

    public XAD removeSignatureAuthorityAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(11, rep);
    }

    public XAD removeFac11_SignatureAuthorityAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(11, rep);
    }

    public XTN getSignatureAuthorityTelecommunication() {
        XTN retVal = (XTN)this.getTypedField(12, 0);
        return retVal;
    }

    public XTN getFac12_SignatureAuthorityTelecommunication() {
        XTN retVal = (XTN)this.getTypedField(12, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new EI(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(331));
            }
            case 2: {
                return new XAD(this.getMessage());
            }
            case 3: {
                return new XTN(this.getMessage());
            }
            case 4: {
                return new XCN(this.getMessage());
            }
            case 5: {
                return new ST(this.getMessage());
            }
            case 6: {
                return new XAD(this.getMessage());
            }
            case 7: {
                return new XTN(this.getMessage());
            }
            case 8: {
                return new XCN(this.getMessage());
            }
            case 9: {
                return new ST(this.getMessage());
            }
            case 10: {
                return new XAD(this.getMessage());
            }
            case 11: {
                return new XTN(this.getMessage());
            }
        }
        return null;
    }
}

