/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v27.group.VXU_V04_OBSERVATION;
import ca.uhn.hl7v2.model.v27.group.VXU_V04_TIMING;
import ca.uhn.hl7v2.model.v27.segment.ORC;
import ca.uhn.hl7v2.model.v27.segment.RXA;
import ca.uhn.hl7v2.model.v27.segment.RXR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class VXU_V04_ORDER
extends AbstractGroup {
    public VXU_V04_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false, false);
            this.add(VXU_V04_TIMING.class, false, true, false);
            this.add(RXA.class, true, false, false);
            this.add(RXR.class, false, false, false);
            this.add(VXU_V04_OBSERVATION.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating VXU_V04_ORDER - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.7";
    }

    public ORC getORC() {
        ORC retVal = this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public VXU_V04_TIMING getTIMING() {
        VXU_V04_TIMING retVal = this.getTyped("TIMING", VXU_V04_TIMING.class);
        return retVal;
    }

    public VXU_V04_TIMING getTIMING(int rep) {
        VXU_V04_TIMING retVal = this.getTyped("TIMING", rep, VXU_V04_TIMING.class);
        return retVal;
    }

    public int getTIMINGReps() {
        return this.getReps("TIMING");
    }

    public List<VXU_V04_TIMING> getTIMINGAll() throws HL7Exception {
        return this.getAllAsList("TIMING", VXU_V04_TIMING.class);
    }

    public void insertTIMING(VXU_V04_TIMING structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING", structure, rep);
    }

    public VXU_V04_TIMING insertTIMING(int rep) throws HL7Exception {
        return (VXU_V04_TIMING)super.insertRepetition("TIMING", rep);
    }

    public VXU_V04_TIMING removeTIMING(int rep) throws HL7Exception {
        return (VXU_V04_TIMING)super.removeRepetition("TIMING", rep);
    }

    public RXA getRXA() {
        RXA retVal = this.getTyped("RXA", RXA.class);
        return retVal;
    }

    public RXR getRXR() {
        RXR retVal = this.getTyped("RXR", RXR.class);
        return retVal;
    }

    public VXU_V04_OBSERVATION getOBSERVATION() {
        VXU_V04_OBSERVATION retVal = this.getTyped("OBSERVATION", VXU_V04_OBSERVATION.class);
        return retVal;
    }

    public VXU_V04_OBSERVATION getOBSERVATION(int rep) {
        VXU_V04_OBSERVATION retVal = this.getTyped("OBSERVATION", rep, VXU_V04_OBSERVATION.class);
        return retVal;
    }

    public int getOBSERVATIONReps() {
        return this.getReps("OBSERVATION");
    }

    public List<VXU_V04_OBSERVATION> getOBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("OBSERVATION", VXU_V04_OBSERVATION.class);
    }

    public void insertOBSERVATION(VXU_V04_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", structure, rep);
    }

    public VXU_V04_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (VXU_V04_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public VXU_V04_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (VXU_V04_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }
}

