/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v26.group.OPU_R25_PATIENT_OBSERVATION;
import ca.uhn.hl7v2.model.v26.segment.PD1;
import ca.uhn.hl7v2.model.v26.segment.PID;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class OPU_R25_PATIENT
extends AbstractGroup {
    public OPU_R25_PATIENT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PID.class, true, false, false);
            this.add(PD1.class, false, false, false);
            this.add(OPU_R25_PATIENT_OBSERVATION.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OPU_R25_PATIENT - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public PID getPID() {
        PID retVal = this.getTyped("PID", PID.class);
        return retVal;
    }

    public PD1 getPD1() {
        PD1 retVal = this.getTyped("PD1", PD1.class);
        return retVal;
    }

    public OPU_R25_PATIENT_OBSERVATION getPATIENT_OBSERVATION() {
        OPU_R25_PATIENT_OBSERVATION retVal = this.getTyped("PATIENT_OBSERVATION", OPU_R25_PATIENT_OBSERVATION.class);
        return retVal;
    }

    public OPU_R25_PATIENT_OBSERVATION getPATIENT_OBSERVATION(int rep) {
        OPU_R25_PATIENT_OBSERVATION retVal = this.getTyped("PATIENT_OBSERVATION", rep, OPU_R25_PATIENT_OBSERVATION.class);
        return retVal;
    }

    public int getPATIENT_OBSERVATIONReps() {
        return this.getReps("PATIENT_OBSERVATION");
    }

    public List<OPU_R25_PATIENT_OBSERVATION> getPATIENT_OBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("PATIENT_OBSERVATION", OPU_R25_PATIENT_OBSERVATION.class);
    }

    public void insertPATIENT_OBSERVATION(OPU_R25_PATIENT_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("PATIENT_OBSERVATION", structure, rep);
    }

    public OPU_R25_PATIENT_OBSERVATION insertPATIENT_OBSERVATION(int rep) throws HL7Exception {
        return (OPU_R25_PATIENT_OBSERVATION)super.insertRepetition("PATIENT_OBSERVATION", rep);
    }

    public OPU_R25_PATIENT_OBSERVATION removePATIENT_OBSERVATION(int rep) throws HL7Exception {
        return (OPU_R25_PATIENT_OBSERVATION)super.removeRepetition("PATIENT_OBSERVATION", rep);
    }
}

