/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v26.group.OPL_O37_INSURANCE;
import ca.uhn.hl7v2.model.v26.segment.AL1;
import ca.uhn.hl7v2.model.v26.segment.OBX;
import ca.uhn.hl7v2.model.v26.segment.PD1;
import ca.uhn.hl7v2.model.v26.segment.PID;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class OPL_O37_PATIENT
extends AbstractGroup {
    public OPL_O37_PATIENT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PID.class, true, false, false);
            this.add(PD1.class, false, false, false);
            this.add(OBX.class, false, true, false);
            this.add(OPL_O37_INSURANCE.class, false, true, false);
            this.add(AL1.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OPL_O37_PATIENT - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public PID getPID() {
        PID retVal = this.getTyped("PID", PID.class);
        return retVal;
    }

    public PD1 getPD1() {
        PD1 retVal = this.getTyped("PD1", PD1.class);
        return retVal;
    }

    public OBX getOBX() {
        OBX retVal = this.getTyped("OBX", OBX.class);
        return retVal;
    }

    public OBX getOBX(int rep) {
        OBX retVal = this.getTyped("OBX", rep, OBX.class);
        return retVal;
    }

    public int getOBXReps() {
        return this.getReps("OBX");
    }

    public List<OBX> getOBXAll() throws HL7Exception {
        return this.getAllAsList("OBX", OBX.class);
    }

    public void insertOBX(OBX structure, int rep) throws HL7Exception {
        super.insertRepetition("OBX", structure, rep);
    }

    public OBX insertOBX(int rep) throws HL7Exception {
        return (OBX)super.insertRepetition("OBX", rep);
    }

    public OBX removeOBX(int rep) throws HL7Exception {
        return (OBX)super.removeRepetition("OBX", rep);
    }

    public OPL_O37_INSURANCE getINSURANCE() {
        OPL_O37_INSURANCE retVal = this.getTyped("INSURANCE", OPL_O37_INSURANCE.class);
        return retVal;
    }

    public OPL_O37_INSURANCE getINSURANCE(int rep) {
        OPL_O37_INSURANCE retVal = this.getTyped("INSURANCE", rep, OPL_O37_INSURANCE.class);
        return retVal;
    }

    public int getINSURANCEReps() {
        return this.getReps("INSURANCE");
    }

    public List<OPL_O37_INSURANCE> getINSURANCEAll() throws HL7Exception {
        return this.getAllAsList("INSURANCE", OPL_O37_INSURANCE.class);
    }

    public void insertINSURANCE(OPL_O37_INSURANCE structure, int rep) throws HL7Exception {
        super.insertRepetition("INSURANCE", structure, rep);
    }

    public OPL_O37_INSURANCE insertINSURANCE(int rep) throws HL7Exception {
        return (OPL_O37_INSURANCE)super.insertRepetition("INSURANCE", rep);
    }

    public OPL_O37_INSURANCE removeINSURANCE(int rep) throws HL7Exception {
        return (OPL_O37_INSURANCE)super.removeRepetition("INSURANCE", rep);
    }

    public AL1 getAL1() {
        AL1 retVal = this.getTyped("AL1", AL1.class);
        return retVal;
    }

    public AL1 getAL1(int rep) {
        AL1 retVal = this.getTyped("AL1", rep, AL1.class);
        return retVal;
    }

    public int getAL1Reps() {
        return this.getReps("AL1");
    }

    public List<AL1> getAL1All() throws HL7Exception {
        return this.getAllAsList("AL1", AL1.class);
    }

    public void insertAL1(AL1 structure, int rep) throws HL7Exception {
        super.insertRepetition("AL1", structure, rep);
    }

    public AL1 insertAL1(int rep) throws HL7Exception {
        return (AL1)super.insertRepetition("AL1", rep);
    }

    public AL1 removeAL1(int rep) throws HL7Exception {
        return (AL1)super.removeRepetition("AL1", rep);
    }
}

