/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CQ;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.DTM;
import ca.uhn.hl7v2.model.v26.datatype.ID;
import ca.uhn.hl7v2.model.v26.datatype.NM;
import ca.uhn.hl7v2.model.v26.datatype.OSD;
import ca.uhn.hl7v2.model.v26.datatype.RI;
import ca.uhn.hl7v2.model.v26.datatype.ST;
import ca.uhn.hl7v2.model.v26.datatype.TX;

public class TQ
extends AbstractComposite {
    private Type[] data;

    public TQ(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[12];
        this.data[0] = new CQ(this.getMessage());
        this.data[1] = new RI(this.getMessage());
        this.data[2] = new ST(this.getMessage());
        this.data[3] = new DTM(this.getMessage());
        this.data[4] = new DTM(this.getMessage());
        this.data[5] = new ST(this.getMessage());
        this.data[6] = new ST(this.getMessage());
        this.data[7] = new TX(this.getMessage());
        this.data[8] = new ID(this.getMessage(), 472);
        this.data[9] = new OSD(this.getMessage());
        this.data[10] = new CWE(this.getMessage());
        this.data[11] = new NM(this.getMessage());
    }

    @Override
    public Type[] getComponents() {
        return this.data;
    }

    @Override
    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + this.getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public CQ getQuantity() {
        return this.getTyped(0, CQ.class);
    }

    public CQ getTq1_Quantity() {
        return this.getTyped(0, CQ.class);
    }

    public RI getInterval() {
        return this.getTyped(1, RI.class);
    }

    public RI getTq2_Interval() {
        return this.getTyped(1, RI.class);
    }

    public ST getDuration() {
        return this.getTyped(2, ST.class);
    }

    public ST getTq3_Duration() {
        return this.getTyped(2, ST.class);
    }

    public DTM getStartDateTime() {
        return this.getTyped(3, DTM.class);
    }

    public DTM getTq4_StartDateTime() {
        return this.getTyped(3, DTM.class);
    }

    public DTM getEndDateTime() {
        return this.getTyped(4, DTM.class);
    }

    public DTM getTq5_EndDateTime() {
        return this.getTyped(4, DTM.class);
    }

    public ST getPriority() {
        return this.getTyped(5, ST.class);
    }

    public ST getTq6_Priority() {
        return this.getTyped(5, ST.class);
    }

    public ST getCondition() {
        return this.getTyped(6, ST.class);
    }

    public ST getTq7_Condition() {
        return this.getTyped(6, ST.class);
    }

    public TX getText() {
        return this.getTyped(7, TX.class);
    }

    public TX getTq8_Text() {
        return this.getTyped(7, TX.class);
    }

    public ID getConjunction() {
        return this.getTyped(8, ID.class);
    }

    public ID getTq9_Conjunction() {
        return this.getTyped(8, ID.class);
    }

    public OSD getOrderSequencing() {
        return this.getTyped(9, OSD.class);
    }

    public OSD getTq10_OrderSequencing() {
        return this.getTyped(9, OSD.class);
    }

    public CWE getOccurrenceDuration() {
        return this.getTyped(10, CWE.class);
    }

    public CWE getTq11_OccurrenceDuration() {
        return this.getTyped(10, CWE.class);
    }

    public NM getTotalOccurrences() {
        return this.getTyped(11, NM.class);
    }

    public NM getTq12_TotalOccurrences() {
        return this.getTyped(11, NM.class);
    }
}

