/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.CE;
import ca.uhn.hl7v2.model.v25.datatype.FT;
import ca.uhn.hl7v2.model.v25.datatype.ST;
import ca.uhn.hl7v2.model.v25.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class EQP
extends AbstractSegment {
    public EQP(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CE.class, true, 1, 250, new Object[]{this.getMessage()}, "Event type");
            this.add(ST.class, false, 1, 20, new Object[]{this.getMessage()}, "File Name");
            this.add(TS.class, true, 1, 26, new Object[]{this.getMessage()}, "Start Date/Time");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "End Date/Time");
            this.add(FT.class, true, 1, 65536, new Object[]{this.getMessage()}, "Transaction Data");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating EQP - this is probably a bug in the source code generator.", e);
        }
    }

    public CE getEventType() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getEqp1_EventType() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getFileName() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getEqp2_FileName() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public TS getStartDateTime() {
        TS retVal = (TS)this.getTypedField(3, 0);
        return retVal;
    }

    public TS getEqp3_StartDateTime() {
        TS retVal = (TS)this.getTypedField(3, 0);
        return retVal;
    }

    public TS getEndDateTime() {
        TS retVal = (TS)this.getTypedField(4, 0);
        return retVal;
    }

    public TS getEqp4_EndDateTime() {
        TS retVal = (TS)this.getTypedField(4, 0);
        return retVal;
    }

    public FT getTransactionData() {
        FT retVal = (FT)this.getTypedField(5, 0);
        return retVal;
    }

    public FT getEqp5_TransactionData() {
        FT retVal = (FT)this.getTypedField(5, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CE(this.getMessage());
            }
            case 1: {
                return new ST(this.getMessage());
            }
            case 2: {
                return new TS(this.getMessage());
            }
            case 3: {
                return new TS(this.getMessage());
            }
            case 4: {
                return new FT(this.getMessage());
            }
        }
        return null;
    }
}

