/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v24.group.MFN_M11_MF_TEST_CALCULATED;
import ca.uhn.hl7v2.model.v24.segment.MFI;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class MFN_M11
extends AbstractMessage {
    public MFN_M11() {
        this(new DefaultModelClassFactory());
    }

    public MFN_M11(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MFI.class, true, false);
            this.add(MFN_M11_MF_TEST_CALCULATED.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MFN_M11 - this is probably a bug in the source code generator.", e);
        }
    }

    @Override
    public String getVersion() {
        return "2.4";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public MFI getMFI() {
        return this.getTyped("MFI", MFI.class);
    }

    public MFN_M11_MF_TEST_CALCULATED getMF_TEST_CALCULATED() {
        return this.getTyped("MF_TEST_CALCULATED", MFN_M11_MF_TEST_CALCULATED.class);
    }

    public MFN_M11_MF_TEST_CALCULATED getMF_TEST_CALCULATED(int rep) {
        return this.getTyped("MF_TEST_CALCULATED", rep, MFN_M11_MF_TEST_CALCULATED.class);
    }

    public int getMF_TEST_CALCULATEDReps() {
        return this.getReps("MF_TEST_CALCULATED");
    }

    public List<MFN_M11_MF_TEST_CALCULATED> getMF_TEST_CALCULATEDAll() throws HL7Exception {
        return this.getAllAsList("MF_TEST_CALCULATED", MFN_M11_MF_TEST_CALCULATED.class);
    }

    public void insertMF_TEST_CALCULATED(MFN_M11_MF_TEST_CALCULATED structure, int rep) throws HL7Exception {
        super.insertRepetition("MF_TEST_CALCULATED", structure, rep);
    }

    public MFN_M11_MF_TEST_CALCULATED insertMF_TEST_CALCULATED(int rep) throws HL7Exception {
        return (MFN_M11_MF_TEST_CALCULATED)super.insertRepetition("MF_TEST_CALCULATED", rep);
    }

    public MFN_M11_MF_TEST_CALCULATED removeMF_TEST_CALCULATED(int rep) throws HL7Exception {
        return (MFN_M11_MF_TEST_CALCULATED)super.removeRepetition("MF_TEST_CALCULATED", rep);
    }
}

