/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v231.datatype.CE;
import ca.uhn.hl7v2.model.v231.datatype.ID;
import ca.uhn.hl7v2.model.v231.datatype.ST;
import ca.uhn.hl7v2.model.v231.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class ACC
extends AbstractSegment {
    public ACC(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Accident Date/Time");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Accident Code");
            this.add(ST.class, false, 1, 25, new Object[]{this.getMessage()}, "Accident Location");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Auto Accident State");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Accident Job Related Indicator");
            this.add(ID.class, false, 1, 12, new Object[]{this.getMessage(), new Integer(136)}, "Accident Death Indicator");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ACC - this is probably a bug in the source code generator.", e);
        }
    }

    public TS getAccidentDateTime() {
        TS retVal = (TS)this.getTypedField(1, 0);
        return retVal;
    }

    public TS getAcc1_AccidentDateTime() {
        TS retVal = (TS)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getAccidentCode() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getAcc2_AccidentCode() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getAccidentLocation() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getAcc3_AccidentLocation() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getAutoAccidentState() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getAcc4_AutoAccidentState() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public ID getAccidentJobRelatedIndicator() {
        ID retVal = (ID)this.getTypedField(5, 0);
        return retVal;
    }

    public ID getAcc5_AccidentJobRelatedIndicator() {
        ID retVal = (ID)this.getTypedField(5, 0);
        return retVal;
    }

    public ID getAccidentDeathIndicator() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    public ID getAcc6_AccidentDeathIndicator() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new TS(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new ST(this.getMessage());
            }
            case 3: {
                return new CE(this.getMessage());
            }
            case 4: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 5: {
                return new ID(this.getMessage(), new Integer(136));
            }
        }
        return null;
    }
}

