/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.CE;
import ca.uhn.hl7v2.model.v23.datatype.DR;
import ca.uhn.hl7v2.model.v23.datatype.EI;
import ca.uhn.hl7v2.model.v23.datatype.NM;
import ca.uhn.hl7v2.model.v23.datatype.PL;
import ca.uhn.hl7v2.model.v23.datatype.RI;
import ca.uhn.hl7v2.model.v23.datatype.ST;
import ca.uhn.hl7v2.model.v23.datatype.XAD;
import ca.uhn.hl7v2.model.v23.datatype.XCN;
import ca.uhn.hl7v2.model.v23.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class ARQ
extends AbstractSegment {
    public ARQ(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(EI.class, true, 1, 22, new Object[]{this.getMessage()}, "Placer Appointment ID");
            this.add(EI.class, false, 1, 22, new Object[]{this.getMessage()}, "Filler Appointment ID");
            this.add(NM.class, false, 1, 5, new Object[]{this.getMessage()}, "Occurrence Number");
            this.add(EI.class, false, 1, 37, new Object[]{this.getMessage()}, "Placer Group Number");
            this.add(CE.class, false, 1, 200, new Object[]{this.getMessage()}, "Schedule ID");
            this.add(CE.class, false, 1, 200, new Object[]{this.getMessage()}, "Request Event Reason");
            this.add(CE.class, false, 1, 200, new Object[]{this.getMessage()}, "Appointment Reason");
            this.add(CE.class, false, 1, 200, new Object[]{this.getMessage()}, "Appointment Type");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Appointment Duration");
            this.add(CE.class, false, 1, 200, new Object[]{this.getMessage()}, "Appointment Duration Units");
            this.add(DR.class, false, 0, 53, new Object[]{this.getMessage()}, "Requested Start Date/Time Range");
            this.add(ST.class, false, 1, 5, new Object[]{this.getMessage()}, "Priority");
            this.add(RI.class, false, 1, 100, new Object[]{this.getMessage()}, "Repeating Interval");
            this.add(ST.class, false, 1, 5, new Object[]{this.getMessage()}, "Repeating Interval Duration");
            this.add(XCN.class, false, 1, 48, new Object[]{this.getMessage()}, "Placer Contact Person");
            this.add(XTN.class, false, 1, 40, new Object[]{this.getMessage()}, "Placer Contact Phone Number");
            this.add(XAD.class, false, 1, 106, new Object[]{this.getMessage()}, "Placer Contact Address");
            this.add(PL.class, false, 1, 80, new Object[]{this.getMessage()}, "Placer Contact Location");
            this.add(XCN.class, true, 1, 48, new Object[]{this.getMessage()}, "Entered By Person");
            this.add(XTN.class, false, 0, 40, new Object[]{this.getMessage()}, "Entered By Phone Number");
            this.add(PL.class, false, 1, 80, new Object[]{this.getMessage()}, "Entered By Location");
            this.add(EI.class, false, 1, 75, new Object[]{this.getMessage()}, "Parent Placer Appointment ID");
            this.add(EI.class, false, 1, 75, new Object[]{this.getMessage()}, "Parent Filler Appointment ID");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ARQ - this is probably a bug in the source code generator.", e);
        }
    }

    public EI getPlacerAppointmentID() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getArq1_PlacerAppointmentID() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getFillerAppointmentID() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public EI getArq2_FillerAppointmentID() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public NM getOccurrenceNumber() {
        NM retVal = (NM)this.getTypedField(3, 0);
        return retVal;
    }

    public NM getArq3_OccurrenceNumber() {
        NM retVal = (NM)this.getTypedField(3, 0);
        return retVal;
    }

    public EI getPlacerGroupNumber() {
        EI retVal = (EI)this.getTypedField(4, 0);
        return retVal;
    }

    public EI getArq4_PlacerGroupNumber() {
        EI retVal = (EI)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getScheduleID() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    public CE getArq5_ScheduleID() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    public CE getRequestEventReason() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public CE getArq6_RequestEventReason() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public CE getAppointmentReason() {
        CE retVal = (CE)this.getTypedField(7, 0);
        return retVal;
    }

    public CE getArq7_AppointmentReason() {
        CE retVal = (CE)this.getTypedField(7, 0);
        return retVal;
    }

    public CE getAppointmentType() {
        CE retVal = (CE)this.getTypedField(8, 0);
        return retVal;
    }

    public CE getArq8_AppointmentType() {
        CE retVal = (CE)this.getTypedField(8, 0);
        return retVal;
    }

    public NM getAppointmentDuration() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public NM getArq9_AppointmentDuration() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public CE getAppointmentDurationUnits() {
        CE retVal = (CE)this.getTypedField(10, 0);
        return retVal;
    }

    public CE getArq10_AppointmentDurationUnits() {
        CE retVal = (CE)this.getTypedField(10, 0);
        return retVal;
    }

    public DR[] getRequestedStartDateTimeRange() {
        DR[] retVal = (DR[])this.getTypedField(11, new DR[0]);
        return retVal;
    }

    public DR[] getArq11_RequestedStartDateTimeRange() {
        DR[] retVal = (DR[])this.getTypedField(11, new DR[0]);
        return retVal;
    }

    public int getRequestedStartDateTimeRangeReps() {
        return this.getReps(11);
    }

    public DR getRequestedStartDateTimeRange(int rep) {
        DR retVal = (DR)this.getTypedField(11, rep);
        return retVal;
    }

    public DR getArq11_RequestedStartDateTimeRange(int rep) {
        DR retVal = (DR)this.getTypedField(11, rep);
        return retVal;
    }

    public int getArq11_RequestedStartDateTimeRangeReps() {
        return this.getReps(11);
    }

    public DR insertRequestedStartDateTimeRange(int rep) throws HL7Exception {
        return (DR)super.insertRepetition(11, rep);
    }

    public DR insertArq11_RequestedStartDateTimeRange(int rep) throws HL7Exception {
        return (DR)super.insertRepetition(11, rep);
    }

    public DR removeRequestedStartDateTimeRange(int rep) throws HL7Exception {
        return (DR)super.removeRepetition(11, rep);
    }

    public DR removeArq11_RequestedStartDateTimeRange(int rep) throws HL7Exception {
        return (DR)super.removeRepetition(11, rep);
    }

    public ST getPriority() {
        ST retVal = (ST)this.getTypedField(12, 0);
        return retVal;
    }

    public ST getArq12_Priority() {
        ST retVal = (ST)this.getTypedField(12, 0);
        return retVal;
    }

    public RI getRepeatingInterval() {
        RI retVal = (RI)this.getTypedField(13, 0);
        return retVal;
    }

    public RI getArq13_RepeatingInterval() {
        RI retVal = (RI)this.getTypedField(13, 0);
        return retVal;
    }

    public ST getRepeatingIntervalDuration() {
        ST retVal = (ST)this.getTypedField(14, 0);
        return retVal;
    }

    public ST getArq14_RepeatingIntervalDuration() {
        ST retVal = (ST)this.getTypedField(14, 0);
        return retVal;
    }

    public XCN getPlacerContactPerson() {
        XCN retVal = (XCN)this.getTypedField(15, 0);
        return retVal;
    }

    public XCN getArq15_PlacerContactPerson() {
        XCN retVal = (XCN)this.getTypedField(15, 0);
        return retVal;
    }

    public XTN getPlacerContactPhoneNumber() {
        XTN retVal = (XTN)this.getTypedField(16, 0);
        return retVal;
    }

    public XTN getArq16_PlacerContactPhoneNumber() {
        XTN retVal = (XTN)this.getTypedField(16, 0);
        return retVal;
    }

    public XAD getPlacerContactAddress() {
        XAD retVal = (XAD)this.getTypedField(17, 0);
        return retVal;
    }

    public XAD getArq17_PlacerContactAddress() {
        XAD retVal = (XAD)this.getTypedField(17, 0);
        return retVal;
    }

    public PL getPlacerContactLocation() {
        PL retVal = (PL)this.getTypedField(18, 0);
        return retVal;
    }

    public PL getArq18_PlacerContactLocation() {
        PL retVal = (PL)this.getTypedField(18, 0);
        return retVal;
    }

    public XCN getEnteredByPerson() {
        XCN retVal = (XCN)this.getTypedField(19, 0);
        return retVal;
    }

    public XCN getArq19_EnteredByPerson() {
        XCN retVal = (XCN)this.getTypedField(19, 0);
        return retVal;
    }

    public XTN[] getEnteredByPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(20, new XTN[0]);
        return retVal;
    }

    public XTN[] getArq20_EnteredByPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(20, new XTN[0]);
        return retVal;
    }

    public int getEnteredByPhoneNumberReps() {
        return this.getReps(20);
    }

    public XTN getEnteredByPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(20, rep);
        return retVal;
    }

    public XTN getArq20_EnteredByPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(20, rep);
        return retVal;
    }

    public int getArq20_EnteredByPhoneNumberReps() {
        return this.getReps(20);
    }

    public XTN insertEnteredByPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(20, rep);
    }

    public XTN insertArq20_EnteredByPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(20, rep);
    }

    public XTN removeEnteredByPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(20, rep);
    }

    public XTN removeArq20_EnteredByPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(20, rep);
    }

    public PL getEnteredByLocation() {
        PL retVal = (PL)this.getTypedField(21, 0);
        return retVal;
    }

    public PL getArq21_EnteredByLocation() {
        PL retVal = (PL)this.getTypedField(21, 0);
        return retVal;
    }

    public EI getParentPlacerAppointmentID() {
        EI retVal = (EI)this.getTypedField(22, 0);
        return retVal;
    }

    public EI getArq22_ParentPlacerAppointmentID() {
        EI retVal = (EI)this.getTypedField(22, 0);
        return retVal;
    }

    public EI getParentFillerAppointmentID() {
        EI retVal = (EI)this.getTypedField(23, 0);
        return retVal;
    }

    public EI getArq23_ParentFillerAppointmentID() {
        EI retVal = (EI)this.getTypedField(23, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new EI(this.getMessage());
            }
            case 1: {
                return new EI(this.getMessage());
            }
            case 2: {
                return new NM(this.getMessage());
            }
            case 3: {
                return new EI(this.getMessage());
            }
            case 4: {
                return new CE(this.getMessage());
            }
            case 5: {
                return new CE(this.getMessage());
            }
            case 6: {
                return new CE(this.getMessage());
            }
            case 7: {
                return new CE(this.getMessage());
            }
            case 8: {
                return new NM(this.getMessage());
            }
            case 9: {
                return new CE(this.getMessage());
            }
            case 10: {
                return new DR(this.getMessage());
            }
            case 11: {
                return new ST(this.getMessage());
            }
            case 12: {
                return new RI(this.getMessage());
            }
            case 13: {
                return new ST(this.getMessage());
            }
            case 14: {
                return new XCN(this.getMessage());
            }
            case 15: {
                return new XTN(this.getMessage());
            }
            case 16: {
                return new XAD(this.getMessage());
            }
            case 17: {
                return new PL(this.getMessage());
            }
            case 18: {
                return new XCN(this.getMessage());
            }
            case 19: {
                return new XTN(this.getMessage());
            }
            case 20: {
                return new PL(this.getMessage());
            }
            case 21: {
                return new EI(this.getMessage());
            }
            case 22: {
                return new EI(this.getMessage());
            }
        }
        return null;
    }
}

