/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v22.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v22.datatype.CE;
import ca.uhn.hl7v2.model.v22.datatype.CM_EIP;
import ca.uhn.hl7v2.model.v22.datatype.CM_FILLER;
import ca.uhn.hl7v2.model.v22.datatype.CM_GROUP_ID;
import ca.uhn.hl7v2.model.v22.datatype.CM_PARENT_RESULT;
import ca.uhn.hl7v2.model.v22.datatype.CM_PLACER;
import ca.uhn.hl7v2.model.v22.datatype.CN;
import ca.uhn.hl7v2.model.v22.datatype.ID;
import ca.uhn.hl7v2.model.v22.datatype.TN;
import ca.uhn.hl7v2.model.v22.datatype.TQ;
import ca.uhn.hl7v2.model.v22.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class ORC
extends AbstractSegment {
    public ORC(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ID.class, true, 1, 2, new Object[]{this.getMessage(), new Integer(119)}, "Order Control");
            this.add(CM_PLACER.class, false, 1, 75, new Object[]{this.getMessage()}, "Placer Order Number");
            this.add(CM_FILLER.class, false, 1, 75, new Object[]{this.getMessage()}, "Filler Order Number");
            this.add(CM_GROUP_ID.class, false, 1, 75, new Object[]{this.getMessage()}, "Placer Group Number");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(38)}, "Order Status");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(121)}, "Response Flag");
            this.add(TQ.class, false, 0, 200, new Object[]{this.getMessage()}, "Quantity / timing");
            this.add(CM_EIP.class, false, 1, 200, new Object[]{this.getMessage()}, "Parent Order");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Date / time of transaction");
            this.add(CN.class, false, 1, 80, new Object[]{this.getMessage()}, "Entered By");
            this.add(CN.class, false, 1, 80, new Object[]{this.getMessage()}, "Verified By");
            this.add(CN.class, false, 1, 80, new Object[]{this.getMessage()}, "Ordering Provider");
            this.add(CM_PARENT_RESULT.class, false, 1, 80, new Object[]{this.getMessage()}, "Enterer's Location");
            this.add(TN.class, false, 2, 40, new Object[]{this.getMessage()}, "Call Back Phone Number");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Order effective date / time");
            this.add(CE.class, false, 1, 200, new Object[]{this.getMessage()}, "Order Control Code Reason");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Entering Organization");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Entering Device");
            this.add(CN.class, false, 1, 80, new Object[]{this.getMessage()}, "Action by");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ORC - this is probably a bug in the source code generator.", e);
        }
    }

    public ID getOrderControl() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getOrc1_OrderControl() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public CM_PLACER getPlacerOrderNumber() {
        CM_PLACER retVal = (CM_PLACER)this.getTypedField(2, 0);
        return retVal;
    }

    public CM_PLACER getOrc2_PlacerOrderNumber() {
        CM_PLACER retVal = (CM_PLACER)this.getTypedField(2, 0);
        return retVal;
    }

    public CM_FILLER getFillerOrderNumber() {
        CM_FILLER retVal = (CM_FILLER)this.getTypedField(3, 0);
        return retVal;
    }

    public CM_FILLER getOrc3_FillerOrderNumber() {
        CM_FILLER retVal = (CM_FILLER)this.getTypedField(3, 0);
        return retVal;
    }

    public CM_GROUP_ID getPlacerGroupNumber() {
        CM_GROUP_ID retVal = (CM_GROUP_ID)this.getTypedField(4, 0);
        return retVal;
    }

    public CM_GROUP_ID getOrc4_PlacerGroupNumber() {
        CM_GROUP_ID retVal = (CM_GROUP_ID)this.getTypedField(4, 0);
        return retVal;
    }

    public ID getOrderStatus() {
        ID retVal = (ID)this.getTypedField(5, 0);
        return retVal;
    }

    public ID getOrc5_OrderStatus() {
        ID retVal = (ID)this.getTypedField(5, 0);
        return retVal;
    }

    public ID getResponseFlag() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    public ID getOrc6_ResponseFlag() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    public TQ[] getQuantityTiming() {
        TQ[] retVal = (TQ[])this.getTypedField(7, new TQ[0]);
        return retVal;
    }

    public TQ[] getOrc7_QuantityTiming() {
        TQ[] retVal = (TQ[])this.getTypedField(7, new TQ[0]);
        return retVal;
    }

    public int getQuantityTimingReps() {
        return this.getReps(7);
    }

    public TQ getQuantityTiming(int rep) {
        TQ retVal = (TQ)this.getTypedField(7, rep);
        return retVal;
    }

    public TQ getOrc7_QuantityTiming(int rep) {
        TQ retVal = (TQ)this.getTypedField(7, rep);
        return retVal;
    }

    public int getOrc7_QuantityTimingReps() {
        return this.getReps(7);
    }

    public TQ insertQuantityTiming(int rep) throws HL7Exception {
        return (TQ)super.insertRepetition(7, rep);
    }

    public TQ insertOrc7_QuantityTiming(int rep) throws HL7Exception {
        return (TQ)super.insertRepetition(7, rep);
    }

    public TQ removeQuantityTiming(int rep) throws HL7Exception {
        return (TQ)super.removeRepetition(7, rep);
    }

    public TQ removeOrc7_QuantityTiming(int rep) throws HL7Exception {
        return (TQ)super.removeRepetition(7, rep);
    }

    public CM_EIP getParentOrder() {
        CM_EIP retVal = (CM_EIP)this.getTypedField(8, 0);
        return retVal;
    }

    public CM_EIP getOrc8_ParentOrder() {
        CM_EIP retVal = (CM_EIP)this.getTypedField(8, 0);
        return retVal;
    }

    public TS getDateTimeOfTransaction() {
        TS retVal = (TS)this.getTypedField(9, 0);
        return retVal;
    }

    public TS getOrc9_DateTimeOfTransaction() {
        TS retVal = (TS)this.getTypedField(9, 0);
        return retVal;
    }

    public CN getEnteredBy() {
        CN retVal = (CN)this.getTypedField(10, 0);
        return retVal;
    }

    public CN getOrc10_EnteredBy() {
        CN retVal = (CN)this.getTypedField(10, 0);
        return retVal;
    }

    public CN getVerifiedBy() {
        CN retVal = (CN)this.getTypedField(11, 0);
        return retVal;
    }

    public CN getOrc11_VerifiedBy() {
        CN retVal = (CN)this.getTypedField(11, 0);
        return retVal;
    }

    public CN getOrderingProvider() {
        CN retVal = (CN)this.getTypedField(12, 0);
        return retVal;
    }

    public CN getOrc12_OrderingProvider() {
        CN retVal = (CN)this.getTypedField(12, 0);
        return retVal;
    }

    public CM_PARENT_RESULT getEntererSLocation() {
        CM_PARENT_RESULT retVal = (CM_PARENT_RESULT)this.getTypedField(13, 0);
        return retVal;
    }

    public CM_PARENT_RESULT getOrc13_EntererSLocation() {
        CM_PARENT_RESULT retVal = (CM_PARENT_RESULT)this.getTypedField(13, 0);
        return retVal;
    }

    public TN[] getCallBackPhoneNumber() {
        TN[] retVal = (TN[])this.getTypedField(14, new TN[0]);
        return retVal;
    }

    public TN[] getOrc14_CallBackPhoneNumber() {
        TN[] retVal = (TN[])this.getTypedField(14, new TN[0]);
        return retVal;
    }

    public int getCallBackPhoneNumberReps() {
        return this.getReps(14);
    }

    public TN getCallBackPhoneNumber(int rep) {
        TN retVal = (TN)this.getTypedField(14, rep);
        return retVal;
    }

    public TN getOrc14_CallBackPhoneNumber(int rep) {
        TN retVal = (TN)this.getTypedField(14, rep);
        return retVal;
    }

    public int getOrc14_CallBackPhoneNumberReps() {
        return this.getReps(14);
    }

    public TN insertCallBackPhoneNumber(int rep) throws HL7Exception {
        return (TN)super.insertRepetition(14, rep);
    }

    public TN insertOrc14_CallBackPhoneNumber(int rep) throws HL7Exception {
        return (TN)super.insertRepetition(14, rep);
    }

    public TN removeCallBackPhoneNumber(int rep) throws HL7Exception {
        return (TN)super.removeRepetition(14, rep);
    }

    public TN removeOrc14_CallBackPhoneNumber(int rep) throws HL7Exception {
        return (TN)super.removeRepetition(14, rep);
    }

    public TS getOrderEffectiveDateTime() {
        TS retVal = (TS)this.getTypedField(15, 0);
        return retVal;
    }

    public TS getOrc15_OrderEffectiveDateTime() {
        TS retVal = (TS)this.getTypedField(15, 0);
        return retVal;
    }

    public CE getOrderControlCodeReason() {
        CE retVal = (CE)this.getTypedField(16, 0);
        return retVal;
    }

    public CE getOrc16_OrderControlCodeReason() {
        CE retVal = (CE)this.getTypedField(16, 0);
        return retVal;
    }

    public CE getEnteringOrganization() {
        CE retVal = (CE)this.getTypedField(17, 0);
        return retVal;
    }

    public CE getOrc17_EnteringOrganization() {
        CE retVal = (CE)this.getTypedField(17, 0);
        return retVal;
    }

    public CE getEnteringDevice() {
        CE retVal = (CE)this.getTypedField(18, 0);
        return retVal;
    }

    public CE getOrc18_EnteringDevice() {
        CE retVal = (CE)this.getTypedField(18, 0);
        return retVal;
    }

    public CN getActionBy() {
        CN retVal = (CN)this.getTypedField(19, 0);
        return retVal;
    }

    public CN getOrc19_ActionBy() {
        CN retVal = (CN)this.getTypedField(19, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ID(this.getMessage(), new Integer(119));
            }
            case 1: {
                return new CM_PLACER(this.getMessage());
            }
            case 2: {
                return new CM_FILLER(this.getMessage());
            }
            case 3: {
                return new CM_GROUP_ID(this.getMessage());
            }
            case 4: {
                return new ID(this.getMessage(), new Integer(38));
            }
            case 5: {
                return new ID(this.getMessage(), new Integer(121));
            }
            case 6: {
                return new TQ(this.getMessage());
            }
            case 7: {
                return new CM_EIP(this.getMessage());
            }
            case 8: {
                return new TS(this.getMessage());
            }
            case 9: {
                return new CN(this.getMessage());
            }
            case 10: {
                return new CN(this.getMessage());
            }
            case 11: {
                return new CN(this.getMessage());
            }
            case 12: {
                return new CM_PARENT_RESULT(this.getMessage());
            }
            case 13: {
                return new TN(this.getMessage());
            }
            case 14: {
                return new TS(this.getMessage());
            }
            case 15: {
                return new CE(this.getMessage());
            }
            case 16: {
                return new CE(this.getMessage());
            }
            case 17: {
                return new CE(this.getMessage());
            }
            case 18: {
                return new CN(this.getMessage());
            }
        }
        return null;
    }
}

