/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v22.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v22.group.ORU_R03_OBSERVATION;
import ca.uhn.hl7v2.model.v22.segment.NTE;
import ca.uhn.hl7v2.model.v22.segment.OBR;
import ca.uhn.hl7v2.model.v22.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class ORU_R03_ORDER_OBSERVATION
extends AbstractGroup {
    public ORU_R03_ORDER_OBSERVATION(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, false, false, false);
            this.add(OBR.class, true, false, false);
            this.add(NTE.class, false, true, false);
            this.add(ORU_R03_OBSERVATION.class, true, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ORU_R03_ORDER_OBSERVATION - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.2";
    }

    public ORC getORC() {
        ORC retVal = this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public OBR getOBR() {
        OBR retVal = this.getTyped("OBR", OBR.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public ORU_R03_OBSERVATION getOBSERVATION() {
        ORU_R03_OBSERVATION retVal = this.getTyped("OBSERVATION", ORU_R03_OBSERVATION.class);
        return retVal;
    }

    public ORU_R03_OBSERVATION getOBSERVATION(int rep) {
        ORU_R03_OBSERVATION retVal = this.getTyped("OBSERVATION", rep, ORU_R03_OBSERVATION.class);
        return retVal;
    }

    public int getOBSERVATIONReps() {
        return this.getReps("OBSERVATION");
    }

    public List<ORU_R03_OBSERVATION> getOBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("OBSERVATION", ORU_R03_OBSERVATION.class);
    }

    public void insertOBSERVATION(ORU_R03_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", structure, rep);
    }

    public ORU_R03_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (ORU_R03_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public ORU_R03_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (ORU_R03_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }
}

