/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v21.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v21.datatype.AD;
import ca.uhn.hl7v2.model.v21.datatype.PN;
import ca.uhn.hl7v2.model.v21.datatype.SI;
import ca.uhn.hl7v2.model.v21.datatype.ST;
import ca.uhn.hl7v2.model.v21.datatype.TN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class NK1
extends AbstractSegment {
    public NK1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage()}, "SET ID - NEXT OF KIN");
            this.add(PN.class, false, 1, 48, new Object[]{this.getMessage()}, "NEXT OF KIN NAME");
            this.add(ST.class, false, 1, 15, new Object[]{this.getMessage()}, "NEXT OF KIN RELATIONSHIP");
            this.add(AD.class, false, 1, 106, new Object[]{this.getMessage()}, "NEXT OF KIN - ADDRESS");
            this.add(TN.class, false, 0, 40, new Object[]{this.getMessage()}, "NEXT OF KIN - PHONE NUMBER");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating NK1 - this is probably a bug in the source code generator.", e);
        }
    }

    public SI getSETIDNEXTOFKIN() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getNk11_SETIDNEXTOFKIN() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public PN getNEXTOFKINNAME() {
        PN retVal = (PN)this.getTypedField(2, 0);
        return retVal;
    }

    public PN getNk12_NEXTOFKINNAME() {
        PN retVal = (PN)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getNEXTOFKINRELATIONSHIP() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getNk13_NEXTOFKINRELATIONSHIP() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public AD getNEXTOFKINADDRESS() {
        AD retVal = (AD)this.getTypedField(4, 0);
        return retVal;
    }

    public AD getNk14_NEXTOFKINADDRESS() {
        AD retVal = (AD)this.getTypedField(4, 0);
        return retVal;
    }

    public TN[] getNEXTOFKINPHONENUMBER() {
        TN[] retVal = (TN[])this.getTypedField(5, new TN[0]);
        return retVal;
    }

    public TN[] getNk15_NEXTOFKINPHONENUMBER() {
        TN[] retVal = (TN[])this.getTypedField(5, new TN[0]);
        return retVal;
    }

    public int getNEXTOFKINPHONENUMBERReps() {
        return this.getReps(5);
    }

    public TN getNEXTOFKINPHONENUMBER(int rep) {
        TN retVal = (TN)this.getTypedField(5, rep);
        return retVal;
    }

    public TN getNk15_NEXTOFKINPHONENUMBER(int rep) {
        TN retVal = (TN)this.getTypedField(5, rep);
        return retVal;
    }

    public int getNk15_NEXTOFKINPHONENUMBERReps() {
        return this.getReps(5);
    }

    public TN insertNEXTOFKINPHONENUMBER(int rep) throws HL7Exception {
        return (TN)super.insertRepetition(5, rep);
    }

    public TN insertNk15_NEXTOFKINPHONENUMBER(int rep) throws HL7Exception {
        return (TN)super.insertRepetition(5, rep);
    }

    public TN removeNEXTOFKINPHONENUMBER(int rep) throws HL7Exception {
        return (TN)super.removeRepetition(5, rep);
    }

    public TN removeNk15_NEXTOFKINPHONENUMBER(int rep) throws HL7Exception {
        return (TN)super.removeRepetition(5, rep);
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new PN(this.getMessage());
            }
            case 2: {
                return new ST(this.getMessage());
            }
            case 3: {
                return new AD(this.getMessage());
            }
            case 4: {
                return new TN(this.getMessage());
            }
        }
        return null;
    }
}

