/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.readhl7;

import ca.infodata.readhl7.tools.Messages;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.apache.commons.lang.time.FastDateFormat;

public class UtilDateUtilities {
    private static String defaultPattern = "yyyy-MM-dd";
    private static Locale defaultLocale = Locale.CANADA;

    public static Date StringToDate(String s) {
        return UtilDateUtilities.StringToDate(s, defaultPattern, defaultLocale);
    }

    public static Date StringToDate(String s, Locale locale) {
        return UtilDateUtilities.StringToDate(s, defaultPattern, locale);
    }

    public static Date StringToDate(String s, String spattern) {
        return UtilDateUtilities.StringToDate(s, spattern, defaultLocale);
    }

    public static Date StringToDate(String s, String spattern, Locale locale) {
        try {
            SimpleDateFormat simpledateformat = new SimpleDateFormat(spattern, locale);
            return simpledateformat.parse(s);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String DateToString(Date date) {
        return UtilDateUtilities.DateToString(date, defaultPattern, defaultLocale);
    }

    public static String DateToString(Date date, Locale locale) {
        return UtilDateUtilities.DateToString(date, defaultPattern, locale);
    }

    public static String DateToString(Date date, String spattern) {
        return UtilDateUtilities.DateToString(date, spattern, defaultLocale);
    }

    public static String DateToString(Date date, String spattern, Locale locale) {
        if (date != null) {
            FastDateFormat simpledateformat = FastDateFormat.getInstance(spattern, locale);
            return simpledateformat.format(date);
        }
        return "";
    }

    public static String justYear(Date date) {
        FastDateFormat simpledateformat = FastDateFormat.getInstance("yyyy");
        return simpledateformat.format(date);
    }

    public static String justMonth(Date date) {
        FastDateFormat simpledateformat = FastDateFormat.getInstance("MM");
        return simpledateformat.format(date);
    }

    public static String justDay(Date date) {
        FastDateFormat simpledateformat = FastDateFormat.getInstance("dd");
        return simpledateformat.format(date);
    }

    public static Date now() {
        return Calendar.getInstance().getTime();
    }

    public static Date Today() {
        return Calendar.getInstance().getTime();
    }

    public static Date Tomorrow() {
        Calendar c = Calendar.getInstance();
        c.roll(5, 1);
        return c.getTime();
    }

    public static Date calcDate(String s, String s1, String s2) {
        if (s == null || s1 == null || s2 == null || s == "" || s1 == "" || s2 == "") {
            return null;
        }
        int i = Integer.parseInt(s);
        int j = Integer.parseInt(s1) - 1;
        int k = Integer.parseInt(s2);
        GregorianCalendar gregoriancalendar = new GregorianCalendar(i, j, k);
        return gregoriancalendar.getTime();
    }

    public static String calcAge(Date DOB) {
        return UtilDateUtilities.calcAgeAtDate(DOB, new GregorianCalendar().getTime());
    }

    public static String calcAgeAtDate(Date DOB, Date pointInTime) {
        if (DOB == null) {
            return null;
        }
        GregorianCalendar now = new GregorianCalendar();
        if (pointInTime != null) {
            now.setTime(pointInTime);
        }
        int curYear = now.get(1);
        int curMonth = now.get(2) + 1;
        int curDay = now.get(5);
        GregorianCalendar birthDate = new GregorianCalendar();
        birthDate.setTime(DOB);
        int birthYear = birthDate.get(1);
        int birthMonth = birthDate.get(2) + 1;
        int birthDay = birthDate.get(5);
        int ageInYears = curYear - birthYear;
        String result = ageInYears + " " + Messages.getString("global.years");
        if (curMonth > birthMonth || curMonth == birthMonth && curDay >= birthDay) {
            ageInYears = curYear - birthYear;
            result = ageInYears + " " + Messages.getString("global.years");
        } else {
            ageInYears = curYear - birthYear - 1;
            result = ageInYears + " " + Messages.getString("global.years");
        }
        if (ageInYears < 2) {
            int yearDiff = curYear - birthYear;
            int ageInDays = yearDiff == 2 ? birthDate.getActualMaximum(6) - birthDate.get(6) + now.get(6) + 365 : (yearDiff == 1 ? birthDate.getActualMaximum(6) - birthDate.get(6) + now.get(6) : now.get(6) - birthDate.get(6));
            result = ageInDays / 7 > 9 ? ageInDays / 30 + " " + Messages.getString("global.months") : (ageInDays >= 14 ? ageInDays / 7 + " " + Messages.getString("global.weeks") : ageInDays + " " + Messages.getString("global.days"));
        }
        return result;
    }

    public static int calcAge(String year_of_birth, String month_of_birth, String date_of_birth) {
        GregorianCalendar now = new GregorianCalendar();
        int curYear = now.get(1);
        int curMonth = now.get(2) + 1;
        int curDay = now.get(5);
        int age = 0;
        age = curMonth > Integer.parseInt(month_of_birth) ? curYear - Integer.parseInt(year_of_birth) : (curMonth == Integer.parseInt(month_of_birth) && curDay > Integer.parseInt(date_of_birth) ? curYear - Integer.parseInt(year_of_birth) : curYear - Integer.parseInt(year_of_birth) - 1);
        return age;
    }

    public static String getToday(String datePattern) {
        SimpleDateFormat formatter = new SimpleDateFormat(datePattern);
        return formatter.format((Object)UtilDateUtilities.Today());
    }

    public static Date getDateFromString(String dateStr, String datePattern) {
        Date date = null;
        try {
            SimpleDateFormat formatter = new SimpleDateFormat(datePattern);
            date = formatter.parse(dateStr);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return date;
    }

    public static int getNumMonths(Date dStart, Date dEnd) {
        if (dStart == null || dEnd == null) {
            return 0;
        }
        int i = 0;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dStart);
        while (calendar.getTime().before(dEnd) || calendar.getTime().equals(dEnd)) {
            calendar.add(2, 1);
            ++i;
        }
        if (--i < 0) {
            i = 0;
        }
        return i;
    }

    public static long getNumDays(Date dStart, Date dEnd) {
        if (dStart == null || dEnd == null) {
            return 0L;
        }
        long msDifference = dEnd.getTime() - dStart.getTime();
        long daysDifference = msDifference / 86400000L;
        return daysDifference;
    }

    public static int getNumYears(Date dStart, Date dEnd) {
        if (dStart == null || dEnd == null) {
            return 0;
        }
        GregorianCalendar now = new GregorianCalendar();
        now.setTime(dEnd);
        int curYear = now.get(1);
        int curMonth = now.get(2) + 1;
        int curDay = now.get(5);
        GregorianCalendar birthDate = new GregorianCalendar();
        birthDate.setTime(dStart);
        int birthYear = birthDate.get(1);
        int birthMonth = birthDate.get(2) + 1;
        int birthDay = birthDate.get(5);
        int ageInYears = curYear - birthYear;
        ageInYears = curMonth > birthMonth || curMonth == birthMonth && curDay >= birthDay ? curYear - birthYear : curYear - birthYear - 1;
        return ageInYears;
    }

    public static int getNumMonths(Calendar dStart, Calendar dEnd) {
        return UtilDateUtilities.getNumMonths(dStart.getTime(), dEnd.getTime());
    }

    public static int calculateGestationAge(Date today, Date edd) {
        int i = 40;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(edd);
        if (today.before(edd)) {
            while (today.before(calendar.getTime()) || today.equals(calendar.getTime())) {
                calendar.add(6, -7);
                if (--i >= 0) continue;
            }
            ++i;
        } else if (today.after(edd)) {
            while (today.after(calendar.getTime())) {
                ++i;
                calendar.add(6, 7);
            }
        }
        if (i < 0) {
            i = 0;
        }
        return i;
    }
}

