/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.readhl7;

import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Locale;

public class ReportStatus {
    private final String providerName;
    private final String providerNo;
    private final String status;
    private final String comment;
    private final String timestamp;
    private final String segmentID;

    public ReportStatus(String pName, String pNo, String s, String c, String t, String sID) {
        this.providerName = pName;
        this.providerNo = pNo;
        this.status = s;
        this.comment = c;
        this.segmentID = sID;
        GregorianCalendar cal = new GregorianCalendar(Locale.ENGLISH);
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MMM-yy HH:mm", Locale.ENGLISH);
        if (t.length() > 18) {
            cal.set(Integer.parseInt(t.substring(0, 4)), Integer.parseInt(t.substring(5, 7)) - 1, Integer.parseInt(t.substring(8, 10)), Integer.parseInt(t.substring(11, 13)), Integer.parseInt(t.substring(14, 16)), Integer.parseInt(t.substring(17, 19)));
        } else {
            cal.set(Integer.parseInt(t.substring(0, 4)), Integer.parseInt(t.substring(4, 6)) - 1, Integer.parseInt(t.substring(6, 8)), Integer.parseInt(t.substring(8, 10)), Integer.parseInt(t.substring(10, 12)), Integer.parseInt(t.substring(12, 14)));
        }
        this.timestamp = dateFormat.format(cal.getTime());
    }

    public ReportStatus(String pName, String pNo, String s, String c, long t, String sID) {
        this.providerName = pName;
        this.providerNo = pNo;
        this.status = s;
        this.comment = c;
        this.segmentID = sID;
        GregorianCalendar cal = new GregorianCalendar(Locale.ENGLISH);
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MMM-yy HH:mm", Locale.ENGLISH);
        cal.setTimeInMillis(t);
        this.timestamp = dateFormat.format(cal.getTime());
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getProviderNo() {
        return this.providerNo;
    }

    public String getStatus() {
        return this.status;
    }

    public String getComment() {
        return this.comment;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getID() {
        return this.segmentID;
    }
}

