/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.scan.scan;

import ca.infodata.util1.StringUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PdfNamParser {
    private static Pattern patNAM = Pattern.compile("([ ]([\\]\\[\\(vwul18\u00c0A-Z][\\]\\[\\(vwul18\u00c0A-Z][\\]\\[\\(vwul18\u00c0A-Z][1\\]\\[\\(vwul18\u00c0A-Z|*][|IlrsSO0-9\\]\\[][|IlrsSO0-9\\]\\[][|IlrsSO0156][|IlrsSO0-9\\]\\[][|IlrsSO0-3][|IlrsSO0-9\\]\\[]([\\]\\[\\(vwul18\u00c0A-Z]|[|IlrsSO0-9\\]\\[])[|IlrsSO0-9\\]\\[][ ])|([ ][\\]\\[\\(vwul18\u00c0A-Z][\\]\\[\\(vwul18\u00c0A-Z][\\]\\[\\(vwul18\u00c0A-Z][1\\]\\[\\(vwul18\u00c0A-Z|*][|IlrsSO0-9\\]\\[][|IlrsSO0-9\\]\\[][|IlrsSO0156][|IlrsSO0-9\\]\\[][|IlrsSO0-3][|IlrsSO0-9\\]\\[]([\\]\\[\\(vwul18\u00c0A-Z]|[|IlrsSO0-9\\]\\[]))|([ ][\\]\\[\\(vwul18\u00c0A-Z][\\]\\[\\(vwul18\u00c0A-Z][\\]\\[\\(vwul18\u00c0A-Z][1\\]\\[\\(vwul18\u00c0A-Z|*][|IlrsSO0-9\\]\\[][|IlrsSO0-9\\]\\[][|IlrsSO0156][|IlrsSO0-9\\]\\[][|IlrsSO0-3][|IlrsSO0-9\\]\\[])|([ ][\\]\\[\\(vwul18\u00c0A-Z][\\]\\[\\(vwul18\u00c0A-Z][\\]\\[\\(vwul18\u00c0A-Z][1\\]\\[\\(vwul18\u00c0A-Z|*][|IlrsSO0-9\\]\\[][|IlrsSO0-9\\]\\[][|IlrsSO0156][|IlrsSO0-9\\]\\[][|IlrsSO0-3])|([ ][\\]\\[\\(vwul18\u00c0A-Z][\\]\\[\\(vwul18\u00c0A-Z][\\]\\[\\(vwul18\u00c0A-Z][1\\]\\[\\(vwul18\u00c0A-Z|*][|IlrsSO0-9\\]\\[][|IlrsSO0-9\\]\\[][|IlrsSO0156][|IlrsSO0-9\\]\\[][ ])|([ ][\\]\\[\\(vwul18\u00c0A-Z][\\]\\[\\(vwul18\u00c0A-Z][\\]\\[\\(vwul18\u00c0A-Z][1\\]\\[\\(vwul18\u00c0A-Z|*][ ][|IlrsSO0-9\\]\\[][|IlrsSO0-9\\]\\[][|IlrsSO0156][|IlrsSO0-9\\]\\[][ ][|IlrsSO0-3][|IlrsSO0-9\\]\\[]([\\]\\[\\(vwul18\u00c0A-Z]|[|IlrsSO0-9\\]\\[])[|IlrsSO0-9\\]\\[][ ])|([ ][\\]\\[\\(vwul18\u00c0A-Z][\\]\\[\\(vwul18\u00c0A-Z][\\]\\[\\(vwul18\u00c0A-Z][1\\]\\[\\(vwul18\u00c0A-Z|*][ ][|IlrsSO0-9\\]\\[][|IlrsSO0-9\\]\\[][|IlrsSO0156][|IlrsSO0-9\\]\\[][ ][|IlrsSO0-3][|IlrsSO0-9\\]\\[]([\\]\\[\\(vwul18\u00c0A-Z]|[|IlrsSO0-9\\]\\[]))|([ ][\\]\\[\\(vwul18\u00c0A-Z][\\]\\[\\(vwul18\u00c0A-Z][\\]\\[\\(vwul18\u00c0A-Z][1\\]\\[\\(vwul18\u00c0A-Z|*][ ][|IlrsSO0-9\\]\\[][|IlrsSO0-9\\]\\[][|IlrsSO0156][|IlrsSO0-9\\]\\[][ ][|IlrsSO0-3][|IlrsSO0-9\\]\\[])|([ ][\\]\\[\\(vwul18\u00c0A-Z][\\]\\[\\(vwul18\u00c0A-Z][\\]\\[\\(vwul18\u00c0A-Z][1\\]\\[\\(vwul18\u00c0A-Z|*][ ][|IlrsSO0-9\\]\\[][|IlrsSO0-9\\]\\[][|IlrsSO0156][|IlrsSO0-9\\]\\[][ ][|IlrsSO0-3]))|([ ][|IlrsSO0-9\\]\\[]{9}[ ])");
    private String namQc;
    private String namNb;
    private String text;

    public PdfNamParser(String text) {
        this.text = text;
    }

    public void parse() {
        if (StringUtils.isNotBlank((String)this.text)) {
            this.text = this.text.replaceAll("[,/.':]", "").replaceAll("[\n]", " ").replaceAll("[ ]{2,}", " ");
            Matcher m = patNAM.matcher(this.text);
            while (m.find()) {
                this.namQc = m.group(1);
                this.namNb = m.group(9);
                if (this.namQc != null) {
                    this.namQc = this.namQc.replaceAll(" ", "");
                    String letters = this.namQc.substring(0, 4);
                    letters = letters.replaceAll("[1l\\[\\[]", "I").replace('(', 'U').replace('v', 'V').replace('w', 'W').replace('u', 'U').replace('8', 'B').replace('\u00c0', 'A');
                    String numbers = this.namQc.substring(4, this.namQc.length());
                    numbers = numbers.replace('O', '0').replace('r', '1').replace('s', '5').replace('S', '5').replace('I', '1').replaceAll("[|l\\[\\[]", "1");
                    this.namQc = String.valueOf(letters) + numbers;
                    break;
                }
                if (this.namNb == null) continue;
                this.namNb = this.namNb.trim().replace('O', '0').replace('s', '5').replace('S', '5').replaceAll("[|l\\[\\[]", "1");
            }
        }
    }

    public String getNamQc() {
        return this.namQc;
    }

    public String getNamNb() {
        return this.namNb;
    }
}

