/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.scan.dsq.imaging;

import ca.infodata.dsq.domain.Code;
import ca.infodata.dsq.domain.fco.CandidateConsentDirective;
import ca.infodata.dsq.domain.imaging.ImagingResultExam;
import ca.infodata.dsq.domain.imaging.ImagingResultExamReport;
import ca.infodata.dsq.service.dm.DMQRYCSvc.QueryContinuationResult;
import ca.infodata.ofys.client.modules.dsq.DsqCallback;
import ca.infodata.ofys.data.middle.dataobjects.LightweightReport;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.ReportProperties;
import ca.infodata.ofys.data.middle.dataobjects.XFinishedReport;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IReport;
import ca.infodata.ofys.data.middle.dataobjects.patient.IPatientRelated;
import ca.infodata.ofys.data.middle.dataobjects.pdf.ParagraphBuilder;
import ca.infodata.ofys.data.middle.dataobjects.pdf.TablePdf;
import ca.infodata.ofys.data.middle.dataobjects.properties.report.PrintMode;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.DateText;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.FontAwareLabel;
import ca.infodata.ofys.ui.controls.calendarcombo.MyCalendarText;
import ca.infodata.ofys.ui.controls.form.IReferenceControl;
import ca.infodata.ofys.ui.controls.form.ISearchTextListener;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.plugins.searchview.BaseSearchComposite;
import ca.infodata.ofys.ui.controls.plugins.searchview.ErrorWhileSearchingException;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchColumn;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchColumnChoiceElement;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchItem;
import ca.infodata.ofys.ui.controls.report2.ReportCallback;
import ca.infodata.ofys.ui.dsq.BaseDSQAction;
import ca.infodata.ofys.ui.dsq.FindCandidateAction;
import ca.infodata.ofys.ui.dsq.controller.ConsentControllerCallback;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.patient.PatientSearchText;
import ca.infodata.ofys.ui.person.patient.PatientUtil;
import ca.infodata.ofys.ui.scan.dsq.imaging.ImagingExamEditor;
import ca.infodata.ofys.ui.scan.dsq.imaging.ImagingResultExamElement;
import ca.infodata.ofys.ui.scan.dsq.imaging.ListImagingExamController;
import ca.infodata.ofys.ui.scan.dsq.imaging.ListImagingExamControllerCallback;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.ProviderAR;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.DateUtil;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ListImagingExamComposite
extends BaseSearchComposite
implements ListImagingExamControllerCallback,
ConsentControllerCallback {
    private static final String CES_DONNEES_SONT_EXTRAITES_DU_DOSSIER_SANTE_QUEBEC_DSQ = "Ces donn\u00e9es sont extraites du DOSSIER SANT\u00c9 QU\u00c9BEC (DSQ)";
    private static final Logger logger = Logger.getLogger(ListImagingExamComposite.class.getName());
    private MyLabel lblDebut;
    private MyLabel lblFin;
    private MyCalendarText txtDateFrom;
    private MyCalendarText txtDateTo;
    private MyLabel lblPatient;
    private PatientSearchText txtPatient;
    private ListImagingExamController listController;
    private static final String consentMessageKey = "consent";
    public static String PRINTTITLE = "Liste des r\u00e9sultats d'imagerie m\u00e9dicale";

    public ListImagingExamComposite(Composite parent, FormToolkit toolkit, int style) {
        super(parent, toolkit, style);
        BaseDSQAction dsq = new BaseDSQAction();
        this.listController = new ListImagingExamController(this, dsq, new FindCandidateAction());
        this.txtDateFrom.setDate((IPartialDate)this.listController.getStart());
        this.txtDateTo.setDate((IPartialDate)this.listController.getEnd());
    }

    public void setFocus() {
        this.setVisible(true);
    }

    public void createMyPartControl(Composite theParent, FormToolkit toolkit, int style) {
        this.isWithTemplateTool = false;
        super.createMyPartControl(theParent, toolkit, style);
        this.configureBtnCustom("Imprimer", new IReferenceControl(){

            public void callback(Object o) {
                List<Paragraph> com = ListImagingExamComposite.getPrintComments(ListImagingExamComposite.this.txtPatient.getMyLabel().getText());
                TablePdf print = ListImagingExamComposite.this.getPrintTable(PRINTTITLE, com);
                ListImagingExamComposite.printWithExternal(print, this.hashCode());
            }
        }, false);
    }

    public static List<Paragraph> getPrintComments(String patient) {
        Font font = new Font(2, 10.0f, 0, Color.black);
        ArrayList<Paragraph> comments = new ArrayList<Paragraph>();
        comments.add(new ParagraphBuilder("Patient : " + patient, font, 0).build());
        comments.add(new ParagraphBuilder("   ", font, 0).build());
        comments.add(new ParagraphBuilder("Ces donn\u00e9es sont extraites du DOSSIER SANT\u00c9 QU\u00c9BEC (DSQ)\n\n", new Font(2, 10.0f, 2, Color.black), 1).build());
        return comments;
    }

    public static void printWithExternal(TablePdf printable, int hashCode) {
        byte[] pdf = ListImagingExamComposite.printToPdf((TablePdf)printable);
        if (pdf != null) {
            ReportCallback.showWithExternalViewer((IReport)new LightweightReport(String.valueOf(hashCode), "table" + hashCode, PrintMode.ACTUAL_SIZE), (XFinishedReport)new XFinishedReport(pdf, new ReportProperties()));
        }
    }

    protected void createMyControl(Composite parent, FormToolkit toolkit) {
        this.setViewSelectInactive();
        this.setIsWithButtonNew(false);
        this.lblDebut = new MyLabel(parent, Messages.getString((String)"DEBUT", (String[])new String[0]), 16384, toolkit);
        this.lblFin = new MyLabel(parent, Messages.getString((String)"FIN", (String[])new String[0]), 16384, toolkit);
        this.txtDateFrom = new MyCalendarText(parent, 0, toolkit, true);
        this.txtDateFrom.addDateListener((DateText.IDateListener)new DateText.DateAdapter(){

            public void dateChanged(LocalDate date) {
                ListImagingExamComposite.this.listController.setStart(date);
            }
        });
        this.txtDateTo = new MyCalendarText(parent, 0, toolkit, true);
        this.txtDateTo.addDateListener((DateText.IDateListener)new DateText.DateAdapter(){

            public void dateChanged(LocalDate date) {
                ListImagingExamComposite.this.listController.setEnd(date);
            }
        });
        this.lblPatient = new MyLabel(parent, Messages.getString((String)"PATIENT", (String[])new String[0]), 16384, toolkit);
        this.txtPatient = new PatientSearchText(parent, 4096, toolkit);
        this.txtPatient.addSearchTextListener(new ISearchTextListener(){

            public void objectReceived(IDataObject dataObject) {
                XPatient patient = PatientUtil.getXPatient((Object)dataObject);
                ListImagingExamComposite.this.listController.setPatient((IPatient)patient);
                ListImagingExamComposite.this.clearMessage();
                ListImagingExamComposite.this.loadSearchListInTable(new SearchItem[0]);
                PersonUiPlugin.getDefault().setCurrentPatient((IPatient)patient);
            }
        });
        this.txtPatient.setLabelProvider((ProviderAR)new ProviderAR<IDataObject, String>(){

            public String get(IDataObject object) {
                if (object instanceof IPatient) {
                    IPatient object2 = (IPatient)object;
                    return String.valueOf(object2.getNameBirthdateSex()) + ", " + object2.getHealthInsuranceNumber();
                }
                if (object instanceof IPatientRelated) {
                    return this.get((IDataObject)((IPatientRelated)object).getPatient());
                }
                return "";
            }
        });
        FontAwareLabel lblDSQDisclaimer = new FontAwareLabel(parent, CES_DONNEES_SONT_EXTRAITES_DU_DOSSIER_SANTE_QUEBEC_DSQ, 0x1000040, toolkit);
        lblDSQDisclaimer.setFont(-1, 2);
        int iTop = 1;
        FormLayout layout = new FormLayout();
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        layout.spacing = 5;
        parent.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        this.lblDebut.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(this.txtDateTo.getControl(), 0, 16384);
        this.lblFin.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblDebut.getControl(), iTop);
        data.left = new FormAttachment(0);
        this.txtDateFrom.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblDebut.getControl(), iTop);
        data.left = new FormAttachment(this.txtDateFrom.getControl());
        this.txtDateTo.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtDateTo.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(50);
        this.lblPatient.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblPatient.getControl(), UI.getAjustedPosition());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.txtPatient.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.txtPatient);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        lblDSQDisclaimer.setLayoutData((Object)data);
    }

    protected void search() throws ErrorWhileSearchingException {
        try {
            this.clearMessage();
            this.listController.list();
        }
        catch (Exception e) {
            throw new ErrorWhileSearchingException(e);
        }
    }

    @Override
    public void list(DsqCallback<QueryContinuationResult> dsqCallback) {
        if (!this.processExceptionOrMessage("default", dsqCallback)) {
            this.searchResponse((QueryContinuationResult)dsqCallback.result);
        }
    }

    private boolean processExceptionOrMessage(String key, final DsqCallback<?> dsqCallback) {
        if (dsqCallback.exception != null || StringUtils.isNotBlank((String)dsqCallback.message)) {
            this.getControl().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    String message = dsqCallback.message;
                    if (dsqCallback.exception != null) {
                        message = StringUtils.isNotBlank((String)dsqCallback.exception.getMessage()) ? dsqCallback.exception.getMessage() : dsqCallback.exception.getClass().getSimpleName();
                    }
                    ListImagingExamComposite.this.addMessage(message);
                }
            });
            return true;
        }
        return false;
    }

    public String getConsent(DsqCallback<CandidateConsentDirective> dsqCallback) {
        if (!this.processExceptionOrMessage(consentMessageKey, dsqCallback)) {
            final CandidateConsentDirective consent = (CandidateConsentDirective)dsqCallback.result;
            if (consent != null && consent.hasPastConsentRefusal()) {
                this.getControl().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ListImagingExamComposite.this.addMessage(ListImagingExamComposite.consentMessageKey, "Date de fin du refus : " + DateUtil.nonThreadSafeFormat((Long)(consent.getEffectiveStartTime() - TimeUnit.SECONDS.toMillis(1L)), (String)"yyyy-MM-dd HH:mm:ss"));
                    }
                });
            }
            if (consent == null || !consent.hasAccepted()) {
                this.getControl().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ListImagingExamComposite.this.addMessage(ListImagingExamComposite.consentMessageKey, "L'usager refuse de participer au DSQ");
                    }
                });
            }
        }
        return null;
    }

    public static List<ImagingResultExam> orderSearchResults(QueryContinuationResult result) {
        List<ImagingResultExam> list = result == null || result.imagingResults == null ? new ArrayList() : result.imagingResults;
        Collections.sort(list, new Comparator<ImagingResultExam>(){

            @Override
            public int compare(ImagingResultExam o1, ImagingResultExam o2) {
                return -o1.effectiveTime.compareTo(o2.effectiveTime);
            }
        });
        for (ImagingResultExam e : list) {
            Collections.sort(e.modality, new Comparator<Code>(){

                @Override
                public int compare(Code o1, Code o2) {
                    return o1.code.compareTo(o2.code);
                }
            });
        }
        return list;
    }

    private void searchResponse(final QueryContinuationResult result) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!ListImagingExamComposite.this.getControl().isDisposed()) {
                        List<Object> list;
                        if (result != null) {
                            list = ListImagingExamComposite.orderSearchResults(result);
                            if (result.resultTotalQuantity == null || result.resultTotalQuantity == 0) {
                                ListImagingExamComposite.this.addMessage(MSG_AUCUNES_DONNEES);
                            } else if (result.resultCurrentQuantity.intValue() != result.resultTotalQuantity.intValue()) {
                                ListImagingExamComposite.this.addMessage(result.resultCurrentQuantity + " r\u00e9sultats affich\u00e9s sur " + result.resultTotalQuantity);
                                ListImagingExamComposite.this.addMessage("D'autres occurrences non affich\u00e9es sont disponibles... ");
                                ListImagingExamComposite.this.addMessage("R\u00e9duisez votre plage de date pour voir tous les r\u00e9sultats.");
                            } else {
                                ListImagingExamComposite.this.clearMessage("default");
                            }
                        } else {
                            list = Collections.emptyList();
                            ListImagingExamComposite.this.clearMessage("default");
                        }
                        ListImagingExamComposite.this.disposeTableColumns();
                        ListImagingExamComposite.this.createTableColumns();
                        SearchItem[] items = new SearchItem[list.size()];
                        int i = 0;
                        while (i < items.length) {
                            items[i] = ListImagingExamComposite.this.newSearchItem(list.get(i));
                            ++i;
                        }
                        ListImagingExamComposite.this.loadSearchListInTable(items);
                        ListImagingExamComposite.this.callbackContainerReferenceControlFromTableItems();
                    }
                }
                catch (RuntimeException e) {
                    logger.log(Level.SEVERE, "Erreur", e);
                }
            }
        });
    }

    protected void createTableColumns() {
        this.tblSearch.setLinesVisible(false);
        this.tblSearch.setHeaderVisible(true);
        this.tableColumns = new ArrayList();
        this.tableColumns.add(new SearchColumn<ImagingResultExam>((Table)this.tblSearch, "Statut"){

            public String getText(ImagingResultExam e) {
                if ("completed".equals(e.status.code)) {
                    return "C";
                }
                return e.status.code;
            }
        });
        this.tableColumns.add(new SearchColumn<ImagingResultExam>((Table)this.tblSearch, "Code"){

            public String getText(ImagingResultExam e) {
                return StringUtils.defaultString((String)e.code.code);
            }
        });
        this.tableColumns.add(new SearchColumn<ImagingResultExam>((Table)this.tblSearch, "Description"){

            public String getText(ImagingResultExam e) {
                return StringUtils.defaultString((String)e.code.text);
            }
        });
        this.tableColumns.add(new SearchColumn<ImagingResultExam>((Table)this.tblSearch, "Date/heure"){

            public String getText(ImagingResultExam e) {
                return DateUtil.nonThreadSafeFormat((Long)e.effectiveTime, (String)"yyyy-MM-dd HH:mm:ss");
            }
        });
        this.tableColumns.add(new SearchColumn<ImagingResultExam>((Table)this.tblSearch, "ODS"){

            public String getText(ImagingResultExam e) {
                return StringUtils.defaultString((String)e.performerODS.getName());
            }
        });
        this.tableColumns.add(new SearchColumn<ImagingResultExam>((Table)this.tblSearch, "Prescripteur"){

            public String getText(ImagingResultExam e) {
                if (e.prescriber == null) {
                    return "";
                }
                return String.valueOf(e.prescriber.getFirstName()) + " " + e.prescriber.getLastName();
            }
        });
        this.tableColumns.add(new SearchColumn<ImagingResultExam>((Table)this.tblSearch, "Modalit\u00e9s"){

            public String getText(ImagingResultExam e) {
                JoinList list = new JoinList(", ");
                for (Code code : e.modality) {
                    list.add((CharSequence)code.code);
                }
                return list.toString();
            }
        });
        this.tableColumns.add(new SearchColumn<ImagingResultExam>((Table)this.tblSearch, "Statut du rapport le plus r\u00e9cent"){

            public String getText(ImagingResultExam e) {
                if (e.report != null && e.report.size() > 0) {
                    Collections.sort(e.report);
                    String code = ((ImagingResultExamReport)e.report.get((int)(e.report.size() - 1))).code.code;
                    if ("p".equalsIgnoreCase(code)) {
                        return "Pr\u00e9liminaire";
                    }
                    if ("m".equalsIgnoreCase(code)) {
                        return "Modifi\u00e9";
                    }
                    if ("f".equalsIgnoreCase(code)) {
                        return "Final";
                    }
                }
                return "Cet examen ne comporte aucun rapport.";
            }
        });
    }

    protected void processSelection(SearchItem item) {
        if (this.getReferenceControl() != null && this.getReferenceControl() instanceof IReferenceControl) {
            return;
        }
        if (item != null && item.getData() instanceof ImagingResultExam) {
            ImagingResultExam labo = (ImagingResultExam)item.getData();
            IPatient patient = this.listController.getPatient();
            EditorInput input = new EditorInput((IDataObject)ImagingResultExamElement.getPatientImage(patient, labo));
            BaseEditor.openEditorSafe((IEditorInput)input, (String)ImagingExamEditor.class.getName());
        }
    }

    protected void showContextMenu(Control parent) {
    }

    public void reset() {
        super.reset();
        this.txtPatient.setDataObject(null);
        this.txtDateFrom.setDate((IPartialDate)this.listController.getStart());
        this.txtDateTo.setDate((IPartialDate)this.listController.getEnd());
    }

    protected void createNew() {
        throw new UnsupportedOperationException();
    }

    public void setPatient(IPatient patient) {
        this.txtPatient.callback((Object)patient);
        this.listController.setPatient(patient);
        this.clearMessage();
        this.loadSearchListInTable(new SearchItem[0]);
    }

    protected SearchColumnChoiceElement[] getSearchColumnChoiceElements() {
        return null;
    }

    protected String getPreferencesKeys() {
        return null;
    }
}

