/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.search;

import ca.infodata.ofys.data.middle.dataobjects.encounter.XCode;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XLabType;
import ca.infodata.ofys.data.middle.dataobjects.medication.XDrugStrength;
import ca.infodata.ofys.data.middle.dataobjects.patient.searchElement.CodeSearchElement;
import ca.infodata.ofys.data.middle.dataobjects.patient.searchElement.ISearchElement;
import ca.infodata.ofys.data.middle.dataobjects.patient.searchElement.LabTypeSearchElement;
import ca.infodata.ofys.data.middle.dataobjects.patient.searchElement.MedicationSearchElement;
import ca.infodata.ofys.ui.controls.MyMask;
import ca.infodata.ofys.ui.controls.MyMaskedText;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.person.search.AbstractSearchDialog;
import ca.infodata.util1.StringUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SearchElementFactoryDialog {
    private static final Logger logger = Logger.getLogger(SearchElementFactoryDialog.class.getName());

    public static ISearchElement buildOn(Object searchElement) {
        ISearchElement ise = null;
        if (searchElement instanceof XCode) {
            ise = SearchElementFactoryDialog.buildFrom((XCode)searchElement);
        } else if (searchElement instanceof XLabType) {
            ise = SearchElementFactoryDialog.buildFrom((XLabType)searchElement);
        } else if (searchElement instanceof XDrugStrength) {
            ise = SearchElementFactoryDialog.buildFrom((XDrugStrength)searchElement);
        }
        return ise;
    }

    private static ISearchElement buildFrom(XCode diag) {
        if (diag == null || diag.getId() == null || diag.getClassification() == null) {
            return null;
        }
        return new CodeSearchElement(diag.getId(), diag.getClassification(), diag.getCode());
    }

    private static ISearchElement buildFrom(XDrugStrength drug) {
        if (drug == null || drug.getCommercialName() == null) {
            return null;
        }
        return new MedicationSearchElement(drug.getCommercialName());
    }

    private static ISearchElement buildFrom(XLabType lab) {
        if (lab == null || lab.getId() == null) {
            return null;
        }
        final Container response = new Container();
        final AbstractSearchDialog<XLabType> dialog = new AbstractSearchDialog<XLabType>(UI.getWorkbenchShell(), lab){
            private MyMaskedText txtMin;
            private MyMaskedText txtMax;

            @Override
            protected ISearchElement createSearchElement() {
                Float min = null;
                Float max = null;
                try {
                    if (StringUtils.isNotBlank((String)this.txtMin.getText())) {
                        min = Float.valueOf(Float.parseFloat(this.txtMin.getText()));
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Unable to get value from txtMin " + this.txtMin.getText(), e);
                }
                try {
                    if (StringUtils.isNotBlank((String)this.txtMax.getText())) {
                        max = Float.valueOf(Float.parseFloat(this.txtMax.getText()));
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Unable to get value from txtMax " + this.txtMax.getText(), e);
                }
                if (this.getData() != null) {
                    return new LabTypeSearchElement((XLabType)this.getData(), min, max);
                }
                return null;
            }

            @Override
            protected void createChilds(Composite parent, FormToolkit toolkit) {
                MyLabel lblType = new MyLabel(parent, String.valueOf(((XLabType)this.getData()).getCode()) + " - " + ((XLabType)this.getData()).getDescription(), 0, toolkit);
                MyLabel lblMin = new MyLabel(parent, "Valeur min.", 0, toolkit);
                MyLabel lblMax = new MyLabel(parent, "Valeur max.", 0, toolkit);
                this.txtMin = new MyMaskedText(parent, toolkit);
                this.txtMax = new MyMaskedText(parent, toolkit);
                MyMask minMask = new MyMask("###########");
                MyMask maxMask = new MyMask("###########");
                this.txtMin.setMask(minMask);
                this.txtMax.setMask(maxMask);
                FormData fdata = new FormData();
                fdata.top = new FormAttachment(0, 0);
                fdata.left = new FormAttachment(0, 0);
                lblType.setLayoutData((Object)fdata);
                fdata = new FormData();
                fdata.top = new FormAttachment(lblType.getControl(), 5);
                fdata.left = new FormAttachment(0, 0);
                lblMin.setLayoutData((Object)fdata);
                fdata = new FormData();
                fdata.top = new FormAttachment(lblType.getControl(), 5);
                fdata.left = new FormAttachment(lblMin.getControl(), 0);
                this.txtMin.setLayoutData((Object)fdata);
                fdata = new FormData();
                fdata.top = new FormAttachment(lblType.getControl(), 5);
                fdata.left = new FormAttachment(this.txtMin.getControl(), 0);
                lblMax.setLayoutData((Object)fdata);
                fdata = new FormData();
                fdata.top = new FormAttachment(lblType.getControl(), 5);
                fdata.left = new FormAttachment(lblMax.getControl(), 0);
                this.txtMax.setLayoutData((Object)fdata);
            }
        };
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                response.elem = dialog.open();
            }
        });
        return response.elem;
    }

    private static class Container {
        public ISearchElement elem = null;

        private Container() {
        }
    }
}

