/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.professionnal;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XPersonReplacement;
import ca.infodata.ofys.data.middle.dataobjects.XProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPreValidator;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.ui.controls.BaseSectionSwitchTable;
import ca.infodata.ofys.ui.controls.ControlDecorator;
import ca.infodata.ofys.ui.controls.DateText;
import ca.infodata.ofys.ui.controls.EditorModifyListener;
import ca.infodata.ofys.ui.controls.IBaseEditor2;
import ca.infodata.ofys.ui.controls.ListTable;
import ca.infodata.ofys.ui.controls.calendarcombo.MyCalendarText;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.professionnal.ProfessionalBySiteCombo;
import ca.infodata.ofys.ui.person.professionnal.ProfessionnalMultiEditor;
import ca.infodata.util1.ProviderAR;
import ca.infodata.util1.Range;
import ca.infodata.util1.RangeNotation;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;
import ca.infodata.util1.date.LocalDateRange;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ProfessionnalReplacementsControl
extends BaseSectionSwitchTable<XPersonReplacement>
implements IPreValidator,
ListTable.IListTableModificationListener<XPersonReplacement> {
    private static final String REMPLACEMENTS = Messages.getString((String)"REMPLACEMENTS", (String[])new String[0]);
    private static final String REMPLACANT = Messages.getString((String)"REMPLACANT", (String[])new String[0]);
    private static final String DEBUT = Messages.getString((String)"DATE_DEBUT", (String[])new String[0]);
    private static final String FIN = Messages.getString((String)"DATE_FIN", (String[])new String[0]);
    protected XPersonReplacement current;
    private String error;
    private MyCalendarText txtStartDate;
    private MyCalendarText txtEndDate;
    private ProfessionalBySiteCombo cmbProfessional;

    public ProfessionnalReplacementsControl(Composite parent, ProfessionnalMultiEditor baseMultiEditor, FormToolkit toolkit) {
        super(parent, (IBaseEditor2)baseMultiEditor, ListTable.HIDE_UP_DOWN | ListTable.TOP, toolkit);
        this.addTableModificationListener(this);
    }

    protected void createEditionControl(Composite parent) {
        MyLabel lblReplacement = new MyLabel(parent, REMPLACANT, 0, this.toolkit);
        this.cmbProfessional = new ProfessionalBySiteCombo(parent, 8, this.toolkit);
        this.cmbProfessional.fill();
        ControlDecorator.decorateWithRequiredField((Control)this.cmbProfessional.getControl());
        MyLabel lblStartDate = new MyLabel(parent, DEBUT, 0, this.toolkit);
        this.txtStartDate = new MyCalendarText(parent, 0, this.toolkit, true);
        ControlDecorator.decorateWithRequiredField((Control)this.txtStartDate);
        MyLabel lblEndDate = new MyLabel(parent, FIN, 0, this.toolkit);
        this.txtEndDate = new MyCalendarText(parent, 0, this.toolkit, true);
        ControlDecorator.decorateWithRequiredField((Control)this.txtEndDate);
        this.getTable().setHeaderVisible(true);
        this.getTable().setLinesVisible(true);
        this.addColumn(120, REMPLACANT);
        this.addColumn(120, DEBUT);
        this.addColumn(120, FIN);
        this.setLabelProvider((ProviderAR)new ProviderAR<XPersonReplacement, String[]>(){

            public String[] get(XPersonReplacement a) {
                XBaseProfessionnal replacement = PersonUiPlugin.getDefault().getBaseProfessionnalByIdPerson(a.getIdReplacementPerson());
                String sreplacement = replacement.getName();
                String startdate = a.getStartDate() == null ? "" : LocalDateFormat.format((LocalDate)a.getStartDate(), (String)FormatDateProvider.getFormatDate().toString());
                String enddate = a.getEndDate() == null ? "" : LocalDateFormat.format((LocalDate)a.getEndDate(), (String)FormatDateProvider.getFormatDate().toString());
                return new String[]{sreplacement, startdate, enddate};
            }
        });
        this.txtStartDate.addDateListener((DateText.IDateListener)new EditorModifyListener(this.getParentEditor(), 16384){

            public void edited(Event e) {
                ProfessionnalReplacementsControl.this.current.setStartDate(ProfessionnalReplacementsControl.this.txtStartDate.getDate());
            }
        });
        this.txtEndDate.addDateListener((DateText.IDateListener)new EditorModifyListener(this.getParentEditor(), 16384){

            public void edited(Event e) {
                ProfessionnalReplacementsControl.this.current.setEndDate(ProfessionnalReplacementsControl.this.txtEndDate.getDate());
            }
        });
        this.cmbProfessional.addListener(13, (Listener)new EditorModifyListener(this.getParentEditor()){

            public void edited(Event e) {
                XBaseProfessionnal selection = ProfessionnalReplacementsControl.this.cmbProfessional.getSelection();
                ProfessionnalReplacementsControl.this.current.setIdReplacementPerson(selection == null ? null : selection.getIdPerson());
            }
        });
        FormLayout layout = new FormLayout();
        layout.marginBottom = 5;
        layout.marginHeight = 5;
        layout.spacing = 5;
        parent.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        lblReplacement.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblReplacement.getControl());
        data.left = new FormAttachment(0);
        this.cmbProfessional.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(this.cmbProfessional.getControl(), 20);
        lblStartDate.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblStartDate.getControl());
        data.left = new FormAttachment(this.cmbProfessional.getControl(), 20);
        this.txtStartDate.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(this.txtStartDate.getControl(), 20);
        lblEndDate.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblEndDate.getControl());
        data.left = new FormAttachment(this.txtStartDate.getControl(), 20);
        this.txtEndDate.setLayoutData((Object)data);
    }

    protected void showDataObject(XPersonReplacement a) {
        this.current = a;
        if (a == null) {
            this.cmbProfessional.selectNone();
            this.txtStartDate.setDate(null);
            this.txtEndDate.setDate(null);
        } else {
            XBaseProfessionnal replacement = PersonUiPlugin.getDefault().getBaseProfessionnalByIdPerson(a.getIdReplacementPerson());
            this.cmbProfessional.select(replacement);
            this.txtStartDate.setDate((IPartialDate)a.getStartDate());
            this.txtEndDate.setDate((IPartialDate)a.getEndDate());
        }
    }

    protected XPersonReplacement initializeNewDataObject() {
        return new XPersonReplacement();
    }

    protected String getTitle() {
        return REMPLACEMENTS;
    }

    protected void setFirstFocus() {
        this.cmbProfessional.setFocus();
    }

    protected IPreValidator getPreValidatorNewInstance() {
        return this;
    }

    public boolean validForSave(EditableDataObject dataObject, EditableDataObject editorInput) {
        XPersonReplacement r = (XPersonReplacement)dataObject;
        this.error = "";
        if (r.getIdReplacementPerson() == null) {
            this.error = Messages.getString((String)"SELECTIONNEZ_LE_PROFESSIONNEL_REMPLACANT", (String[])new String[0]);
            return false;
        }
        if (r.getStartDate() == null) {
            this.error = Messages.getString((String)"ENTREZ_UNE_DATE_DE_DEBUT", (String[])new String[0]);
            return false;
        }
        if (r.getEndDate() == null) {
            this.error = Messages.getString((String)"ENTREZ_UNE_DATE_DE_FIN", (String[])new String[0]);
            return false;
        }
        if (r.getStartDate().after((IPartialDate)r.getEndDate())) {
            this.error = Messages.getString((String)"LA_DATE_DE_DEBUT_NE_PEUT_ETRE_APRES_LA_DATE_DE_FIN", (String[])new String[0]);
            return false;
        }
        if (r.getStartDate().before((IPartialDate)LocalDate.today()) || r.getEndDate().before((IPartialDate)LocalDate.today())) {
            this.error = Messages.getString((String)"VOUS_NE_POUVEZ_ENTREZ_UNE_DATE_DANS_LE_PASSE", (String[])new String[0]);
            return false;
        }
        if (r.getId() != null && Boolean.TRUE.equals(r.getIsDeletedB())) {
            this.error = Messages.getString((String)"VOUS_NE_POUVEZ_SUPPRIMER_UN_REMPLACEMENTS_DEJA_EXISTANT", (String[])new String[0]);
            return false;
        }
        List listReplacements = this.getProfessionnal().getListReplacements().getNotDeleted();
        ArrayList<LocalDateRange> ranges = new ArrayList<LocalDateRange>(listReplacements.size());
        for (XPersonReplacement rep : listReplacements) {
            LocalDateRange range = new LocalDateRange(null, null, RangeNotation.CLOSED);
            range.start = rep.getStartDate();
            range.end = rep.getEndDate();
            for (LocalDateRange range2 : ranges) {
                if (!range2.intersect((Range)range)) continue;
                this.error = Messages.getString((String)"VOUS_NE_POUVEZ_ENTREZ_UN_INTERVAL_DE_DATE_QUI_EN_CHEVAUCHE_UN_AUTRE", (String[])new String[0]);
                return false;
            }
            ranges.add(range);
        }
        return true;
    }

    public boolean validForDelete(EditableDataObject dataObject, EditableDataObject editorInput) {
        return true;
    }

    public boolean validForEdition(EditableDataObject dataObject, EditableDataObject editorInput) {
        return true;
    }

    public String getError() {
        return this.error;
    }

    public void saved(List<XPersonReplacement> lstBefore, List<XPersonReplacement> lstAfter, XPersonReplacement dataObject) {
        this.getParentEditor().checkDirty();
    }

    public void updated(List<XPersonReplacement> lstBefore, List<XPersonReplacement> lstAfter, XPersonReplacement dataObject) {
        this.getParentEditor().checkDirty();
    }

    public void orderUpdated(XPersonReplacement dataObject) {
        this.getParentEditor().checkDirty();
    }

    public void deleted(List<XPersonReplacement> lstBefore, List<XPersonReplacement> lstAfter, XPersonReplacement r) {
        if (r != null) {
            r.setIsDeletedB(Boolean.valueOf(true));
        }
        this.getParentEditor().checkDirty();
    }

    public XProfessionnal getProfessionnal() {
        return ((ProfessionnalMultiEditor)this.getParentEditor()).getProfessionnal();
    }
}

