/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.patient.simpleview;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.PatientAccessorClient;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.PatientFlag;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.person.patient.simpleview.CallbackMessageDialog;
import ca.infodata.ofys.ui.person.patient.simpleview.FlagControl;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PatientFlagFlagControl
extends FlagControl {
    private PatientFlag flag;
    private IPatient patient;

    public PatientFlagFlagControl(Composite parent, FormToolkit toolkit, IPatient patient, PatientFlag flag) {
        super(parent, PatientFlagFlagControl.getImage(flag), PatientFlagFlagControl.getText(flag), toolkit);
        this.patient = patient;
        this.flag = flag;
    }

    private static String getText(PatientFlag f) {
        switch (f) {
            case ALLERGIE: {
                return Messages.getString((String)"flagAllergy.tooltip", (String[])new String[0]);
            }
            case CLINICAL_REMINDERS: {
                return Messages.getString((String)"flagClinicalReminders.tooltip", (String[])new String[0]);
            }
            case ENCOUNTER_TO_REVIEW: {
                return Messages.getString((String)"flagIncompleteEncounter.tooltip", (String[])new String[0]);
            }
            case NEXT_RDV_IN_NEXT_MONTH: {
                return Messages.getString((String)"flagNextMonth.tooltip", (String[])new String[0]);
            }
            case NO_KNOWN_ALLERGY: {
                return Messages.getString((String)"flagAllergyNone.tooltip", (String[])new String[0]);
            }
            case PAST_RECALL: {
                return Messages.getString((String)"flagRecall.tooltip", (String[])new String[0]);
            }
            case RDV_LATE: {
                return Messages.getString((String)"flagLate.tooltip", (String[])new String[0]);
            }
        }
        return null;
    }

    private static Image getImage(PatientFlag f) {
        Image image = null;
        switch (f) {
            case ALLERGIE: {
                image = ResourceGetter.getImage((String)"images/flags/red_triangle.png");
                break;
            }
            case CLINICAL_REMINDERS: {
                image = ResourceGetter.getImage((String)"images/flags/reminders.gif");
                break;
            }
            case ENCOUNTER_TO_REVIEW: {
                image = ResourceGetter.getImage((String)"images/flags/enc-icon32Complrev.gif");
                break;
            }
            case NEXT_RDV_IN_NEXT_MONTH: {
                image = ResourceGetter.getImage((String)"images/flags/rendez-vous.gif");
                break;
            }
            case NO_KNOWN_ALLERGY: {
                image = ResourceGetter.getImage((String)"images/flags/green_triangle.png");
                break;
            }
            case PAST_RECALL: {
                image = ResourceGetter.getImage((String)"images/flags/alarmclock22.png");
                break;
            }
            case RDV_LATE: {
                image = ResourceGetter.getImage((String)"images/flags/rdv_late.gif");
                break;
            }
        }
        if (image != null) {
            image = ResourceGetter.getScaledImageFixed((Image)image, (float)20.0f, (float)20.0f);
        }
        return image;
    }

    @Override
    public void onClick() {
        if (this.flag.getValue() == PatientFlag.NO_KNOWN_ALLERGY.value) {
            return;
        }
        CallbackMessageDialog dialog = this.newCallbackCompositeDialog(this.flag.toString());
        dialog.buildAndOpen();
        try {
            PatientAccessorClient.getInstance().getPatientFlagDetail(Application.get().getGlobalInstances().getSession(), this.patient.getId(), this.flag, (ICallback)dialog.getCallback());
        }
        catch (Exception e) {
            dialog.showErrorComposite(e.getMessage(), e);
        }
    }
}

