/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.patient.search.control;

import ca.infodata.ofys.data.middle.dataobjects.search.CID;
import ca.infodata.ofys.ui.controls.popup.ButtonListPopupFeature;
import ca.infodata.ofys.ui.person.patient.search.control.SearchController;
import ca.infodata.ofys.ui.person.patient.search.factory.BooleanCritFactory;
import ca.infodata.ofys.ui.person.patient.search.factory.DateCritFactory;
import ca.infodata.ofys.ui.person.patient.search.factory.ECritControlFactory;
import ca.infodata.ofys.ui.person.patient.search.factory.NumberCritFactory;
import ca.infodata.ofys.ui.person.patient.search.factory.TextCritFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SearchComposite
extends Composite {
    private Map<CID, ECritControlFactory> criterias;
    private SearchController controller;

    public SearchComposite(Composite parent, int style) {
        super(parent, style);
        Button btnMore = new Button((Composite)this, 8);
        btnMore.setText("+Crit\u00e8re");
        ButtonListPopupFeature<CID> popupFeature = new ButtonListPopupFeature<CID>((Control)btnMore){

            protected String getTextForItem(CID e) {
                return e.toString();
            }

            protected List<CID> getItems() {
                return new ArrayList<CID>(SearchComposite.this.criterias.keySet());
            }

            protected void selected(CID e) {
                SearchComposite.this.add(e);
            }
        };
        btnMore.addSelectionListener((SelectionListener)new SelectionAdapter((ButtonListPopupFeature)popupFeature){
            private final /* synthetic */ ButtonListPopupFeature val$popupFeature;
            {
                this.val$popupFeature = buttonListPopupFeature;
            }

            public void widgetSelected(SelectionEvent e) {
                this.val$popupFeature.openPopupWindow();
            }
        });
        this.criterias = new HashMap<CID, ECritControlFactory>();
        RowLayout layout = new RowLayout(256);
        layout.wrap = true;
        layout.pack = true;
        this.setLayout((Layout)layout);
    }

    protected void add(CID e) {
        ECritControlFactory factory = this.criterias.get(e);
        Control control = factory.add(this, this.controller);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e2) {
                SearchComposite.this.layout(true, true);
            }
        });
        this.layout(true, true);
    }

    public void addFactory(ECritControlFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        this.criterias.put(factory.crit(), factory);
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        SearchComposite search = new SearchComposite((Composite)shell, 0);
        search.setController(new SearchController());
        search.addFactory(new TextCritFactory(CID.FIRSTNAME));
        search.addFactory(new TextCritFactory(CID.LASTNAME));
        search.addFactory(new NumberCritFactory(CID.AGE));
        search.addFactory(new DateCritFactory(CID.BIRTHDATE));
        search.addFactory(new BooleanCritFactory(CID.DELETED));
        shell.pack();
        shell.setSize(400, 400);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public SearchController getController() {
        return this.controller;
    }

    public void setController(SearchController controller) {
        this.controller = controller;
    }
}

