/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.patient;

import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.ui.controls.FontAwareGroup;
import ca.infodata.ofys.ui.controls.FontAwareLabel;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyTable;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.util1.ProviderAR;
import ca.infodata.util1.date.DateUtil;
import ca.infodata.util1.date.LocalDate;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ShowPossibleDuplicatePatientDialog {
    private static final String AVERTISSEMENT = Messages.getString((String)"ShowPossibleDuplicatePatientDialog.AVERTISSEMENT", (String[])new String[0]);
    private static final String PATIENT_EXISTANT = Messages.getString((String)"ShowPossibleDuplicatePatientDialog.PATIENT_EXISTANT", (String[])new String[0]);
    private static final String COCHER_LIGNE = Messages.getString((String)"ShowPossibleDuplicatePatientDialog.COCHER_LIGNE", (String[])new String[0]);
    private static final String POUR_SELECTIONNER = Messages.getString((String)"ShowPossibleDuplicatePatientDialog.POUR_SELECTIONNER", (String[])new String[0]);
    private static final String CE_PATIENT = Messages.getString((String)"ShowPossibleDuplicatePatientDialog.CE_PATIENT", (String[])new String[0]);
    private static final String SELECTIONNER_UN_PATIENT_DANS_LA_LISTE_AVANT = Messages.getString((String)"ShowPossibleDuplicatePatientDialog.SELECTIONNER_UN_PATIENT_DANS_LA_LISTE_AVANT", (String[])new String[0]);
    private static final String SI_NOUVEAU_PATIENT = Messages.getString((String)"ShowPossibleDuplicatePatientDialog.SI_NOUVEAU_PATIENT", (String[])new String[0]);
    private static final String POUR_AJOUTER = Messages.getString((String)"ShowPossibleDuplicatePatientDialog.POUR_AJOUTER", (String[])new String[0]);
    private static final String ANNULER = Messages.getString((String)"ShowPossibleDuplicatePatientDialog.ANNULER", (String[])new String[0]);
    private final Shell shell;
    private MyTable<IPatient> list;
    protected MyButton btnSelect;
    private IPatient selectedPatient;
    private boolean canceled;
    private boolean addNewPatient;
    private boolean useSelectedPatient;
    protected List<IPatient> lstPatient;

    public ShowPossibleDuplicatePatientDialog(Shell parent, List<IPatient> lst) {
        this.lstPatient = lst;
        this.shell = new Shell(parent, 67680);
        this.shell.setText(AVERTISSEMENT);
        this.createControls((Composite)this.shell);
        this.shell.setSize(650, 600);
        UI.centerComposite((Composite)this.shell, (Composite)parent);
        this.shell.open();
        UI.waitForWindowToClose((Shell)this.shell);
    }

    private void createControls(Composite parent) {
        FormLayout layout = new FormLayout();
        layout.marginBottom = 5;
        layout.marginHeight = 5;
        layout.spacing = 5;
        parent.setLayout((Layout)layout);
        FormToolkit toolkit = UI.createToolKit((Widget)parent);
        Color white = ResourceGetter.getColor((int)255, (int)255, (int)255);
        ResourceGetter.linkResourceWithWidgetLife((Object)white, (Widget)parent);
        toolkit.adapt(parent);
        StringBuilder builder = new StringBuilder(100);
        builder.append(PATIENT_EXISTANT);
        builder.append('\r');
        builder.append('\r');
        builder.append(COCHER_LIGNE);
        builder.append('\r');
        builder.append("<< ");
        builder.append(CE_PATIENT);
        builder.append(POUR_SELECTIONNER);
        builder.append('\r');
        builder.append("<< ");
        builder.append(SI_NOUVEAU_PATIENT);
        builder.append(POUR_AJOUTER);
        FontAwareLabel lblTitle = new FontAwareLabel(parent, builder.toString(), 64, toolkit);
        FontAwareGroup grpChoice = new FontAwareGroup(parent, 0, toolkit);
        grpChoice.setLayout((Layout)new FormLayout());
        this.list = new MyTable((Composite)grpChoice, 67584);
        this.list.setHeaderVisible(true);
        this.list.setLinesVisible(true);
        this.list.addColumn(200, Messages.getString((String)"NOM", (String[])new String[0]), 16384, (ProviderAR)new ProviderAR<IPatient, String>(){

            public String get(IPatient object) {
                return object.getName();
            }
        });
        this.list.addColumn(200, Messages.getString((String)"DDN", (String[])new String[0]), 16384, (ProviderAR)new ProviderAR<IPatient, String>(){

            public String get(IPatient object) {
                return DateUtil.format((LocalDate)object.getBirthDate());
            }
        });
        this.list.addColumn(200, Messages.getString((String)"SEXE", (String[])new String[0]), 16384, (ProviderAR)new ProviderAR<IPatient, String>(){

            public String get(IPatient object) {
                return object.getGender();
            }
        });
        this.list.addColumn(200, Messages.getString((String)"NAM", (String[])new String[0]), 16384, (ProviderAR)new ProviderAR<IPatient, String>(){

            public String get(IPatient object) {
                return object.getHealthInsuranceNumber();
            }
        });
        this.list.addColumn(200, Messages.getString((String)"DOSSIER", (String[])new String[0]), 16384, (ProviderAR)new ProviderAR<IPatient, String>(){

            public String get(IPatient object) {
                return object.getFormatedPatientRecordNumber();
            }
        });
        this.list.setItems(this.lstPatient);
        UI.autoAdjustColumnWidthToContent((Table)this.list.getControl());
        this.list.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ShowPossibleDuplicatePatientDialog.this.btnSelect.setEnabled(ShowPossibleDuplicatePatientDialog.this.list.getSelection3() != null);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnSelect = new MyButton(parent, CE_PATIENT, 8, toolkit);
        this.btnSelect.setBackground(white);
        this.btnSelect.setEnabled(false);
        this.btnSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShowPossibleDuplicatePatientDialog.this.onSelectPatient();
            }
        });
        MyButton btnNewPatient = new MyButton(parent, SI_NOUVEAU_PATIENT, 8, toolkit);
        btnNewPatient.setBackground(white);
        btnNewPatient.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShowPossibleDuplicatePatientDialog.this.onNewPatient();
            }
        });
        MyButton btnCancel = new MyButton(parent, ANNULER, 8, toolkit);
        btnCancel.setBackground(white);
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShowPossibleDuplicatePatientDialog.this.onCancel();
            }
        });
        FormData data = new FormData();
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        data.top = new FormAttachment(0, 5);
        lblTitle.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        data.top = new FormAttachment(lblTitle.getControl(), 5);
        data.bottom = new FormAttachment(this.btnSelect.getControl(), 0);
        grpChoice.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        data.bottom = new FormAttachment(btnNewPatient.getControl());
        this.btnSelect.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        data.bottom = new FormAttachment(btnCancel.getControl());
        btnNewPatient.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        data.bottom = new FormAttachment(100, 0);
        btnCancel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0);
        data.top = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100, 0);
        this.list.setLayoutData((Object)data);
    }

    void onNewPatient() {
        this.addNewPatient = true;
        this.useSelectedPatient = false;
        this.canceled = false;
        this.shell.close();
    }

    void onSelectPatient() {
        this.selectedPatient = (IPatient)this.list.getSelection3();
        if (this.selectedPatient == null) {
            MessageUtil.warningMsg((Shell)this.shell, (String)SELECTIONNER_UN_PATIENT_DANS_LA_LISTE_AVANT);
        }
        this.addNewPatient = false;
        this.useSelectedPatient = true;
        this.canceled = false;
        if (this.selectedPatient != null) {
            this.shell.close();
        }
    }

    void onCancel() {
        this.addNewPatient = false;
        this.useSelectedPatient = false;
        this.canceled = true;
        this.shell.close();
    }

    public IPatient getSelectedPatient() {
        return this.selectedPatient;
    }

    public boolean isAddNewPatient() {
        return this.addNewPatient;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public boolean isUseSelectedPatient() {
        return this.useSelectedPatient;
    }
}

