/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.patient;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.DelegateSearchTextAccessor;
import ca.infodata.ofys.data.dataaccess.ISearchTextAccessor;
import ca.infodata.ofys.data.dataaccess.PatientAccessorClient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.patient.IPatientRelated;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.NoSessionWarningComposite;
import ca.infodata.ofys.ui.controls.form.IReferenceControl;
import ca.infodata.ofys.ui.controls.form.ISearchTextListener;
import ca.infodata.ofys.ui.controls.form.MySearchText;
import ca.infodata.ofys.ui.controls.plugins.searchview.BaseSearchView;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.person.patient.IPatientSearchTextListener;
import ca.infodata.ofys.ui.person.patient.NotFoundPatient;
import ca.infodata.ofys.ui.person.patient.NullPatient;
import ca.infodata.ofys.ui.person.patient.PatientMultiEditor;
import ca.infodata.ofys.ui.person.patient.PatientUtil;
import ca.infodata.ofys.ui.person.search.PatientSearchComposite;
import ca.infodata.ofys.ui.person.search.PatientSearchView;
import ca.infodata.util1.ProviderAR;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PatientSearchText
extends MySearchText {
    private boolean useSearchDialog;
    private IPatientSearchTextListener patientSearchTextListener;

    public PatientSearchText(Composite parent, int style, FormToolkit toolkit) {
        this(parent, style, toolkit, null);
    }

    public PatientSearchText(Composite parent, int style, FormToolkit toolkit, String message) {
        super(parent, style, toolkit, message);
        this.setSearchOnFocusLost(false);
        this.setSearchOnTab(true);
        this.getMyText().setValidStyle(16);
        this.setSearchTextAccessor((ISearchTextAccessor)new DelegateSearchTextAccessor(PatientAccessorClient.class));
        this.getBtnOpen().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPatient p;
                PatientMultiEditor editor;
                if (PatientSearchText.this.getDataObject() != null && PatientSearchText.this.getDataObject() instanceof IPatient && (editor = (PatientMultiEditor)BaseEditor.openEditorSafePlain((IEditorInput)new EditorInput((IDataObject)PatientUtil.getBasePatient(p = (IPatient)PatientSearchText.this.getDataObject())), (String)PatientMultiEditor.class.getName())) != null) {
                    editor.setActivePage(editor.getiGeneralPage());
                }
            }
        });
        this.getBtnSearch().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatientSearchText.this.showPatientSearch();
            }
        });
        this.setLabelProvider((ProviderAR)new ProviderAR<IDataObject, String>(){

            public String get(IDataObject object) {
                if (object instanceof NotFoundPatient) {
                    return "Patient non trouv\u00e9";
                }
                if (object instanceof NullPatient) {
                    return "";
                }
                if (object instanceof IPatient) {
                    return ((IPatient)object).getNameBirthdateSex();
                }
                if (object instanceof IPatientRelated) {
                    return this.get((IDataObject)((IPatientRelated)object).getPatient());
                }
                return "";
            }
        });
        this.setTextProvider((ProviderAR)new ProviderAR<IDataObject, String>(){

            public String get(IDataObject object) {
                if (object instanceof NotFoundPatient) {
                    return "";
                }
                if (object instanceof NullPatient) {
                    return "";
                }
                if (object instanceof IPatient) {
                    return ((IPatient)object).getPatientRecordNumber();
                }
                if (object instanceof IPatientRelated) {
                    return this.get((IDataObject)((IPatientRelated)object).getPatient());
                }
                return "";
            }
        });
        this.addSearchTextListener(new ISearchTextListener(){

            public void objectReceived(IDataObject dataObject) {
                if (PatientSearchText.this.patientSearchTextListener != null) {
                    if (dataObject instanceof IPatient) {
                        IPatient patient = (IPatient)dataObject;
                        PatientSearchText.this.patientSearchTextListener.objectReceived(patient);
                    } else if (dataObject instanceof IPatientRelated) {
                        IPatientRelated patientRelated = (IPatientRelated)dataObject;
                        PatientSearchText.this.patientSearchTextListener.objectReceived(patientRelated.getPatient());
                    } else {
                        PatientSearchText.this.patientSearchTextListener.objectReceived(null);
                    }
                }
            }
        });
    }

    protected void showPatientSearch() {
        if (this.useSearchDialog) {
            PatientSearchText.showPatientSearchDialog(this.getShell(), (IReferenceControl)this);
        } else {
            BaseSearchView.openView(PatientSearchView.class, (Object)((Object)this));
        }
    }

    public static Shell showPatientSearchDialog(Shell parent, IReferenceControl referenceControl) {
        final Shell shell = new Shell(parent, 65600);
        shell.setLayout((Layout)new FillLayout());
        if (Application.get().getGlobalInstances().getSession() == null) {
            new NoSessionWarningComposite((Composite)shell, 0);
        } else {
            PatientSearchComposite searchComposite = new PatientSearchComposite((Composite)shell, 0){

                @Override
                protected void createMyControl(Composite parent, FormToolkit toolkit) {
                    this.setSimpleSearchMode(true);
                    this.setIsWithButtonNew(false);
                    this.setLblMessageActif(false);
                    super.createMyControl(parent, toolkit);
                }

                public void close() {
                    shell.close();
                }
            };
            searchComposite.setReferenceControl(referenceControl);
        }
        shell.setSize(600, 400);
        UI.centerComposite((Composite)shell, (Composite)shell.getParent());
        shell.open();
        return shell;
    }

    public boolean isUseSearchDialog() {
        return this.useSearchDialog;
    }

    public void setUseSearchDialog(boolean useSearchDialog) {
        this.useSearchDialog = useSearchDialog;
    }

    public IPatientSearchTextListener getPatientSearchTextListener() {
        return this.patientSearchTextListener;
    }

    public void setPatientSearchTextListener(IPatientSearchTextListener patientSearchTextListener) {
        this.patientSearchTextListener = patientSearchTextListener;
    }
}

