/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.menu.identifiers;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CompletionComboAccessorClient;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XImageDecorator;
import ca.infodata.ofys.data.middle.dataobjects.XRight;
import ca.infodata.ofys.data.middle.dataobjects.identifiers.XBaseIdentifierType;
import ca.infodata.ofys.data.middle.dataobjects.identifiers.XIdentifierType;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ICompletionComboItem;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.ui.controls.ITreeElements;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.menu.DossierPlugin;
import ca.infodata.ofys.ui.menu.treeelements.LoadingElement;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.menu.identifiers.IdentifierTypeElements;
import ca.infodata.ofys.ui.person.menu.identifiers.NewIdentifierTypeElement;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;

public class ListIdentifierType
implements ITreeElements,
CompletionComboAccessorClient.CompletionComboListener {
    private ITreeElements parent;
    private ITreeElements[] children;

    public ListIdentifierType(ITreeElements parent) {
        if (parent == null) {
            throw new NullPointerException("parent");
        }
        this.parent = parent;
        CompletionComboAccessorClient.addListener((String)XBaseIdentifierType.type, (CompletionComboAccessorClient.CompletionComboListener)this);
    }

    public Object[] getChildren() {
        if (this.children == null) {
            this.findTypes();
            if (Application.get().getGlobalInstances().hasRight(XRight.EDIT_IDENTIFIER_TYPE)) {
                return new ITreeElements[]{new NewIdentifierTypeElement(this), new LoadingElement((ITreeElements)this)};
            }
            return new ITreeElements[]{new LoadingElement((ITreeElements)this)};
        }
        return this.children;
    }

    private void findTypes() {
        JobCallback callback = new JobCallback(Messages.getString((String)"RECHERCHE", (String[])new String[0]), (IStatusHandler)DefaultStatusHandler.getInstance()){

            public void responseReceived(ReturnObject response) {
                ListIdentifierType.this.fillChildren((List)response.getObj());
            }

            public void exception(Exception e) {
                super.exception(e);
                ListIdentifierType.this.fillChildren(null);
            }
        };
        try {
            CompletionComboAccessorClient.getInstance().findAllAsync(Application.get().getGlobalInstances().getSession(), (ICallback)callback, XBaseIdentifierType.type);
        }
        catch (Exception e) {
            MessageUtil.show((Exception)e);
            if (callback != null && !callback.killed()) {
                callback.kill();
            }
            this.fillChildren(null);
        }
    }

    private void fillChildren(List<XIdentifierType> list) {
        list = list == null ? new ArrayList(0) : list;
        Collections.sort(list, new Comparator<XIdentifierType>(){

            @Override
            public int compare(XIdentifierType o1, XIdentifierType o2) {
                if (o1 == o2) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                if (o1.getName() == o2.getName()) {
                    return 0;
                }
                if (o1.getName() == null) {
                    return -1;
                }
                if (o2.getName() == null) {
                    return 1;
                }
                return StringUtils.compareAscii((String)o1.getName(), (String)o2.getName());
            }
        });
        ArrayList<IdentifierTypeElements> listChild = new ArrayList<IdentifierTypeElements>(list.size());
        if (Application.get().getGlobalInstances().hasRight(XRight.EDIT_IDENTIFIER_TYPE)) {
            listChild.add(new NewIdentifierTypeElement(this));
        }
        for (XIdentifierType type : list) {
            listChild.add(new IdentifierTypeElements(this, (XBaseIdentifierType)type));
        }
        this.children = listChild.toArray(new ITreeElements[listChild.size()]);
        DossierPlugin.getDefault().refreshTree((ITreeElements)this);
    }

    public Object getParent() {
        return this.parent;
    }

    public boolean hasChildren() {
        return true;
    }

    public String getText() {
        return Messages.getString((String)"TYPES_DIDENTIFICATEURS", (String[])new String[0]);
    }

    public String getTooltipText() {
        return this.getText();
    }

    public Image getImage() {
        return ResourceGetter.getImage((String)"images/identifier.gif");
    }

    public String getEditorClass() {
        return null;
    }

    public IEditorInput getEditorInput() {
        return null;
    }

    public XImageDecorator getDecorators() {
        return XImageDecorator.NULL_DECORATORS;
    }

    public void showContextMenu(Control control) {
    }

    public int hashCode() {
        return new String(String.valueOf(this.parent.hashCode()) + " " + this.getClass().getName()).hashCode();
    }

    public boolean equals(Object toCompare) {
        boolean ret = false;
        if (toCompare instanceof ListIdentifierType && toCompare.hashCode() == this.hashCode()) {
            ret = true;
        }
        return ret;
    }

    public void doKeyListener(Control control, KeyEvent ke) {
    }

    public void shouldRefresh(ICompletionComboItem item) {
        PersonUiPlugin.getDefault().getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ListIdentifierType.this.findTypes();
                DossierPlugin.getDefault().refreshTree((ITreeElements)ListIdentifierType.this);
            }
        });
    }

    public int getChildrenNumberForPastille() {
        return 0;
    }
}

