/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.menu;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.PatientAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XImageDecorator;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.ui.controls.ITreeElements;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.intro.IntroPlugin;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.ofys.ui.menu.treeelements.LoadingElement;
import ca.infodata.ofys.ui.person.menu.element.PatientElements;
import java.util.ArrayList;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;

public class ListPatientMostUsed
implements ITreeElements {
    private final ITreeElements parent;
    private ITreeElements[] children;

    private ListPatientMostUsed(ITreeElements parent) {
        this.parent = parent;
    }

    public Object[] getChildren() {
        if (this.children == null) {
            this.findMostUsedPatients();
            return new ITreeElements[]{new LoadingElement((ITreeElements)this)};
        }
        return this.children;
    }

    private void findMostUsedPatients() {
        JobCallback callback = new JobCallback(Messages.getString((String)"RECHERCHE_LES_CLIENTS_LES_PLUS_UTILISES", (String[])new String[0]), (IStatusHandler)DefaultStatusHandler.getInstance()){

            public void responseReceived(ReturnObject response) {
                ListPatientMostUsed.this.fillChildren((XPatient[])response.getObj());
            }
        };
        try {
            PatientAccessorClient.getInstance().findMostUsed(Application.get().getGlobalInstances().getSession(), (ICallback)callback);
        }
        catch (CannotConnectToServerException cannotConnectToServerException) {
            MessageUtil.cannotConnectToServerExceptionMsg();
            if (callback != null && !callback.killed()) {
                callback.kill();
            }
            this.fillChildren(null);
        }
        catch (Exception e) {
            Log.severe((Throwable)e);
            if (callback != null && !callback.killed()) {
                callback.kill();
            }
            this.fillChildren(null);
        }
    }

    private void fillChildren(XPatient[] patients) {
        if (patients == null) {
            this.children = new ITreeElements[0];
        } else {
            ArrayList<PatientElements> listChild = new ArrayList<PatientElements>(patients.length);
            XPatient[] xPatientArray = patients;
            int n = patients.length;
            int n2 = 0;
            while (n2 < n) {
                XPatient patient = xPatientArray[n2];
                listChild.add(new PatientElements(this, patient));
                ++n2;
            }
            this.children = listChild.toArray(new ITreeElements[listChild.size()]);
        }
        IntroPlugin.getDefault().refreshViews((Object)this);
    }

    public Object getParent() {
        return this.parent;
    }

    public boolean hasChildren() {
        return true;
    }

    public String getText() {
        return Messages.getString((String)"FREQUENTLYSEEN", (String[])new String[0]);
    }

    public String getTooltipText() {
        return this.getText();
    }

    public Image getImage() {
        return ResourceGetter.getImage((String)"images/persons-icon16.png");
    }

    public String getEditorClass() {
        return null;
    }

    public IEditorInput getEditorInput() {
        return null;
    }

    public XImageDecorator getDecorators() {
        return XImageDecorator.NULL_DECORATORS;
    }

    public void showContextMenu(Control control) {
    }

    public int hashCode() {
        return new String(String.valueOf(this.parent.hashCode()) + " " + this.getClass().getName()).hashCode();
    }

    public boolean equals(Object toCompare) {
        boolean ret = false;
        if (toCompare instanceof ListPatientMostUsed && toCompare.hashCode() == this.hashCode()) {
            ret = true;
        }
        return ret;
    }

    public void doKeyListener(Control control, KeyEvent ke) {
    }

    public int getChildrenNumberForPastille() {
        return 0;
    }
}

