/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.menu;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.LoginAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.Callback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.middle.dataobjects.XActiveSession;
import ca.infodata.ofys.data.middle.dataobjects.XBaseUser;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.ui.controls.AbstractTreeElement;
import ca.infodata.ofys.ui.controls.ITreeElements;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.intro.IntroPlugin;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.menu.treeelements.LoadingElement;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.menu.ActiveSessionElement;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Image;

public class ListActiveSessionsElement
extends AbstractTreeElement {
    private static final Logger logger = Logger.getLogger(ListActiveSessionsElement.class.getName());
    private List<ITreeElements> childs;
    private ITreeElements[] children;

    public ListActiveSessionsElement(ITreeElements parent) {
        super(parent);
    }

    public Object[] getChildren() {
        if (this.children == null) {
            this.children = new ITreeElements[]{new LoadingElement((ITreeElements)this)};
            this.find();
        }
        return this.children;
    }

    private void find() {
        Callback callback = new Callback((IStatusHandler)DefaultStatusHandler.getInstance()){

            public void responseReceived(ReturnObject response) {
                ListActiveSessionsElement.this.fillChildren((List)response.getObj());
            }
        };
        try {
            LoginAccessorClient.getInstance().findActiveSessions(Application.get().getGlobalInstances().getSession(), (ICallback)callback);
        }
        catch (CannotConnectToServerException e) {
            logger.log(Level.INFO, "Failed to find active sessions", e);
            if (callback != null && !callback.killed()) {
                callback.kill();
            }
            this.fillChildren(null);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to find active sessions", e);
            if (callback != null && !callback.killed()) {
                callback.kill();
            }
            this.fillChildren(null);
        }
    }

    protected void fillChildren(List<XActiveSession> activesSessions) {
        if (activesSessions == null) {
            activesSessions = new ArrayList<XActiveSession>();
        }
        this.childs = new ArrayList<ITreeElements>();
        Collections.sort(activesSessions, new Comparator<XActiveSession>(){

            @Override
            public int compare(XActiveSession o1, XActiveSession o2) {
                XBaseUser user1 = PersonUiPlugin.getDefault().getUser(o1.userId);
                XBaseUser user2 = PersonUiPlugin.getDefault().getUser(o2.userId);
                return StringUtils.compareAscii((String)user1.getPersonNameOrTextOrEmpty(), (String)user2.getPersonNameOrTextOrEmpty());
            }
        });
        for (XActiveSession s : activesSessions) {
            this.childs.add(new ActiveSessionElement(this, s));
        }
        this.children = this.childs.toArray(new ITreeElements[this.childs.size()]);
        IntroPlugin.getDefault().refreshViews((Object)this);
    }

    protected void removeFromChildren(ActiveSessionElement element) {
        this.childs.remove(element);
        this.children = this.childs.toArray(new ITreeElements[this.childs.size()]);
        IntroPlugin.getDefault().refreshViews((Object)this);
    }

    public boolean hasChildren() {
        return true;
    }

    public String getText() {
        return "Liste des sessions actives";
    }

    public Image getImage() {
        return ResourceGetter.getImage((String)"images/person_lock.gif");
    }
}

