/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.group;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.util.notification.IConsumerListener;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XPersonGroup;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.data.middle.dataobjects.notification.Notification;
import ca.infodata.ofys.ui.controls.AbstractTreeElement;
import ca.infodata.ofys.ui.controls.ITreeElements;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.menu.DossierPlugin;
import ca.infodata.ofys.ui.person.group.NewPersonGroupElement;
import ca.infodata.ofys.ui.person.group.PersonGroupElement;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Image;

public class PersonGroupListElement
extends AbstractTreeElement {
    private static final Logger logger = Logger.getLogger(PersonGroupListElement.class.getName());
    private final IConsumerListener consumerListener = new IConsumerListener(){

        public void handle(DataObjectUpdatedNotification notification) {
            try {
                if (notification != null && notification.getObject() instanceof XPersonGroup) {
                    DossierPlugin.getDefault().refreshTreeInSwtThread((ITreeElements)PersonGroupListElement.this);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error in PersonGroupListElement.handle", e);
            }
        }

        public void handleOther(Notification notification) {
        }

        public void forceRefresh() {
            try {
                DossierPlugin.getDefault().refreshTreeInSwtThread((ITreeElements)PersonGroupListElement.this);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error in PersonGroupListElement.forceRefresh", e);
            }
        }
    };

    public PersonGroupListElement(ITreeElements parent) {
        super(parent);
        Application.get().getGlobalInstances().getNotificationSystem().addListener(this.consumerListener);
    }

    public Object[] getChildren() {
        ArrayList<NewPersonGroupElement> lstChilds = new ArrayList<NewPersonGroupElement>();
        XSession session = Application.get().getGlobalInstances().getSession();
        if (session != null) {
            lstChilds.addAll(this.getChildrenByExtension());
            lstChilds.add(new NewPersonGroupElement((ITreeElements)this));
            Application.get().getPersonPluginController().getAllPersonGroups().forEachOrdered(group -> lstChilds.add((NewPersonGroupElement)((Object)new PersonGroupElement((ITreeElements)this, (XPersonGroup)group))));
        }
        Object[] child = new ITreeElements[lstChilds.size()];
        int i = 0;
        while (i < child.length) {
            child[i] = (ITreeElements)lstChilds.get(i);
            ++i;
        }
        return child;
    }

    public boolean hasChildren() {
        return true;
    }

    public String getText() {
        return Messages.getString((String)"GROUPE_DE_PERSONNES", (String[])new String[0]);
    }

    public Image getImage() {
        return ResourceGetter.getImage((String)"images/persons-icon16.png");
    }
}

