/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.modules.person.AbstractPersonPluginController;
import ca.infodata.ofys.client.modules.person.DefaultNamValidatorService;
import ca.infodata.ofys.client.modules.person.INamValidatorService;
import ca.infodata.ofys.data.dataaccess.util.GlobalInstancesAdapter;
import ca.infodata.ofys.data.dataaccess.util.GlobalInstancesListener;
import ca.infodata.ofys.data.dataaccess.util.notification.DataObjectNotificationHandler;
import ca.infodata.ofys.data.middle.dataobjects.XBaseEmployee;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XBaseUser;
import ca.infodata.ofys.data.middle.dataobjects.XEmployee;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.XPersonGroup;
import ca.infodata.ofys.data.middle.dataobjects.XPersonReplacement;
import ca.infodata.ofys.data.middle.dataobjects.XProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.mb.listener.property.PropertyListenerManager;
import ca.infodata.ofys.ui.person.BaseEmployeeCache;
import ca.infodata.ofys.ui.person.BaseProfCache;
import ca.infodata.ofys.ui.person.CurrentPatientProvider;
import ca.infodata.ofys.ui.person.EmployeeCache;
import ca.infodata.ofys.ui.person.PersonGroupCache;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.ProfCache;
import ca.infodata.ofys.ui.person.ReplacementCache;
import ca.infodata.ofys.ui.person.UserCache;
import ca.infodata.ofys.ui.person.patient.AdHocPatient;
import ca.infodata.ofys.ui.person.patient.PatientUtil;
import ca.infodata.ofys.util.MiscUtil;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.ISourceProviderService;

public class PersonPluginController
extends AbstractPersonPluginController {
    private static final Logger logger = Logger.getLogger(PersonPluginController.class.getName());
    private INamValidatorService namValidatorService;
    private BaseProfCache baseProfCache;
    private BaseEmployeeCache baseEmployeeCache;
    private ProfCache profCache;
    private EmployeeCache employeeCache;
    private UserCache userCache;
    private ReplacementCache replacementCache;
    private PersonGroupCache personGroupCache;
    private Object currentPatient2;
    private XPatient currentPatient;
    private GlobalInstancesAdapter globalInstancesListener;
    private DataObjectNotificationHandler dataObjectNotificationHandler;
    private long timeItemInPatientClicked = System.currentTimeMillis();
    private String codeClient;

    public PersonPluginController() {
        this.namValidatorService = new DefaultNamValidatorService();
        this.baseProfCache = new BaseProfCache();
        this.baseEmployeeCache = new BaseEmployeeCache();
        this.profCache = new ProfCache();
        this.employeeCache = new EmployeeCache();
        this.userCache = new UserCache();
        this.replacementCache = new ReplacementCache();
        this.personGroupCache = new PersonGroupCache();
        this.globalInstancesListener = new GlobalInstancesAdapter(){

            public void sessionChanged() {
                String newCodeClient = this.getNewCodeClient();
                if (!MiscUtil.areObjectsEquals((Object)PersonPluginController.this.codeClient, (Object)newCodeClient)) {
                    PersonPluginController.this.codeClient = newCodeClient;
                    PersonPluginController.this.setCurrentPatient(null);
                }
            }

            private String getNewCodeClient() {
                try {
                    XSession session = Application.get().getGlobalInstances().getSession();
                    if (session != null) {
                        return session.getClient().getClientCode();
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Failed to get codeClient from xsession bug", e);
                }
                return null;
            }

            public void logout() {
                PersonPluginController.this.setCurrentPatient(null);
                super.logout();
            }
        };
        this.dataObjectNotificationHandler = new DataObjectNotificationHandler(){

            public void handle(DataObjectUpdatedNotification notification) {
                XPatient notificationPatient;
                if (notification != null && notification.getObject() instanceof XPatient && (notificationPatient = (XPatient)notification.getObject()).equals((Object)PersonPluginController.this.currentPatient)) {
                    boolean forceNull = false;
                    boolean forceRefresh = true;
                    PersonPluginController.this.setCurrentPatient((IPatient)notificationPatient, forceNull, forceRefresh);
                }
            }
        };
        Application.get().getGlobalInstances().addGlobalInstancesListener((GlobalInstancesListener)this.globalInstancesListener);
        Application.get().getGlobalInstances().getNotificationSystem().addDataObjectNotificationHandler(this.dataObjectNotificationHandler);
        this.globalInstancesListener.sessionChanged();
    }

    public final void setTimeItemInPatientClicked(long timeItemInPatientClicked) {
        this.timeItemInPatientClicked = timeItemInPatientClicked;
    }

    public void setCurrentPatient2(Object patient) {
        if (MiscUtil.areObjectsEquals((Object)patient, (Object)this.currentPatient2)) {
            return;
        }
        if (patient instanceof AdHocPatient) {
            try {
                this.currentPatient2 = null;
                this.setCurrentPatient(null, true);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to get simple patient with arg " + patient, e);
            }
        } else {
            XPatient patient2 = null;
            try {
                patient2 = PatientUtil.getSimplePatient(patient);
                this.currentPatient2 = patient2;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to get simple patient with arg " + patient, e);
            }
            this.setCurrentPatient((IPatient)patient2);
        }
    }

    public XPatient getCurrentPatient() {
        return this.currentPatient;
    }

    public void setCurrentPatient(IPatient patient) {
        if (patient instanceof AdHocPatient) {
            this.setCurrentPatient(null, true);
        } else {
            this.setCurrentPatient(patient, false);
        }
    }

    public void setCurrentPatient(IPatient patient, boolean forceNull) {
        this.setCurrentPatient(patient, forceNull, false);
    }

    void setCurrentPatient(IPatient patient, boolean forceNull, boolean forceRefresh) {
        if (System.currentTimeMillis() - this.timeItemInPatientClicked < 200L) {
            System.out.println("setCurrentPatient Called too soon!");
            return;
        }
        if (patient == null && forceNull) {
            this.currentPatient = null;
        } else {
            if (!forceRefresh) {
                if (patient == null && this.currentPatient != null) {
                    return;
                }
                if (patient != null && patient.getId() != null && this.currentPatient != null && patient.getId().equals(this.currentPatient.getId())) {
                    return;
                }
            }
            if (this.currentPatient != null) {
                Application.get().getGlobalInstances().getNotificationSystem().removePatientEformRessRoutingKey(this.currentPatient.getId());
            }
            this.currentPatient = PatientUtil.getXPatient(patient);
            if (patient != null) {
                Application.get().getGlobalInstances().getNotificationSystem().addPatientEformRessRoutingKey(patient.getId());
            }
        }
        PropertyListenerManager.firePropertyChanged((Object)((Object)PersonUiPlugin.getDefault()), (int)1);
        ISourceProviderService service = (ISourceProviderService)PlatformUI.getWorkbench().getService(ISourceProviderService.class);
        final CurrentPatientProvider provider = (CurrentPatientProvider)service.getSourceProvider("ca.infodata.ofys.ui.person.currentPatientIsNotNull");
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                provider.refresh();
            }
        });
    }

    public XBaseUser getUser(Integer id) {
        return this.userCache.getById(id, true);
    }

    public XBaseUser getUserByIdPerson(Integer id) {
        return this.userCache.getByIdPerson(id, true);
    }

    public Set<XBaseUser> getUsers() {
        return this.userCache.getAll();
    }

    public XBaseProfessionnal getProfessionnalByNoProf(String noprof) {
        if (noprof == null) {
            return null;
        }
        return this.baseProfCache.getByNoProf(noprof);
    }

    public XBaseProfessionnal getBaseProfessionnalByIdPerson(Integer idClient, Integer idPerson, boolean logIfNotFound, boolean mustTryFindServer) {
        return this.getBaseProfessionnalByIdPerson(idPerson, logIfNotFound, mustTryFindServer);
    }

    public XBaseProfessionnal getBaseProfessionnalByIdPerson(Integer idPerson, boolean logIfNotFound, boolean mustTryFindServer) {
        if (idPerson == null) {
            return null;
        }
        return this.baseProfCache.getByIdPerson(idPerson, logIfNotFound, mustTryFindServer);
    }

    public Stream<XBaseProfessionnal> getTreatingProfessionnals() {
        return this.baseProfCache.getAllTreatingPhysicians().sorted();
    }

    public XBaseProfessionnal getBaseProfessionnal(Integer id) {
        if (id == null || id == Integer.MIN_VALUE || id == -1) {
            return null;
        }
        if (id < 0) {
            XPersonGroup xg = this.personGroupCache.getById(-id.intValue(), true);
            XBaseProfessionnal x = new XBaseProfessionnal();
            x.setId(Integer.valueOf(-xg.getId().intValue()));
            x.setLastName("\u4e00GRP");
            x.setFirstName(xg.getName());
            x.useAppointment = true;
            x.str = "Groupe de prof.";
            return x;
        }
        return this.baseProfCache.getById(id, true);
    }

    public XProfessionnal getProfessionnalByIdPerson(Integer idPerson) {
        if (idPerson == null) {
            return null;
        }
        return this.profCache.getByIdPerson(idPerson, false, true);
    }

    public XProfessionnal getProfessionnalByIdPerson(Integer idPerson, boolean logIfNotFound) {
        if (idPerson == null) {
            return null;
        }
        return this.profCache.getByIdPerson(idPerson, logIfNotFound, true);
    }

    public XProfessionnal getProfessionnalByIdPerson(Integer idClient, Integer idPerson, boolean logIfNotFound, boolean mustTryFindServer) {
        if (idPerson == null) {
            return null;
        }
        return this.profCache.getByIdPerson(idPerson, logIfNotFound, mustTryFindServer);
    }

    public XProfessionnal getProfessionnalByIdPerson(Integer idPerson, boolean logIfNotFound, boolean mustTryFindServer) {
        if (idPerson == null) {
            return null;
        }
        return this.profCache.getByIdPerson(idPerson, logIfNotFound, mustTryFindServer);
    }

    public XProfessionnal getProfessionnal(Integer id) {
        if (id == null) {
            return null;
        }
        return this.profCache.getById(id, false, true);
    }

    public XBaseEmployee getBaseEmployeeByIdPerson(Integer idPerson, boolean mustLogFailed, boolean mustTryFindServer) {
        if (idPerson == null) {
            return null;
        }
        return this.baseEmployeeCache.getByIdPerson(idPerson, mustLogFailed, mustTryFindServer);
    }

    public List<XBaseEmployee> getAllBaseEmployees() {
        return this.baseEmployeeCache.getAll();
    }

    public BaseEmployeeCache getBaseEmployeeCache() {
        return this.baseEmployeeCache;
    }

    public EmployeeCache getEmployeeCache() {
        return this.employeeCache;
    }

    public INamValidatorService getNamValidatorService() {
        return this.namValidatorService;
    }

    public Stream<XPersonReplacement> findAllReplacements() {
        return this.replacementCache.getAll();
    }

    public XPersonGroup getPersonGroupById(Integer id, boolean logIfNotFound) {
        return this.getPersonGroupById(id, logIfNotFound, true);
    }

    public XPersonGroup getPersonGroupById(Integer id, boolean logIfNotFound, boolean mustTryToFindServer) {
        if (id == null) {
            return null;
        }
        return this.personGroupCache.getById(id, logIfNotFound, mustTryToFindServer);
    }

    public Stream<XPersonGroup> getAllPersonGroups() {
        return this.personGroupCache.getAll();
    }

    public Stream<XPersonGroup> getActivePersonGroups() {
        return this.personGroupCache.getAllActive();
    }

    public void dispose() {
        this.baseProfCache.dispose();
        this.profCache.dispose();
        this.baseEmployeeCache.dispose();
        this.employeeCache.dispose();
        this.userCache.dispose();
        this.replacementCache.dispose();
        this.personGroupCache.dispose();
        Application.get().getGlobalInstances().removeGlobalInstancesListener((GlobalInstancesListener)this.globalInstancesListener);
        Application.get().getGlobalInstances().getNotificationSystem().removeDataObjectNotificationHandler(this.dataObjectNotificationHandler);
    }

    public XEmployee getEmployeeByIdPerson(Integer idPerson) {
        if (idPerson == null) {
            return null;
        }
        return this.employeeCache.getByIdPerson(idPerson, false, true);
    }

    public XEmployee getEmployeeByIdPerson(Integer idPerson, boolean mustLogFailed) {
        if (idPerson == null) {
            return null;
        }
        return this.employeeCache.getByIdPerson(idPerson, mustLogFailed, true);
    }

    public XEmployee getEmployeeByIdPerson(Integer idPerson, boolean mustLogFailed, boolean mustTryFindServer) {
        if (idPerson == null) {
            return null;
        }
        return this.employeeCache.getByIdPerson(idPerson, mustLogFailed, mustTryFindServer);
    }
}

