/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CompletionComboAccessorClient;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.ProfessionnalAccessorClient;
import ca.infodata.ofys.data.dataaccess.util.ObjectCache;
import ca.infodata.ofys.data.dataaccess.util.notification.IConsumerListener;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.data.middle.dataobjects.notification.Notification;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class BaseProfCache
extends ObjectCache<XBaseProfessionnal> {
    private static final Logger logger = Logger.getLogger(BaseProfCache.class.getName());
    private static final String PROF_PERSON = "baseprps";
    private static final String PROF = "baseprof";
    private IConsumerListenerImplementation listener = new IConsumerListenerImplementation();

    public BaseProfCache() {
        super(PROF);
        Application.get().getGlobalInstances().getNotificationSystem().addListener((IConsumerListener)this.listener);
    }

    protected void load(int uniqueKey, XSession session, ICallback callback) throws Exception {
        CompletionComboAccessorClient.getInstance().findAllAsync(session, callback, XBaseProfessionnal.class.getName());
    }

    protected void add(Map<ObjectCache.Key, XBaseProfessionnal> map, XBaseProfessionnal e) {
        if (e != null) {
            map.put(new ObjectCache.Key(PROF, e.getId()), e);
            map.put(new ObjectCache.Key(PROF_PERSON, e.getIdPerson()), e);
        }
    }

    public XBaseProfessionnal getById(Integer id, boolean logIfNotFound) {
        return this.getById(id, logIfNotFound, true);
    }

    public XBaseProfessionnal getById(Integer id, boolean logIfNotFound, boolean mustTryToFindServer) {
        if (id == null) {
            return null;
        }
        return (XBaseProfessionnal)this.get(new ObjectCache.Key(PROF, id), logIfNotFound, mustTryToFindServer);
    }

    public XBaseProfessionnal getByNoProf(String noprof) {
        if (noprof == null) {
            return null;
        }
        Optional<XBaseProfessionnal> first = this.getAll().filter(prof -> prof.code.startsWith(noprof)).findFirst();
        return first.orElse(null);
    }

    public XBaseProfessionnal getByIdPerson(Integer id, boolean logIfNotFound) {
        return this.getByIdPerson(id, logIfNotFound, true);
    }

    public XBaseProfessionnal getByIdPerson(Integer id, boolean logIfNotFound, boolean mustTryToFindServer) {
        if (id == null) {
            return null;
        }
        return (XBaseProfessionnal)this.get(new ObjectCache.Key(PROF_PERSON, id), logIfNotFound, mustTryToFindServer);
    }

    protected XBaseProfessionnal loadSync(XSession session, ObjectCache.Key key) throws Exception {
        if (key == null) {
            return null;
        }
        if (PROF.equals(key.type)) {
            return (XBaseProfessionnal)ProfessionnalAccessorClient.getInstance().getProfessionnalSync(session, key.id.intValue(), true);
        }
        if (PROF_PERSON.equals(key.type)) {
            return (XBaseProfessionnal)ProfessionnalAccessorClient.getInstance().getProfessionnalByIdPersonSync(session, key.id.intValue(), true);
        }
        return null;
    }

    public Stream<XBaseProfessionnal> getAll() {
        ArrayList<XBaseProfessionnal> all = new ArrayList<XBaseProfessionnal>();
        for (Map.Entry es : this.getMap().entrySet()) {
            if (!((ObjectCache.Key)es.getKey()).type.startsWith(PROF)) continue;
            all.add((XBaseProfessionnal)es.getValue());
        }
        return all.stream().sorted();
    }

    public Stream<XBaseProfessionnal> getAllTreatingPhysicians() {
        return this.getAll().filter(prof -> prof.isProfTx);
    }

    protected void loadSync(int uniqueKey, XSession session, ICallback callback) throws Exception {
        CompletionComboAccessorClient.getInstance().findAll(session, callback, XBaseProfessionnal.class.getName());
    }

    private final class IConsumerListenerImplementation
    implements IConsumerListener {
        private IConsumerListenerImplementation() {
        }

        public void handle(DataObjectUpdatedNotification notification) {
            try {
                if (notification != null) {
                    IDataObject object = notification.getObject();
                    if (object instanceof XBaseProfessionnal) {
                        BaseProfCache.this.add((Map<ObjectCache.Key, XBaseProfessionnal>)BaseProfCache.this.getMap(), (XBaseProfessionnal)object);
                    } else if (object instanceof XProfessionnal) {
                        BaseProfCache.this.add((Map<ObjectCache.Key, XBaseProfessionnal>)BaseProfCache.this.getMap(), new XBaseProfessionnal((XProfessionnal)object));
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error in IConsumerListenerImplementation.handle", e);
            }
        }

        public void handleOther(Notification notification) {
        }

        public void forceRefresh() {
            try {
                BaseProfCache.this.reload(true);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error in ProfCache.forceRefresh", e);
            }
        }
    }
}

