/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.encounter.patient.search;

import apple.finder.search.ui.UI;
import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.encounter.AHFS;
import ca.infodata.ofys.data.middle.dataobjects.encounter.DIN;
import ca.infodata.ofys.ui.controls.SWTDelayedListener;
import ca.infodata.ofys.ui.controls.form.MyTable;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchColumn;
import ca.infodata.ofys.ui.controls.popup.PopupFeature;
import ca.infodata.rxdrugref.IRxDrugRefAccessor;
import ca.infodata.util1.ProviderAR;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class DINSearchPopupFeature
extends PopupFeature {
    private static final Logger logger = Logger.getLogger(DINSearchPopupFeature.class.getName());
    protected List<DIN> source;
    private MyTable<DIN> sourceTable;
    private final Set<DIN> model;
    private final Set<AHFS> modelAhfs;
    private String alias;
    private MyTable<DIN> modelTable;
    private boolean showAlias;
    private boolean showModelTable;
    private boolean addAhfsInsteadOfDin;

    public DINSearchPopupFeature(Control control, Set<DIN> model, String alias) {
        super(control);
        this.alias = alias;
        this.showPopupDown = true;
        this.showAlias = true;
        this.showModelTable = true;
        this.model = model;
        this.modelAhfs = null;
        this.addAhfsInsteadOfDin = false;
    }

    public DINSearchPopupFeature(Control control, Set<DIN> model, Set<AHFS> model2, String alias) {
        super(control);
        this.alias = alias;
        this.showPopupDown = true;
        this.showAlias = true;
        this.model = model;
        this.modelAhfs = model2;
        this.showModelTable = model2 == null;
        this.addAhfsInsteadOfDin = false;
    }

    protected Shell createPopupControlOverride(Shell parentShell) {
        Shell shell;
        final Shell parent = shell = new Shell(parentShell, 4);
        Label searchTip = new Label((Composite)parent, 0x1000040);
        if (this.isShowModelTable()) {
            searchTip.setText("Utiliser 'Enter' ou Double-cliquer pour ajouter et 'Supprimer' pour supprimer");
        } else {
            searchTip.setText("Utiliser 'Enter' ou Double-cliquer pour ajouter");
        }
        this.modelTable = new MyTable((Composite)parent, 68098);
        this.createTableColumns(this.modelTable);
        this.modelTable.setItems(this.model);
        Label separator = new Label((Composite)parent, 258);
        Button searchButton = new Button((Composite)parent, 8);
        searchButton.setText("Rechercher");
        final Button chkAddAHFS = new Button((Composite)parent, 32);
        chkAddAHFS.setText("Ajouter la classe th\u00e9rapheutique au lieu du din");
        chkAddAHFS.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DINSearchPopupFeature.this.addAhfsInsteadOfDin = chkAddAHFS.getSelection();
            }
        });
        final Text searchText = new Text((Composite)parent, 2048);
        searchText.setMessage("Recherche par nom commercial");
        Label lblAlias = new Label((Composite)parent, 16384);
        lblAlias.setText("Alias - Utiliser un alias pour d\u00e9crire votre s\u00e9lection \u00e0 place d'une longue liste de code");
        final Text txtAlias = new Text((Composite)parent, 2052);
        txtAlias.setText(this.alias == null ? "" : this.alias);
        this.sourceTable = new MyTable((Composite)parent, 68098);
        this.createTableColumns(this.sourceTable);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 3;
        layout.marginWidth = 3;
        layout.spacing = 5;
        parent.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment((Control)searchButton);
        searchText.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.right = new FormAttachment(100);
        searchButton.setLayoutData((Object)data);
        if (this.modelAhfs != null) {
            data = new FormData();
            data.top = new FormAttachment((Control)searchButton);
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(100);
            chkAddAHFS.setLayoutData((Object)data);
        } else {
            chkAddAHFS.setVisible(false);
        }
        data = new FormData();
        data.top = new FormAttachment((Control)(this.modelAhfs != null ? chkAddAHFS : searchButton));
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.height = 200;
        this.sourceTable.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.sourceTable.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        searchTip.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)searchTip);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        separator.setLayoutData((Object)data);
        if (this.isShowModelTable()) {
            data = new FormData();
            data.top = new FormAttachment((Control)separator);
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(100);
            data.height = 200;
            this.modelTable.setLayoutData((Object)data);
        }
        this.modelTable.setVisible(this.isShowModelTable());
        data = new FormData();
        data.top = new FormAttachment((Control)(this.isShowModelTable() ? this.modelTable.getControl() : searchTip));
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        lblAlias.setLayoutData((Object)data);
        lblAlias.setVisible(this.isShowAlias());
        data = new FormData();
        data.top = new FormAttachment((Control)lblAlias);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        txtAlias.setLayoutData((Object)data);
        txtAlias.setVisible(this.isShowAlias());
        searchText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (UI.CR((KeyEvent)e)) {
                    DINSearchPopupFeature.this.search(searchText.getText(), parent, (MyTable<DIN>)DINSearchPopupFeature.this.sourceTable);
                }
            }
        });
        txtAlias.addListener(24, (Listener)new SWTDelayedListener(500L, 24){

            public void handleEventOverride(Event e) {
                DINSearchPopupFeature.this.alias = txtAlias.getText();
                DINSearchPopupFeature.this.modelModified();
            }
        });
        searchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DINSearchPopupFeature.this.search(searchText.getText(), parent, (MyTable<DIN>)DINSearchPopupFeature.this.sourceTable);
            }
        });
        this.sourceTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (UI.CR((KeyEvent)e)) {
                    DINSearchPopupFeature.this.addSelectionToModel();
                }
            }
        });
        this.sourceTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                DINSearchPopupFeature.this.addSelectionToModel();
            }
        });
        this.modelTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u007f') {
                    List selection = DINSearchPopupFeature.this.modelTable.getSelection();
                    DINSearchPopupFeature.this.modelTable.remove((Collection)selection);
                    DINSearchPopupFeature.this.model.removeAll(selection);
                    if (DINSearchPopupFeature.this.modelTable.getItemCount() > 0) {
                        DINSearchPopupFeature.this.modelTable.select(0);
                    }
                    UI.autoAdjustColumnWidthToContent((Table)DINSearchPopupFeature.this.modelTable.getControl());
                    DINSearchPopupFeature.this.modelModified();
                    DINSearchPopupFeature.this.deleted(selection);
                }
            }
        });
        shell.pack();
        shell.setSize(500, shell.getSize().y);
        this.setPopupFirstFocusControl((Control)searchText);
        return shell;
    }

    protected void filterSourceTable(String text) {
        text = text.toLowerCase();
        this.sourceTable.removeAll();
        for (DIN e : this.source) {
            if (e.commercialName == null || !e.commercialName.toLowerCase().contains(text)) continue;
            this.sourceTable.add((Object)e);
        }
        UI.autoAdjustColumnWidthToContent((Table)this.sourceTable.getControl());
    }

    private void search(String text, Shell parent, MyTable<DIN> searchTable) {
        try {
            if (StringUtils.isBlank((CharSequence)text)) {
                return;
            }
            this.source = new ArrayList<DIN>();
            IRxDrugRefAccessor rxDrugRef = Application.get().getDataAccessors().getRxDrugRefAccessor();
            List dins = rxDrugRef.findDins(text.trim());
            this.fillSourceTable(dins);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "failed to search din with text " + text, e);
        }
    }

    protected void fillSourceTable(List<DIN> list) {
        if (this.getPopup() == null || this.getPopup().isDisposed()) {
            return;
        }
        this.source.clear();
        this.source.addAll(list);
        this.sourceTable.setItems(this.source);
        UI.autoAdjustColumnWidthToContent((Table)this.sourceTable.getControl());
    }

    protected void createTableColumns(MyTable<DIN> table) {
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        final ArrayList<SearchColumn> tableColumns = new ArrayList<SearchColumn>();
        SearchColumn sc = new SearchColumn<DIN>(table.getControl(), "DIN"){

            public String getText(DIN e) {
                return String.valueOf(e.din);
            }
        };
        tableColumns.add(sc);
        sc = new SearchColumn<DIN>(table.getControl(), "Nom commercial"){

            public String getText(DIN e) {
                return e.commercialName;
            }
        };
        sc.getColumn().setData("minWidth", (Object)150);
        tableColumns.add(sc);
        table.setLabelProvider((ProviderAR)new ProviderAR<DIN, String[]>(){

            public String[] get(DIN e) {
                int size = tableColumns.size();
                String[] s = new String[size];
                int i = 0;
                while (i < size) {
                    s[i] = ((SearchColumn)tableColumns.get(i)).getText((Object)e);
                    ++i;
                }
                return s;
            }
        });
        UI.autoAdjustColumnWidthToContent((Table)table.getControl());
    }

    public Set<DIN> getModel() {
        return this.model;
    }

    protected void modelModified() {
    }

    protected void deleted(List<?> selection) {
    }

    protected void added(List<?> selection) {
    }

    public String getAlias() {
        return this.alias;
    }

    protected void refreshPopup() {
    }

    public boolean isShowAlias() {
        return this.showAlias;
    }

    public void setShowAlias(boolean showAlias) {
        this.showAlias = showAlias;
    }

    public boolean isShowModelTable() {
        return this.showModelTable;
    }

    public void setShowModelTable(boolean showModelTable) {
        this.showModelTable = showModelTable;
    }

    private void addSelectionToModel() {
        if (this.addAhfsInsteadOfDin) {
            this.addAHFSselectionToModel();
        } else {
            this.addDINselectionToModel();
        }
    }

    private void addDINselectionToModel() {
        List selection = this.sourceTable.getSelection();
        boolean added = false;
        for (DIN x : selection) {
            if (!this.model.add(x)) continue;
            added = true;
            this.modelTable.add((Object)x);
        }
        if (added) {
            UI.autoAdjustColumnWidthToContent((Table)this.modelTable.getControl());
            this.modelModified();
            this.added(selection);
        }
    }

    private void addAHFSselectionToModel() {
        List<AHFS> selection = this.getAhfsFromDin(this.sourceTable.getSelection());
        boolean added = this.modelAhfs.addAll(selection);
        if (added) {
            this.modelModified();
            this.added(selection);
        }
    }

    private List<AHFS> getAhfsFromDin(List<DIN> dins) {
        ArrayList<Integer> sdins = new ArrayList<Integer>(dins.size());
        for (DIN din : dins) {
            sdins.add(din.din);
        }
        IRxDrugRefAccessor rxDrugRef = Application.get().getDataAccessors().getRxDrugRefAccessor();
        Map dinMapAhfs = rxDrugRef.getAhfsFromDins(sdins);
        HashSet allAhfs = new HashSet(dins.size() * 2);
        for (Set ahfsSet : dinMapAhfs.values()) {
            allAhfs.addAll(ahfsSet);
        }
        ArrayList<AHFS> ahfs = new ArrayList<AHFS>(allAhfs.size());
        for (String a : allAhfs) {
            ahfs.add(new AHFS(a, null));
        }
        return ahfs;
    }
}

