/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.encounter;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.modules.eform.metadata.IMetaDataType;
import ca.infodata.ofys.client.modules.eform.metadata.MetaDataFactory;
import ca.infodata.ofys.data.dataaccess.EncounterAccessorClient;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XCode;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XCodeClassification;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XDiagnostic;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XDiagnosticStatus;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.LocalDate;
import java.util.List;

public class ProblemMetaDataType
extends IMetaDataType<XDiagnostic> {
    public ProblemMetaDataType() {
        super(16);
    }

    protected XDiagnostic buildEncounterObject(Object[] args) throws MetaDataFactory.DataTransformationException {
        try {
            List li;
            ReturnObject ro;
            String diagCode = (String)args[0];
            String diagCodeType = (String)args[1];
            String note = null;
            Boolean isSolved = null;
            Double severity = null;
            Double sinceDateL = null;
            Double solvedDateL = null;
            if (args.length > 2) {
                note = (String)args[2];
            }
            if (args.length > 3) {
                isSolved = (Boolean)args[3];
            }
            if (args.length > 4) {
                severity = (Double)args[4];
            }
            if (args.length > 5) {
                sinceDateL = (Double)args[5];
            }
            if (args.length > 6) {
                solvedDateL = (Double)args[6];
            }
            XDiagnostic x = new XDiagnostic();
            x.setIsProblem(Boolean.TRUE);
            XCodeClassification xcc = null;
            XCodeClassification[] xCodeClassificationArray = XCodeClassification.values();
            int n = xCodeClassificationArray.length;
            int n2 = 0;
            while (n2 < n) {
                XCodeClassification cc = xCodeClassificationArray[n2];
                if (cc.id.equals(diagCodeType)) {
                    xcc = cc;
                    break;
                }
                ++n2;
            }
            XCode diagnosticCode = null;
            if (StringUtils.isNotBlank((String)diagCode) && xcc != null && (ro = EncounterAccessorClient.getInstance().findCodeSync(Application.get().getGlobalInstances().getSession(), diagCode, xcc.id)).getStatus().isOkToProceed() && ro.getObj() instanceof List && (li = (List)ro.getObj()).size() == 1 && li.get(0) instanceof XCode) {
                diagnosticCode = (XCode)li.get(0);
            }
            XDiagnosticStatus status = XDiagnosticStatus.NA;
            if (severity != null) {
                switch (severity.intValue()) {
                    case 0: {
                        status = XDiagnosticStatus.NA;
                        break;
                    }
                    case 1: {
                        status = XDiagnosticStatus.UNLIKELY;
                        break;
                    }
                    case 2: {
                        status = XDiagnosticStatus.POSSIBLE;
                        break;
                    }
                    case 3: {
                        status = XDiagnosticStatus.PROBABLE;
                        break;
                    }
                    case 4: {
                        status = XDiagnosticStatus.TEMPORARY;
                        break;
                    }
                    case 5: {
                        status = XDiagnosticStatus.CONFIRMED;
                    }
                }
            }
            x.setDiagnosticCode(diagnosticCode);
            x.setNote(note);
            x.setIsSolved(Boolean.valueOf(isSolved == null ? false : isSolved));
            x.setStatus(status);
            x.setSinceDate(sinceDateL == null ? null : LocalDate.fromTimeInMillisLOCAL((Long)sinceDateL.longValue()));
            x.setSolvedDate(solvedDateL == null ? null : LocalDate.fromTimeInMillisLOCAL((Long)solvedDateL.longValue()));
            x.setIsProblem(Boolean.valueOf(true));
            x.setEntryDate(LocalDate.today());
            x.setIsFromEform(Boolean.valueOf(true));
            x.setTag();
            return x;
        }
        catch (Exception e) {
            throw new MetaDataFactory.DataTransformationException("Type labo avec " + args, (Throwable)e);
        }
    }

    public IMetaDataType<XDiagnostic> getNewInstance() {
        return new ProblemMetaDataType();
    }
}

