/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.print;

import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import org.apache.log4j.Logger;
import org.nightlabs.print.AWTPrinter;
import org.nightlabs.print.DelegatingDocumentPrinter;
import org.nightlabs.print.PrinterConfiguration;
import org.nightlabs.print.PrinterConfigurationCfMod;
import org.nightlabs.print.PrinterInterface;
import org.nightlabs.print.PrinterInterfaceFactory;

public abstract class PrinterInterfaceManager {
    public static PrinterInterfaceFactory INTERFACE_FACTORY_AWT = new AWTPrinter.Factory();
    public static PrinterInterfaceFactory INTERFACE_FACTORY_DOCUMENT = new DelegatingDocumentPrinter.Factory();
    private static final Logger logger = Logger.getLogger(PrinterInterfaceManager.class);

    public PrinterInterface getConfiguredPrinterInterface(PrinterInterfaceFactory interfaceFactory, String printerUseCaseID) throws PrinterException {
        if (interfaceFactory == null) {
            throw new IllegalArgumentException("Parameter interfaceFactory can't be null!");
        }
        logger.debug((Object)"getConfiguredPrinterInterface(): Try lookup printer interface");
        PrinterConfiguration configuration = PrinterConfigurationCfMod.getPrinterConfiguration(printerUseCaseID);
        if (configuration == null || configuration != null && configuration.isAlwaysAsk()) {
            logger.debug((Object)"getConfiguredPrinterInterface(): Have configuration == null or alwaysAsk => ask for config.");
            configuration = this.editPrinterConfiguration(printerUseCaseID, configuration == null);
        }
        logger.debug((Object)"getConfiguredPrinterInterface(): Have configuration");
        PrinterInterface printerInterface = interfaceFactory.createPrinterInterface();
        logger.debug((Object)("getConfiguredPrinterInterface(): Created printerInterface " + printerInterface.getClass().getSimpleName()));
        if (configuration != null) {
            printerInterface.configure(configuration);
        }
        return printerInterface;
    }

    public PrinterInterface getSytemDefaultPrinterInterface(PrinterInterfaceFactory interfaceFactory) throws PrinterException {
        logger.debug((Object)"Looking up system default printer interface");
        PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
        if (printService == null) {
            return null;
        }
        PrinterInterface printerInterface = interfaceFactory.createPrinterInterface();
        PrinterConfiguration configuration = new PrinterConfiguration();
        configuration.setPrintServiceName(printService.getName());
        printerInterface.configure(configuration);
        logger.debug((Object)("Returning system default printer interface " + printerInterface.getConfiguration().getPrintServiceName()));
        return printerInterface;
    }

    public abstract PrinterConfiguration editPrinterConfiguration(String var1, boolean var2);

    public PrinterInterface getUserSelectedPrinterInterface(PrinterInterfaceFactory interfaceFactory) throws PrinterException {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (printerJob.printDialog()) {
            PrinterInterface printerInterface = interfaceFactory.createPrinterInterface();
            PrinterConfiguration configuration = new PrinterConfiguration();
            configuration.setPrintServiceName(printerJob.getPrintService().getName());
            printerInterface.configure(configuration);
            return printerInterface;
        }
        return null;
    }
}

