/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.library.log;

import ca.infodata.logserver.data.Log;
import ca.infodata.ofys.ui.library.LibPlugin;
import ca.infodata.ofys.ui.library.Util;
import ca.infodata.ofys.ui.library.log.LogContextProvider;
import ca.infodata.ofys.ui.library.log.RsAccessor;
import ca.infodata.util1.ConcurrentHashSet;
import ca.infodata.util1.StringUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.eclipse.core.runtime.Platform;

public class MedoStatsLogHandler
extends Handler {
    private static final Logger logger = Logger.getLogger(MedoStatsLogHandler.class.getName());
    private static final int medoLogApplicationId = 2;
    private static final String medoLogApplicationPassword = "infodata";
    private static final int medoLogApplicationProvider = 1;
    private ConcurrentSkipListMap<Integer, LogRecord> buffer;
    private AtomicInteger i;
    private String medoStatsServerUrl;
    private Formatter failsafeFormatter;
    private boolean doLog = false;
    private Timer flushTimer;
    private TimerTask flushTask;
    private boolean isClosed;
    private RsAccessor accessor;
    private List<LogContextProvider> logContextProviders;

    public MedoStatsLogHandler(String medoStatsServerUrl) {
        this.medoStatsServerUrl = medoStatsServerUrl;
        if (medoStatsServerUrl == null) {
            throw new NullPointerException("medoStatsServerUrl");
        }
        String contextRoot = "/ca.infodata.logserver/jaxrs/log";
        try {
            this.accessor = new RsAccessor(new URL(medoStatsServerUrl), contextRoot);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        this.logContextProviders = new ArrayList<LogContextProvider>();
        this.buffer = new ConcurrentSkipListMap();
        this.i = new AtomicInteger(0);
        this.isClosed = false;
        this.failsafeFormatter = new SimpleFormatter();
        this.flushTask = new TimerTask(){

            @Override
            public void run() {
                Thread.currentThread().setPriority(1);
                MedoStatsLogHandler.this.flush();
            }
        };
        this.flushTimer = new Timer("MedoStatsFlushTimer");
        this.flushTimer.schedule(this.flushTask, 0L, TimeUnit.SECONDS.toMillis(10L));
    }

    @Override
    public void close() throws SecurityException {
        this.buffer.clear();
        this.i = null;
        this.medoStatsServerUrl = null;
        this.isClosed = true;
    }

    @Override
    public void flush() {
        try {
            this.doLog = false;
            this.sendLogsToWebService();
        }
        catch (Exception exception) {}
        this.doLog = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void publish(LogRecord record) {
        if (!Platform.inDebugMode() && this.isLoggable(record)) {
            if (record.getLevel() == Level.WARNING || record.getLevel() == Level.SEVERE) {
                try {
                    void var6_12;
                    Object[] parameters = record.getParameters();
                    if (parameters == null) {
                        parameters = new Object[]{};
                    }
                    ArrayList<String> contextElements = new ArrayList<String>(this.logContextProviders.size());
                    for (LogContextProvider p : this.logContextProviders) {
                        try {
                            String string = p.getContextElement();
                            if (!StringUtils.isNotBlank((String)string)) continue;
                            contextElements.add(string);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    Object[] parameters2 = new Object[parameters.length + contextElements.size()];
                    int i = 0;
                    boolean bl = false;
                    while (var6_12 < parameters.length) {
                        parameters2[i] = parameters[var6_12];
                        ++i;
                        ++var6_12;
                    }
                    for (Object e : contextElements) {
                        parameters2[i] = e;
                        ++i;
                    }
                    record.setParameters(parameters2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.buffer.put(this.i.addAndGet(1), record);
        }
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        if (this.isClosed || !this.doLog || record == null) {
            return false;
        }
        String loggerName = record.getLoggerName();
        if (logger.getName().equals(loggerName)) {
            return false;
        }
        if (record.getMessage().contains("[C4003]") && record.getLevel().equals(Level.WARNING)) {
            return false;
        }
        if (record.getMessage().contains("[I500]") && record.getLevel().equals(Level.WARNING)) {
            return false;
        }
        return super.isLoggable(record);
    }

    private void sendLogsToWebService() {
        int i2 = this.i.get();
        int maxSend = 20;
        int i = 0;
        ArrayList<Log> lstLogs = new ArrayList<Log>();
        Iterator<Map.Entry<Integer, LogRecord>> iterator = this.buffer.entrySet().iterator();
        ConcurrentHashSet allKeys = new ConcurrentHashSet();
        ConcurrentHashSet keys = new ConcurrentHashSet();
        while (iterator.hasNext()) {
            Map.Entry<Integer, LogRecord> e2 = iterator.next();
            Map.Entry<Integer, LogRecord> log = e2.getValue();
            int key = e2.getKey();
            if (((LogRecord)((Object)log)).getLevel().intValue() < Level.WARNING.intValue()) {
                allKeys.add((Object)key);
                continue;
            }
            this.setInLogAndAddToList(lstLogs, (ConcurrentHashSet<Integer>)keys, (LogRecord)((Object)log), key);
            if (i++ <= maxSend) continue;
            this.sendLogs(lstLogs, (ConcurrentHashSet<Integer>)allKeys, (ConcurrentHashSet<Integer>)keys);
            i = 0;
        }
        if (i > 0) {
            this.sendLogs(lstLogs, (ConcurrentHashSet<Integer>)allKeys, (ConcurrentHashSet<Integer>)keys);
        }
        for (Integer ii : allKeys) {
            this.buffer.remove(ii);
        }
        boolean allBelowWarning = true;
        for (Map.Entry<Integer, LogRecord> log : this.buffer.entrySet()) {
            if (log.getValue().getLevel().intValue() < Level.WARNING.intValue()) continue;
            allBelowWarning = false;
            break;
        }
        if (allBelowWarning && this.buffer.size() > 50) {
            SortedMap toRemove = this.buffer.headMap((Object)(i2 - 25));
            toRemove.clear();
        }
    }

    private void sendLogs(ArrayList<Log> lstLogs, ConcurrentHashSet<Integer> allKeys, ConcurrentHashSet<Integer> keys) {
        try {
            Boolean result = this.accessor.putLog(lstLogs, medoLogApplicationPassword, 1);
            if (Boolean.TRUE.equals(result)) {
                allKeys.addAll(keys);
                lstLogs.clear();
                keys.clear();
            } else {
                logger.log(Level.WARNING, "Failed to send log MedoStats server (" + this.medoStatsServerUrl + ")");
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to send log MedoStats server (" + this.medoStatsServerUrl + ")", e);
        }
    }

    private void setInLogAndAddToList(ArrayList<Log> lstLogs, ConcurrentHashSet<Integer> keys, LogRecord log, int key) {
        try {
            int logId = Long.valueOf(log.getSequenceNumber()).intValue();
            Log mlog = new Log();
            mlog.setApplication(Integer.valueOf(2));
            mlog.setLevel(Integer.valueOf(log.getLevel().intValue()));
            mlog.setIp(Util.getIp());
            mlog.setDate(Long.valueOf(log.getMillis()));
            mlog.setHostname("unknow host");
            mlog.setUsername(LibPlugin.getUserName() == null ? System.getProperty("user.name") : LibPlugin.getUserName());
            mlog.setClient(LibPlugin.getCodeClient() == null ? "unknown clientcode" : LibPlugin.getCodeClient());
            mlog.setVersion(LibPlugin.getVersion());
            String text = "OFYS Log no : " + logId + "\n\n" + this.getFormatter().format(log);
            StringBuilder builder = new StringBuilder(1000);
            builder.append("\nBEFORE");
            int j = 0;
            for (LogRecord log2 : this.buffer.headMap((Object)key).values()) {
                if (log2.getLevel().intValue() < Level.WARNING.intValue()) {
                    builder.append("\n");
                    builder.append(log2.getMessage());
                    ++j;
                }
                if (j >= 20) break;
            }
            builder.append("\nAFTER");
            j = 0;
            for (LogRecord log2 : this.buffer.tailMap((Object)key).values()) {
                if (log2.getLevel().intValue() < Level.WARNING.intValue()) {
                    builder.append("\n");
                    builder.append(log2.getMessage());
                    ++j;
                }
                if (j >= 20) break;
            }
            text = String.valueOf(text) + builder.toString();
            mlog.setText(text);
            keys.add((Object)key);
            lstLogs.add(mlog);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to convert logRecord to MedoLog : \n" + this.failsafeFormatter.format(log), e);
        }
    }

    public void registerLogContextProvider(LogContextProvider provider) {
        if (provider == null) {
            throw new NullPointerException("provider");
        }
        if (!this.logContextProviders.contains(provider)) {
            this.logContextProviders.add(provider);
        }
    }

    public void unregisterLogContextProvider(LogContextProvider provider) {
        if (provider == null) {
            throw new NullPointerException("provider");
        }
        this.logContextProviders.remove(provider);
    }
}

