/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.library.log;

import ca.infodata.ofys.ui.library.log.LogContextProvider;
import ca.infodata.util1.Pair;
import ca.infodata.util1.StringUtils;
import java.util.ArrayDeque;
import java.util.Date;
import org.apache.commons.lang3.time.FastDateFormat;

public class LastOperationLogList
implements LogContextProvider {
    private final ArrayDeque<Pair<Long, String>> list;
    private final FastDateFormat sdf = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");

    protected LastOperationLogList() {
        this.list = new ArrayDeque(100);
    }

    public void add(String operation) {
        if (StringUtils.isBlank((CharSequence)operation)) {
            return;
        }
        if (this.list.size() >= 100) {
            this.list.pollLast();
        }
        this.list.offerFirst((Pair<Long, String>)Pair.newPair((Object)System.currentTimeMillis(), (Object)operation));
    }

    @Override
    public String getContextElement() {
        StringBuilder b = new StringBuilder();
        b.ensureCapacity(this.list.size() * 50);
        b.append("Last100OperationLogs");
        for (Pair<Long, String> e : this.list) {
            b.append("\n");
            b.append(this.sdf.format(new Date((Long)e.first))).append(" : ").append((String)e.second);
        }
        return b.toString();
    }
}

