/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.library;

import ca.infodata.ofys.ui.library.LibPlugin;
import ca.infodata.ofys.ui.library.RemoteDesktopRegStateListener;
import ca.infodata.ofys.util.MiscUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mb.listeners.GenListenerManager;

public class RemoteDesktopRegStateMonitor
implements Runnable {
    private static final Logger logger = Logger.getLogger(RemoteDesktopRegStateMonitor.class.getName());
    private static final String REGQUERY_UTIL = "reg query ";
    private static final String REGSTR_TOKEN = "REG_SZ";
    private static final String CLIENTNAME_CMD = "reg query \"HKEY_CURRENT_USER\\Volatile Environment\" /s /v CLIENTNAME";
    private static final String SESSIONNAME_CMD = "reg query \"HKEY_CURRENT_USER\\Volatile Environment\" /s /v SESSIONNAME";
    protected volatile String clientNameCache;
    protected volatile String sessionNameCache;
    protected volatile boolean isRDPSessionCache;
    protected volatile boolean doMonitor;
    private Thread thread;
    private final long refreshInterval;
    private final TimeUnit timeUnit;
    private GenListenerManager<RemoteDesktopRegStateListener> listeners;
    private RemoteDesktopRegStateListener proxy;

    public RemoteDesktopRegStateMonitor(long refreshInterval, TimeUnit timeUnit) {
        this.refreshInterval = refreshInterval;
        this.timeUnit = timeUnit;
        this.listeners = new GenListenerManager(RemoteDesktopRegStateListener.class);
        this.proxy = (RemoteDesktopRegStateListener)this.listeners.getProxy();
        if (LibPlugin.ON_WIN) {
            this.doMonitor = true;
            this.thread = new Thread(this);
            this.thread.setDaemon(true);
            this.thread.setName("RemoteDesktopRegStateMonitor");
            this.thread.start();
            logger.info("RDP monitoring ENABLED");
        } else {
            logger.info("RDP monitoring DISABLED because OS is not windows.");
        }
    }

    public void addListener(RemoteDesktopRegStateListener listener) {
        this.listeners.addListener((Object)listener);
    }

    public boolean isRdpSession() {
        return this.isRDPSessionCache;
    }

    public String getClientName() {
        return this.clientNameCache;
    }

    public String getSessionName() {
        return this.sessionNameCache;
    }

    @Override
    public void run() {
        while (this.doMonitor) {
            try {
                this.timeUnit.sleep(this.refreshInterval);
                String clientName1 = this.clientNameCache;
                String sessionName1 = this.sessionNameCache;
                boolean isRDPSession1 = this.isRDPSessionCache;
                String clientName2 = this.queryClientName();
                String sessionName2 = this.querySessionName();
                boolean isRDPSession2 = RemoteDesktopRegStateMonitor.isRDPSession(sessionName2);
                this.clientNameCache = clientName2;
                this.sessionNameCache = sessionName2;
                this.isRDPSessionCache = isRDPSession2;
                if (isRDPSession1 == isRDPSession2 && MiscUtil.areObjectsEquals((Object)clientName1, (Object)clientName2) && MiscUtil.areObjectsEquals((Object)sessionName1, (Object)sessionName2)) continue;
                this.proxy.regStateModified(this.clientNameCache, this.isRDPSessionCache);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception while monitoring clientName and sessionName reg variables", e);
            }
        }
    }

    private static boolean isRDPSession(String sessionName) {
        return sessionName != null && sessionName.toUpperCase().contains("RDP");
    }

    private String queryClientName() {
        return this.getRegSzKeyValue(CLIENTNAME_CMD);
    }

    private String querySessionName() {
        return this.getRegSzKeyValue(SESSIONNAME_CMD);
    }

    private String getRegSzKeyValue(String keypath) {
        try {
            Process process = Runtime.getRuntime().exec(keypath);
            StreamReader reader = new StreamReader(process.getInputStream());
            reader.start();
            process.waitFor();
            reader.join();
            String result = reader.getResult();
            String[] split = result.split("[\\s\\r\\n]+");
            String value = null;
            int i = 0;
            while (i < split.length) {
                if (split[i].equals(REGSTR_TOKEN) && i < split.length) {
                    value = split[i + 1];
                    break;
                }
                ++i;
            }
            return value;
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().contains("CreateProcess error=5")) {
                this.doMonitor = false;
                logger.log(Level.INFO, "Failed to query reg with keypath " + keypath, e);
            } else {
                logger.log(Level.WARNING, "Failed to query reg with keypath " + keypath, e);
            }
            return null;
        }
    }

    public void dispose() {
        this.listeners.clear();
        this.doMonitor = false;
    }

    public static void main(String[] s) {
    }

    static class StreamReader
    extends Thread {
        private InputStream is;
        private StringWriter sw;

        StreamReader(InputStream is) {
            this.is = is;
            this.sw = new StringWriter();
        }

        @Override
        public void run() {
            try {
                int c;
                while ((c = this.is.read()) != -1) {
                    this.sw.write(c);
                }
            }
            catch (IOException iOException) {}
        }

        String getResult() {
            return this.sw.toString();
        }
    }
}

