/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.laboresults.patient.search;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.LaboResultsAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XCompletionProposalType;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XBaseLaboResultsProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XLaboResultsProfessionnalQuery;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XLaboResultsProfessionnalStatus;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.FontAwareSection;
import ca.infodata.ofys.ui.controls.IControl;
import ca.infodata.ofys.ui.controls.MyMaskedText;
import ca.infodata.ofys.ui.controls.calendarcombo.MyCalendarText;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.form.combo.MyCombo;
import ca.infodata.ofys.ui.controls.plugins.searchview.BaseSearchComposite;
import ca.infodata.ofys.ui.controls.plugins.searchview.EnumWithValueAdapter;
import ca.infodata.ofys.ui.controls.plugins.searchview.ErrorWhileSearchingException;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchColumnChoiceElement;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchControlAdapter;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchItem;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.laboresults.editor.LaboResultsEditor;
import ca.infodata.ofys.ui.person.professionnal.ProfessionalBySiteCombo;
import ca.infodata.ofys.ui.person.professionnal.ProfessionalBySiteComboASearchAdapter;
import ca.infodata.util1.RangeNotation;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDateRange;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class LaboResultsSearchComposite
extends BaseSearchComposite {
    private static final Logger logger = Logger.getLogger(LaboResultsSearchComposite.class.getName());
    private MyLabel lblName;
    private MyMaskedText txtName;
    private MyLabel lblSeenStatus;
    private MyCombo<XLaboResultsProfessionnalStatus> cmbSeenStatus;
    private MyLabel lblServiceDate;
    private MyLabel lblServiceDateSeparator;
    private MyCalendarText txtServiceDateFrom;
    private MyCalendarText txtServiceDateTo;
    private MyLabel lblRequestDate;
    private MyLabel lblRequestDateSeparator;
    private MyCalendarText txtRequestDateFrom;
    private MyCalendarText txtRequestDateTo;
    private MyLabel lblSeenDate;
    private MyLabel lblSeenDateSeparator;
    private MyCalendarText txtSeenDateFrom;
    private MyCalendarText txtSeenDateTo;
    private MyLabel lblSignedDate;
    private MyLabel lblSignedDateSeparator;
    private MyCalendarText txtSignedDateFrom;
    private MyCalendarText txtSignedDateTo;
    private MyLabel lblProfessionnal;
    private ProfessionalBySiteCombo cmbProfessionnal;

    public LaboResultsSearchComposite(Composite parent, FormToolkit toolkit, int style) {
        super(parent, toolkit, style);
    }

    public void setFocus() {
        this.setVisible(true);
        this.txtName.setFocus();
    }

    public void createMyPartControl(Composite theParent, FormToolkit toolkit, int style) {
        this.isWithTemplateTool = true;
        this.templateType = XCompletionProposalType.SCAN_SEARCH;
        super.createMyPartControl(theParent, toolkit, style);
    }

    protected void createMyControl(Composite parent, FormToolkit toolkit) {
        this.setViewSelectInactive();
        this.setIsWithButtonNew(false);
        FontAwareSection section = new FontAwareSection(parent, 2114, toolkit);
        toolkit.createCompositeSeparator((Composite)section);
        section.setText(Messages.getString((String)"CRITERES", (String[])new String[0]));
        Composite sectionComposite = toolkit.createComposite((Composite)section);
        section.setClient((Control)sectionComposite);
        FormLayout layout = new FormLayout();
        layout.marginBottom = 5;
        layout.marginHeight = 5;
        layout.spacing = 5;
        parent.setLayout((Layout)layout);
        FormData data = new FormData();
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.top = new FormAttachment(0);
        section.setLayoutData((Object)data);
        parent = sectionComposite;
        layout = new FormLayout();
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        layout.spacing = 5;
        parent.setLayout((Layout)layout);
        this.lblServiceDate = new MyLabel(parent, String.valueOf(Messages.getString((String)"DATE", (String[])new String[0])) + " " + Messages.getString((String)"DE_SERVICE", (String[])new String[0]) + " " + Messages.getString((String)"DEBUT", (String[])new String[0]) + " / " + Messages.getString((String)"FIN", (String[])new String[0]), 16384, toolkit);
        this.lblServiceDateSeparator = new MyLabel(parent, " - ", 0x1000000, toolkit);
        this.txtServiceDateFrom = new MyCalendarText(parent, 0, toolkit, true);
        this.txtServiceDateFrom.getTextControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (LaboResultsSearchComposite.this.txtServiceDateTo.getDate() != null && LaboResultsSearchComposite.this.txtServiceDateFrom.getDate() != null && LaboResultsSearchComposite.this.txtServiceDateTo.getDate().before((IPartialDate)LaboResultsSearchComposite.this.txtServiceDateFrom.getDate())) {
                    LaboResultsSearchComposite.this.txtServiceDateTo.setDate((IPartialDate)LaboResultsSearchComposite.this.txtServiceDateFrom.getDate());
                }
            }
        });
        this.addSearchControl("txtServiceDateFrom", (IControl)this.txtServiceDateFrom);
        this.txtServiceDateTo = new MyCalendarText(parent, 0, toolkit, true);
        this.txtServiceDateTo.getTextControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (LaboResultsSearchComposite.this.txtServiceDateTo.getDate() != null && LaboResultsSearchComposite.this.txtServiceDateFrom.getDate() != null && LaboResultsSearchComposite.this.txtServiceDateTo.getDate().before((IPartialDate)LaboResultsSearchComposite.this.txtServiceDateFrom.getDate())) {
                    LaboResultsSearchComposite.this.txtServiceDateFrom.setDate((IPartialDate)LaboResultsSearchComposite.this.txtServiceDateTo.getDate());
                }
            }
        });
        this.addSearchControl("txtServiceDateTo", (IControl)this.txtServiceDateTo);
        this.lblRequestDate = new MyLabel(parent, String.valueOf(Messages.getString((String)"DATE", (String[])new String[0])) + " " + Messages.getString((String)"DE_LA_DEMANDE", (String[])new String[0]) + " " + Messages.getString((String)"DEBUT", (String[])new String[0]) + " / " + Messages.getString((String)"FIN", (String[])new String[0]), 16384, toolkit);
        this.lblRequestDateSeparator = new MyLabel(parent, " - ", 0x1000000, toolkit);
        this.txtRequestDateFrom = new MyCalendarText(parent, 0, toolkit, true);
        this.txtRequestDateFrom.getTextControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (LaboResultsSearchComposite.this.txtRequestDateTo.getDate() != null && LaboResultsSearchComposite.this.txtRequestDateFrom.getDate() != null && LaboResultsSearchComposite.this.txtRequestDateTo.getDate().before((IPartialDate)LaboResultsSearchComposite.this.txtRequestDateFrom.getDate())) {
                    LaboResultsSearchComposite.this.txtRequestDateTo.setDate((IPartialDate)LaboResultsSearchComposite.this.txtRequestDateFrom.getDate());
                }
            }
        });
        this.addSearchControl("txtRequestDateFrom", (IControl)this.txtRequestDateFrom);
        this.txtRequestDateTo = new MyCalendarText(parent, 0, toolkit, true);
        this.txtRequestDateTo.getTextControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (LaboResultsSearchComposite.this.txtRequestDateTo.getDate() != null && LaboResultsSearchComposite.this.txtRequestDateFrom.getDate() != null && LaboResultsSearchComposite.this.txtRequestDateTo.getDate().before((IPartialDate)LaboResultsSearchComposite.this.txtRequestDateFrom.getDate())) {
                    LaboResultsSearchComposite.this.txtRequestDateFrom.setDate((IPartialDate)LaboResultsSearchComposite.this.txtRequestDateTo.getDate());
                }
            }
        });
        this.addSearchControl("txtRequestDateTo", (IControl)this.txtRequestDateTo);
        this.lblSeenDate = new MyLabel(parent, String.valueOf(Messages.getString((String)"DATE", (String[])new String[0])) + " " + Messages.getString((String)"VU", (String[])new String[0]) + " " + Messages.getString((String)"DEBUT", (String[])new String[0]) + " / " + Messages.getString((String)"FIN", (String[])new String[0]), 16384, toolkit);
        this.lblSeenDateSeparator = new MyLabel(parent, " - ", 0x1000000, toolkit);
        this.txtSeenDateFrom = new MyCalendarText(parent, 0, toolkit, true);
        this.txtSeenDateFrom.getTextControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (LaboResultsSearchComposite.this.txtSeenDateTo.getDate() != null && LaboResultsSearchComposite.this.txtSeenDateFrom.getDate() != null && LaboResultsSearchComposite.this.txtSeenDateTo.getDate().before((IPartialDate)LaboResultsSearchComposite.this.txtSeenDateFrom.getDate())) {
                    LaboResultsSearchComposite.this.txtSeenDateTo.setDate((IPartialDate)LaboResultsSearchComposite.this.txtSeenDateFrom.getDate());
                }
            }
        });
        this.addSearchControl("txtSeenDateFrom", (IControl)this.txtSeenDateFrom);
        this.txtSeenDateTo = new MyCalendarText(parent, 0, toolkit, true);
        this.txtSeenDateTo.getTextControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (LaboResultsSearchComposite.this.txtSeenDateTo.getDate() != null && LaboResultsSearchComposite.this.txtSeenDateFrom.getDate() != null && LaboResultsSearchComposite.this.txtSeenDateTo.getDate().before((IPartialDate)LaboResultsSearchComposite.this.txtSeenDateFrom.getDate())) {
                    LaboResultsSearchComposite.this.txtSeenDateFrom.setDate((IPartialDate)LaboResultsSearchComposite.this.txtSeenDateTo.getDate());
                }
            }
        });
        this.addSearchControl("txtSeenDateTo", (IControl)this.txtSeenDateTo);
        this.lblSignedDate = new MyLabel(parent, String.valueOf(Messages.getString((String)"DATE", (String[])new String[0])) + " " + Messages.getString((String)"SIGNE", (String[])new String[0]) + " " + Messages.getString((String)"DEBUT", (String[])new String[0]) + " / " + Messages.getString((String)"FIN", (String[])new String[0]), 16384, toolkit);
        this.lblSignedDateSeparator = new MyLabel(parent, " - ", 0x1000000, toolkit);
        this.txtSignedDateFrom = new MyCalendarText(parent, 0, toolkit, true);
        this.txtSignedDateFrom.getTextControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (LaboResultsSearchComposite.this.txtSignedDateTo.getDate() != null && LaboResultsSearchComposite.this.txtSignedDateFrom.getDate() != null && LaboResultsSearchComposite.this.txtSignedDateTo.getDate().before((IPartialDate)LaboResultsSearchComposite.this.txtSignedDateFrom.getDate())) {
                    LaboResultsSearchComposite.this.txtSignedDateTo.setDate((IPartialDate)LaboResultsSearchComposite.this.txtSignedDateFrom.getDate());
                }
            }
        });
        this.addSearchControl("txtSignedDateFrom", (IControl)this.txtSignedDateFrom);
        this.txtSignedDateTo = new MyCalendarText(parent, 0, toolkit, true);
        this.txtSignedDateTo.getTextControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (LaboResultsSearchComposite.this.txtSignedDateTo.getDate() != null && LaboResultsSearchComposite.this.txtSignedDateFrom.getDate() != null && LaboResultsSearchComposite.this.txtSignedDateTo.getDate().before((IPartialDate)LaboResultsSearchComposite.this.txtSignedDateFrom.getDate())) {
                    LaboResultsSearchComposite.this.txtSignedDateFrom.setDate((IPartialDate)LaboResultsSearchComposite.this.txtSignedDateTo.getDate());
                }
            }
        });
        this.addSearchControl("txtSignedDateTo", (IControl)this.txtSignedDateTo);
        this.lblName = new MyLabel(parent, Messages.getString((String)"NOM_DU_TEST", (String[])new String[0]), 16384, toolkit);
        this.txtName = new MyMaskedText(parent, 4, toolkit);
        this.addSearchControl("txtName", (IControl)this.txtName);
        this.lblSeenStatus = new MyLabel(parent, Messages.getString((String)"ETAT", (String[])new String[0]), 16384, toolkit);
        this.cmbSeenStatus = new MyCombo(parent, 8, toolkit);
        this.cmbSeenStatus.setItemsWithNull((Object[])XLaboResultsProfessionnalStatus.values());
        this.addSearchControl("cmbSeenStatus", (IControl)this.cmbSeenStatus, (SearchControlAdapter)new EnumWithValueAdapter(XLaboResultsProfessionnalStatus.class));
        this.lblProfessionnal = new MyLabel(parent, Messages.getString((String)"PROFESSIONNEL", (String[])new String[0]), 16384, toolkit);
        this.cmbProfessionnal = new ProfessionalBySiteCombo(parent, 65544, toolkit);
        this.cmbProfessionnal.fill();
        this.addSearchControl("cmbProfessionnal", (IControl)this.cmbProfessionnal, (SearchControlAdapter)new ProfessionalBySiteComboASearchAdapter(this.cmbProfessionnal));
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        this.lblServiceDate.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblServiceDate.getControl());
        data.left = new FormAttachment(0);
        this.txtServiceDateFrom.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblServiceDate.getControl());
        data.left = new FormAttachment((Control)this.txtServiceDateFrom);
        this.lblServiceDateSeparator.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblServiceDate.getControl());
        data.left = new FormAttachment(this.lblServiceDateSeparator.getControl());
        this.txtServiceDateTo.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.txtServiceDateTo);
        data.left = new FormAttachment(0);
        this.lblRequestDate.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblRequestDate.getControl());
        data.left = new FormAttachment(0);
        this.txtRequestDateFrom.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblRequestDate.getControl());
        data.left = new FormAttachment((Control)this.txtRequestDateFrom);
        this.lblRequestDateSeparator.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblRequestDate.getControl());
        data.left = new FormAttachment(this.lblRequestDateSeparator.getControl());
        this.txtRequestDateTo.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.txtRequestDateFrom);
        data.left = new FormAttachment(0);
        this.lblSeenDate.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblSeenDate.getControl());
        data.left = new FormAttachment(0);
        this.txtSeenDateFrom.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblSeenDate.getControl());
        data.left = new FormAttachment((Control)this.txtSeenDateFrom);
        this.lblSeenDateSeparator.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblSeenDate.getControl());
        data.left = new FormAttachment(this.lblSeenDateSeparator.getControl());
        this.txtSeenDateTo.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.txtSeenDateTo);
        data.left = new FormAttachment(0);
        this.lblSignedDate.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblSignedDate.getControl());
        data.left = new FormAttachment(0);
        this.txtSignedDateFrom.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblSignedDate.getControl());
        data.left = new FormAttachment((Control)this.txtSignedDateFrom);
        this.lblSignedDateSeparator.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblSignedDate.getControl());
        data.left = new FormAttachment(this.lblSignedDateSeparator.getControl());
        this.txtSignedDateTo.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtSignedDateFrom.getControl());
        data.left = new FormAttachment(0);
        this.lblName.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblName.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(48);
        this.txtName.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtSignedDateFrom.getControl());
        data.left = new FormAttachment(52);
        data.right = new FormAttachment(100);
        this.lblSeenStatus.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblSeenStatus.getControl());
        data.left = new FormAttachment(52);
        data.right = new FormAttachment(100);
        this.cmbSeenStatus.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(this.txtName.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.lblProfessionnal.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblProfessionnal.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.cmbProfessionnal.setLayoutData(data);
    }

    protected void search() throws ErrorWhileSearchingException {
        block6: {
            XLaboResultsProfessionnalQuery container = new XLaboResultsProfessionnalQuery();
            if (this.cmbSeenStatus.getSelection() != null) {
                container.setStatus((XLaboResultsProfessionnalStatus)this.cmbSeenStatus.getSelection());
            }
            if (this.cmbProfessionnal.getSelection() != null) {
                container.setIdProfessionnal(this.cmbProfessionnal.getSelection().getId());
            }
            container.setDateRangeService(new LocalDateRange(this.txtServiceDateFrom.getDate(), this.txtServiceDateTo.getDate(), RangeNotation.CLOSED));
            container.setDateRangeRequest(new LocalDateRange(this.txtRequestDateFrom.getDate(), this.txtRequestDateTo.getDate(), RangeNotation.CLOSED));
            container.setDateRangeSeen(new LocalDateRange(this.txtSeenDateFrom.getDate(), this.txtSeenDateTo.getDate(), RangeNotation.CLOSED));
            container.setDateRangeSigned(new LocalDateRange(this.txtSignedDateFrom.getDate(), this.txtSignedDateTo.getDate(), RangeNotation.CLOSED));
            container.setName(this.txtName.getText());
            JobCallback callback = null;
            try {
                callback = new JobCallback(Messages.getString((String)"RECHERCHE", (String[])new String[0]), (IStatusHandler)DefaultStatusHandler.getInstance()){

                    public void responseReceived(ReturnObject response) {
                        LaboResultsSearchComposite.this.searchResponse((List)response.getObj());
                    }

                    public void exception(Exception e) {
                        super.exception(e);
                        LaboResultsSearchComposite.this.searchResponse(null);
                    }
                };
                LaboResultsAccessorClient.getInstance().findLaboResultsProfessionnal(Application.get().getGlobalInstances().getSession(), (ICallback)callback, container);
            }
            catch (CannotConnectToServerException e) {
                MessageUtil.cannotConnectToServerExceptionMsg();
                if (callback != null && !callback.killed()) {
                    callback.kill();
                }
                throw new ErrorWhileSearchingException((Exception)((Object)e));
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
                if (callback == null || callback.killed()) break block6;
                callback.kill();
            }
        }
    }

    private void searchResponse(final List<XBaseLaboResultsProfessionnal> list) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!LaboResultsSearchComposite.this.parent.isDisposed()) {
                        SearchItem[] items = new SearchItem[list == null ? 0 : list.size()];
                        int i = 0;
                        while (i < items.length) {
                            XBaseLaboResultsProfessionnal image = (XBaseLaboResultsProfessionnal)list.get(i);
                            items[i] = new SearchItem((Object)image, image.getStr());
                            ++i;
                        }
                        if (Application.get().getGlobalInstances().getSession().getClientPreferences().getReturnListLength() * 4 < i) {
                            LaboResultsSearchComposite.this.setMessage(MSG_TROP_DONNEES);
                        } else if (i == 0) {
                            LaboResultsSearchComposite.this.setMessage(MSG_AUCUNES_DONNEES);
                            LaboResultsSearchComposite.this.txtName.setFocus();
                        } else {
                            LaboResultsSearchComposite.this.setMessage(null);
                        }
                        LaboResultsSearchComposite.this.loadSearchListInTable(items);
                        LaboResultsSearchComposite.this.callbackContainerReferenceControlFromTableItems();
                    }
                }
                catch (RuntimeException e) {
                    logger.log(Level.SEVERE, "Erreur", e);
                }
            }
        });
    }

    protected void processSelection(SearchItem item) {
        XBaseLaboResultsProfessionnal x;
        EditorInput input;
        IEditorPart editor;
        if (item != null && (editor = BaseEditor.openEditorSafe((IEditorInput)(input = new EditorInput((IDataObject)(x = (XBaseLaboResultsProfessionnal)item.getData()).clone())), (String)LaboResultsEditor.class.getName())) != null && !x.getStatus().contains(XLaboResultsProfessionnalStatus.TO_RESOLVE) && !x.getStatus().contains(XLaboResultsProfessionnalStatus.SEEN)) {
            x.addXLaboResultsProfessionnalStatus(XLaboResultsProfessionnalStatus.SEEN);
        }
    }

    protected void showContextMenu(Control parent) {
    }

    public void reset() {
        super.reset();
        this.txtRequestDateFrom.setDate(null);
        this.txtRequestDateTo.setDate(null);
        this.txtSeenDateFrom.setDate(null);
        this.txtSeenDateTo.setDate(null);
        this.txtSignedDateFrom.setDate(null);
        this.txtSignedDateTo.setDate(null);
        this.txtName.clear();
        this.cmbSeenStatus.selectNone();
        this.cmbProfessionnal.selectNone();
    }

    protected void createNew() {
        throw new UnsupportedOperationException();
    }

    public void setProfessionnal(XBaseProfessionnal professionnal) {
        if (professionnal == null) {
            this.cmbProfessionnal.selectNone();
        } else {
            this.cmbProfessionnal.select(professionnal);
        }
    }

    protected SearchColumnChoiceElement[] getSearchColumnChoiceElements() {
        return null;
    }

    protected String getPreferencesKeys() {
        return null;
    }
}

