/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.laboresults.handler;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.LaboResultsAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.XBasePatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XBaseLaboResultsProfessionnal;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.form.IReferenceControl;
import ca.infodata.ofys.ui.controls.plugins.searchview.BaseSearchView;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.laboresults.Messages;
import ca.infodata.ofys.ui.laboresults.editor.LaboResultsEditor;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.person.patient.PatientUtil;
import ca.infodata.ofys.ui.person.search.PatientSearchView;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class ReassignLaboPatientHandler
extends AbstractHandler {
    private static final Logger logger = Logger.getLogger(ReassignLaboPatientHandler.class.getName());
    private static final String VEUILLEZ_CONFIRMER_LE_CHANGEMENT_DE_PATIENT_POUR_CE_RESULTAT = Messages.getString("VEUILLEZ_CONFIRMER_LE_CHANGEMENT_DE_PATIENT_POUR_CE_RESULTAT");
    public static final String ASSIGNER_CE_RESULTAT_A_UN_AUTRE_PATIENT_CE_RESULTAT_A_ETE_ASSIGNE_PAR_ERREUR_A = Messages.getString("ASSIGNER_CE_RESULTAT_A_UN_AUTRE_PATIENT_(_CE_RESULTAT_A_ETE_ASSIGNE_PAR_ERREUR_A_?)");

    public Object execute(ExecutionEvent event) throws ExecutionException {
        LaboResultsEditor laboResultsEditor;
        EditorInput editorInput;
        IDataObject data;
        IEditorPart activeEditor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (activeEditor instanceof LaboResultsEditor && (data = (editorInput = (EditorInput)(laboResultsEditor = (LaboResultsEditor)activeEditor).getEditorInput()).getDataObject()) instanceof XBaseLaboResultsProfessionnal) {
            XBaseLaboResultsProfessionnal xlabo = (XBaseLaboResultsProfessionnal)data;
            this.reassignLaboPatient(xlabo);
        }
        return null;
    }

    public void reassignLaboPatient(final XBaseLaboResultsProfessionnal xlabo) {
        BaseSearchView.openView(PatientSearchView.class, (Object)new IReferenceControl(){

            public void callback(Object o) {
                XBasePatient patient = PatientUtil.getBasePatient((Object)o);
                if (patient != null) {
                    String question = VEUILLEZ_CONFIRMER_LE_CHANGEMENT_DE_PATIENT_POUR_CE_RESULTAT;
                    question = question.replaceFirst("\\?", xlabo.getPatient().getNameBirthdateSex());
                    question = question.replaceFirst("\\?", patient.getNameBirthdateSex());
                    if (MessageUtil.askQuestion((Shell)UI.getWorkbenchShell(), (String)question)) {
                        try {
                            JobCallback callback = new JobCallback((IStatusHandler)DefaultStatusHandler.getInstance()){};
                            LaboResultsAccessorClient.getInstance().reassignLaboResultsToPatient(Application.get().getGlobalInstances().getSession(), (ICallback)callback, xlabo, patient.getId().intValue());
                        }
                        catch (CannotConnectToServerException cannotConnectToServerException) {
                            MessageUtil.cannotConnectToServerExceptionMsg();
                        }
                        catch (Exception e2) {
                            logger.log(Level.SEVERE, "Failed to reassign labo result " + xlabo + " to patient " + patient, e2);
                        }
                    }
                }
            }
        });
    }
}

