/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.eform;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.modules.eform.EformController;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.eform.XBaseEform;
import ca.infodata.ofys.data.middle.dataobjects.eform.XBaseEformData;
import ca.infodata.ofys.data.middle.dataobjects.eform.XEform;
import ca.infodata.ofys.data.middle.dataobjects.eform.XEformData;
import ca.infodata.ofys.data.middle.dataobjects.eform.XEformType;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.ui.person.patient.PatientUtil;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.StringUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;

public class PatientEformController {
    private static final Logger logger = Logger.getLogger(PatientEformController.class.getName());
    private final CopyOnWriteArrayList<XBaseEformData> datas = new CopyOnWriteArrayList();
    private volatile boolean datasLoaded;
    private XPatient patient = null;
    private EformController controller = new EformController();

    public boolean setPatient(IPatient p) {
        if (MiscUtil.areObjectsEquals((Object)p, (Object)this.patient)) {
            return false;
        }
        this.patient = PatientUtil.getSimplePatient((Object)p);
        this.datas.clear();
        return true;
    }

    public XPatient getPatient() {
        return this.patient;
    }

    public void loadFormDatas() {
        logger.info("EFormView.loadEFormData()");
        if (this.patient == null || this.patient.getId() == null) {
            logger.info("Cant load eform data list for patient " + this.patient);
            return;
        }
        XSession session = Application.get().getGlobalInstances().getSession();
        if (session == null) {
            logger.info("Cant load eform data list because session is null");
            this.datas.clear();
            return;
        }
        try {
            List list = this.controller.listFormData(this.patient.getId().intValue(), Boolean.TRUE);
            ArrayList<XBaseEformData> toRemove = new ArrayList<XBaseEformData>();
            for (XBaseEformData x : list) {
                if (!XEformType.CRDS.equals((Object)x.getForm().getType())) continue;
                toRemove.add(x);
            }
            list.removeAll(toRemove);
            this.datas.clear();
            this.datas.addAll(list);
            this.datasLoaded = true;
            logger.info("list size =" + list.size());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error loading patient eformdata, patient=" + StringUtils.safeToString((Logger)logger, (Object)this.patient), e);
        }
    }

    private XBaseEformData getFormData(Integer idEformData) throws Exception {
        XBaseEformData data = null;
        for (XBaseEformData d : this.datas) {
            if (!d.getId().equals(idEformData)) continue;
            data = d;
        }
        return data;
    }

    public List<XBaseEformData> getFormDatas() {
        return this.datas;
    }

    public boolean isDatasLoaded() {
        return this.datasLoaded;
    }

    public void setDatasLoaded(boolean datasLoaded) {
        this.datasLoaded = datasLoaded;
    }

    public boolean removeFromFavorites(int idEform) {
        return this.controller.removeFromFavorites(idEform);
    }

    public boolean addToFavorites(int idEform) {
        return this.controller.addToFavorites(idEform);
    }

    public List<XBaseEform> getForms() {
        return this.controller.getForms();
    }

    public List<XBaseEform> getAllForms() {
        return this.controller.getAllForms();
    }

    public List<XBaseEform> getFavorites() {
        return this.controller.getFavorites();
    }

    public XEformData viewFormData(Integer idEformData) throws Exception {
        return this.controller.getFormData(idEformData, true);
    }

    public XEform viewEForm(Integer idEform) throws Exception {
        XEform form = this.controller.getFullEForm(idEform);
        if (form.getType() == XEformType.CNESST) {
            form = this.getAlternativeForm(form);
        }
        return form;
    }

    private XEform getAlternativeForm(XEform form) throws Exception {
        int idAnchor = form.getIdAnchor();
        String html = null;
        switch (idAnchor) {
            case 234: 
            case 384: 
            case 385: 
            case 386: 
            case 387: 
            case 414: 
            case 418: 
            case 539: {
                html = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("alternative/cnesst - [418][386][387][384][385][414][234].html"));
                break;
            }
            case 146: {
                html = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("alternative/cnesst - attestation medicale (1936) [146].html"));
                break;
            }
            case 535: {
                html = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("alternative/CNESST - Final Report (1938) [535].html"));
                break;
            }
            case 536: {
                html = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("alternative/CNESST - Medical certificate (1936) [536].html"));
                break;
            }
            case 537: {
                html = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("alternative/CNESST - Medical Evaluation Report (2064) [537].html"));
                break;
            }
            case 538: {
                html = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("alternative/CNESST - Medical Report (1937) [538].html"));
                break;
            }
            case 383: {
                html = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("alternative/cnesst - rapport devaluation (2064) [383].html"));
                break;
            }
            case 397: {
                html = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("alternative/cnesst - rapport final (1938) [397].html"));
                break;
            }
            case 345: {
                html = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("alternative/cnesst - rapport medical - prise en charge ou evolution (1937) [345].html"));
                break;
            }
        }
        if (html != null) {
            XEform clone = form.clone();
            clone.setHtml(html);
            return clone;
        }
        return form;
    }

    public XEformData touchFormData(XBaseEformData data) throws Exception {
        return this.controller.getFormData(data.getId(), true);
    }

    public XEformData modifyFormData(Integer idEformData) throws Exception {
        return this.controller.modifyFormData(idEformData.intValue(), this.patient.getId().intValue());
    }

    public XEformData modifyFormData(XBaseEformData data) throws Exception {
        return this.controller.modifyFormData(data);
    }

    public XEformData newFormData(Integer idEform) throws Exception {
        return this.controller.newFormData(idEform.intValue(), this.patient.getId());
    }

    public XEformData newFormData(XBaseEformData data) throws Exception {
        return this.controller.newFormDataCopy(data.getId().intValue(), this.patient.getId().intValue());
    }

    public XEformData newFormData(XBaseEform form) throws Exception {
        if (form == null) {
            throw new NullPointerException("form");
        }
        if (form.getId() == null) {
            throw new NullPointerException("form.id");
        }
        if (this.patient == null) {
            throw new IllegalStateException("patient is null");
        }
        if (this.patient.getId() == null) {
            throw new IllegalStateException("patient.id is null");
        }
        XEformData data = this.controller.newFormData(form.getId().intValue(), this.patient.getId());
        return data;
    }

    public boolean removeFromFavorites(XBaseEform form) {
        return this.controller.removeFromFavorites(form.getId().intValue());
    }

    public boolean addToFavorites(XBaseEform form) {
        return this.controller.addToFavorites(form.getId().intValue());
    }

    public boolean isEditAllowed(Integer idEformData) throws Exception {
        XBaseEformData data = this.getFormData(idEformData);
        return this.isEditAllowed(data);
    }

    public boolean isEditAllowed(XBaseEformData data) {
        return data != null && Boolean.TRUE.equals(data.getIsModifiable()) && data.getForm().getType() != XEformType.CNESST;
    }

    public boolean isNewAllowed(XBaseEformData data) {
        return data != null && data.getForm().getType() != XEformType.CNESST;
    }

    public boolean isNewAllowed(XBaseEform form) {
        return form.getType() != XEformType.CNESST;
    }

    public boolean isNewAllowed(Integer idEform) throws Exception {
        return this.isNewAllowed((XBaseEform)this.controller.getFullEForm(idEform));
    }
}

