/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.eform;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.modules.eform.EformController;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.dataaccess.util.notification.DataObjectNotificationHandler;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.XRight;
import ca.infodata.ofys.data.middle.dataobjects.eform.XBaseEform;
import ca.infodata.ofys.data.middle.dataobjects.eform.XBaseEformData;
import ca.infodata.ofys.data.middle.dataobjects.eform.XEform;
import ca.infodata.ofys.data.middle.dataobjects.eform.XEformData;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObject;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.mb.listener.property.IPropertyListener;
import ca.infodata.ofys.mb.listener.property.PropertyListenerManager;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.BaseView;
import ca.infodata.ofys.ui.controls.FontAwareComposite;
import ca.infodata.ofys.ui.controls.FontAwareSection;
import ca.infodata.ofys.ui.controls.GenericLabelProvider;
import ca.infodata.ofys.ui.controls.GenericListToArrayContentProvider;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyText;
import ca.infodata.ofys.ui.eform.EFormDataContentProvider;
import ca.infodata.ofys.ui.eform.EFormPlugin;
import ca.infodata.ofys.ui.eform.EformManageDialog;
import ca.infodata.ofys.ui.eform.FilterCrdsAndCnesstOff;
import ca.infodata.ofys.ui.eform.PatientEformController;
import ca.infodata.ofys.ui.eform.SimpleEFormEditor;
import ca.infodata.ofys.ui.eform.SimpleEFormInput;
import ca.infodata.ofys.ui.library.IRefreshFont;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.patient.PatientUtil;
import ca.infodata.util1.ProviderAR;
import ca.infodata.util1.StringUtils;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.time.FastDateFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.ViewPart;

public class EFormView
extends ViewPart
implements IPropertyListener,
IRefreshFont {
    private static final Logger logger = Logger.getLogger(EFormView.class.getName());
    static final String FORMS = Messages.getString((String)"documenttype.EFORMS", (String[])new String[0]);
    static final String VOIR_LE_FORM = Messages.getString((String)"VOIR_LE_FORM", (String[])new String[0]);
    static final String MODIFIER_LE_FORM = Messages.getString((String)"MODIFIER_LE_FORM", (String[])new String[0]);
    static final String RETIRER_DES_FAV = Messages.getString((String)"RETIRER_DES_FAV", (String[])new String[0]);
    static final String DISPONIBLES = Messages.getString((String)"DISPONIBLES", (String[])new String[0]);
    static final String AJOUT_DE = Messages.getString((String)"AJOUT_DE", (String[])new String[0]);
    static final String AUX_FAVORIS = Messages.getString((String)"AUX_FAVORIS", (String[])new String[0]);
    static final String RETRAIT_DE_ = Messages.getString((String)"RETRAIT_DE_", (String[])new String[0]);
    static final String DES_FAVORIS = Messages.getString((String)"DES_FAVORIS", (String[])new String[0]);
    static final String AJOUTER_AUX_FAVORIS = Messages.getString((String)"AJOUTER_AUX_FAVORIS", (String[])new String[0]);
    static final String MODIFIER_COPIE_DU_FORM = Messages.getString((String)"MODIFIER_COPIE_DU_FORM", (String[])new String[0]);
    static final String SUPPRIMER_LE_FORM = Messages.getString((String)"SUPPRIMER_LE_FORM", (String[])new String[0]);
    static final String FILTER_FORM = Messages.getString((String)"RECHERCHE_FORM", (String[])new String[0]);
    static final String RELIE_AU_CLIENT = Messages.getString((String)"RELIE_AU_CLIENT", (String[])new String[0]);
    static final String FAVORIS = Messages.getString((String)"FAVORIS", (String[])new String[0]);
    private boolean usingTabletPerspective;
    private DataObjectNotificationHandler handler;
    private TableViewer tableEForm;
    private TableViewer tableEFormFavorite;
    private TreeViewer treeEFormData;
    private EFormDataContentProvider treeEFormDataContentProvider;
    private final PatientEformController controller = new PatientEformController();
    private XPatient fullPatient;
    private FastDateFormat datetimeFormatter = FastDateFormat.getInstance((String)(String.valueOf(FormatDateProvider.getFormatDate().toString()) + " HH:mm"));
    private SashForm bodySash;
    public Cursor CURSOR_MOVE;
    int lastMaxItem = 1;
    int minHeight = 9;
    private Composite parent;
    private MyText txtSearch;
    MyButton btnRefresh;
    Timer time;
    TimerTask task;

    public EFormView() {
        IWorkbenchPage page = BaseView.getPage();
        IPerspectiveDescriptor perspective = page.getPerspective();
        this.usingTabletPerspective = perspective != null && perspective.getId().equals("ca.infodata.ofys.ui.menu.EncounterPerspective");
        this.handler = new DataObjectNotificationHandler(){

            public void handle(DataObjectUpdatedNotification notification) {
                if (notification != null && notification.getObject() instanceof DataObject) {
                    DataObject dto = (DataObject)notification.getObject();
                    if (XEformData.class.getName().equals(dto.getClazz())) {
                        for (XBaseEformData dd : EFormView.this.controller.getFormDatas()) {
                            if (!dto.getId().equals(dd.getId())) continue;
                            return;
                        }
                        PropertyListenerManager.firePropertyChanged((Object)((Object)EFormView.this), (int)2);
                    }
                }
            }
        };
        Application.get().getGlobalInstances().getNotificationSystem().addDataObjectNotificationHandler(this.handler);
        PropertyListenerManager.addListener((Object)((Object)this), (IPropertyListener)this);
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        FormToolkit toolkit = UI.createToolKit((Widget)parent);
        toolkit.adapt(parent);
        FormLayout layout = new FormLayout();
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.spacing = 0;
        parent.setLayout((Layout)layout);
        FilterCrdsAndCnesstOff filter = new FilterCrdsAndCnesstOff();
        this.txtSearch = new MyText(parent, 2048);
        this.bodySash = new SashForm(parent, 66048);
        this.txtSearch.setMessage(FILTER_FORM);
        this.btnRefresh = new MyButton(parent, 8);
        this.btnRefresh.setImage(ResourceGetter.getImage((String)"images/refresh.png"));
        this.btnRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EFormView.this.loadEFormData();
            }
        });
        boolean manage = Application.get().getGlobalInstances().hasRight(XRight.EFORM_MANAGE);
        FormData fd = new FormData();
        fd = new FormData();
        fd.top = new FormAttachment(0);
        fd.right = new FormAttachment(100, manage ? -40 : 0);
        fd.bottom = new FormAttachment(this.txtSearch.getControl(), 3, 1024);
        this.btnRefresh.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment(0);
        fd.left = new FormAttachment(0);
        fd.right = new FormAttachment(this.btnRefresh.getControl());
        this.txtSearch.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment(this.txtSearch.getControl());
        fd.left = new FormAttachment(0);
        fd.right = new FormAttachment(100);
        fd.bottom = new FormAttachment(100);
        this.bodySash.setLayoutData((Object)fd);
        this.CURSOR_MOVE = ResourceGetter.getCursor((int)21);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginHeight = 2;
        fillLayout.marginWidth = 0;
        FontAwareSection sectionEFormData = new FontAwareSection((Composite)this.bodySash, 256, toolkit);
        Composite clientEFormData = toolkit.createComposite((Composite)sectionEFormData);
        sectionEFormData.setClient((Control)clientEFormData);
        sectionEFormData.setText(RELIE_AU_CLIENT);
        clientEFormData.setLayout((Layout)fillLayout);
        this.createMaximizeListener((Section)sectionEFormData, toolkit, 1);
        this.treeEFormData = new TreeViewer(toolkit.createTree(clientEFormData, 0));
        this.treeEFormData.setUseHashlookup(true);
        this.treeEFormData.getTree().setLinesVisible(false);
        this.treeEFormData.getTree().setHeaderVisible(false);
        this.treeEFormData.getTree().setFont(ResourceGetter.getFontNormal());
        this.treeEFormDataContentProvider = new EFormDataContentProvider(new ArrayList<XBaseEformData>(this.controller.getFormDatas()));
        this.treeEFormData.setContentProvider((IContentProvider)this.treeEFormDataContentProvider);
        TreeViewerColumn c5 = new TreeViewerColumn(this.treeEFormData, 0);
        c5.getColumn().setMoveable(false);
        c5.getColumn().setWidth(700);
        c5.setLabelProvider((CellLabelProvider)new GenericLabelProvider((ProviderAR)new ProviderAR<XBaseEformData, String>(){

            public String get(XBaseEformData data) {
                String datetime = EFormView.this.datetimeFormatter.format(data.getDatetime().getTime());
                String s = String.format("%s (%s) %s", datetime, data.getForm().getName(), StringUtils.isBlank((CharSequence)data.getResumeValue()) ? "" : " [" + StringUtils.abbreviateToWordExtra((String)data.getResumeValue(), (int)30) + "]");
                if (Application.get().getGlobalInstances().inDebugMode()) {
                    s = "(" + data.getIdAnchor() + "," + data.getId() + ") " + s;
                }
                return s;
            }
        }));
        this.treeEFormData.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (!UI.rightClick((MouseEvent)e)) {
                    ISelection selection = EFormView.this.treeEFormData.getSelection();
                    if (EFormView.this.usingTabletPerspective && !selection.isEmpty()) {
                        XBaseEformData data = (XBaseEformData)((IStructuredSelection)selection).getFirstElement();
                        try {
                            XEformData data2 = EFormView.this.controller.touchFormData(data);
                            EFormView.this.openEFormData(data2, true);
                        }
                        catch (Exception e2) {
                            logger.log(Level.SEVERE, "Failed to open eform data " + data, e2);
                        }
                    }
                }
            }
        });
        this.treeEFormData.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                ISelection selection;
                if (!EFormView.this.usingTabletPerspective && !(selection = e.getSelection()).isEmpty()) {
                    XBaseEformData data = (XBaseEformData)((IStructuredSelection)selection).getFirstElement();
                    try {
                        XEformData data2 = EFormView.this.controller.touchFormData(data);
                        EFormView.this.openEFormData(data2, true);
                    }
                    catch (Exception e2) {
                        logger.log(Level.SEVERE, "Failed to open eform data " + data, e2);
                    }
                }
            }
        });
        MenuManager popManagerFormData = new MenuManager();
        ModifyEFormSelection menuActionModifyEform = new ModifyEFormSelection(this.treeEFormData);
        popManagerFormData.add((IAction)menuActionModifyEform);
        ModifyCopyEFormSelection menuActionModifyEformCopy = new ModifyCopyEFormSelection(this.treeEFormData);
        popManagerFormData.add((IAction)menuActionModifyEformCopy);
        Menu menuData = popManagerFormData.createContextMenu((Control)this.treeEFormData.getTree());
        this.treeEFormData.getTree().setMenu(menuData);
        FontAwareSection sectionEFormFavorites = new FontAwareSection((Composite)this.bodySash, 256, toolkit);
        Composite clientEFormFavorites = toolkit.createComposite((Composite)sectionEFormFavorites);
        sectionEFormFavorites.setClient((Control)clientEFormFavorites);
        sectionEFormFavorites.setText(FAVORIS);
        clientEFormFavorites.setLayout((Layout)fillLayout);
        this.createMaximizeListener((Section)sectionEFormFavorites, toolkit, 2);
        this.tableEFormFavorite = new TableViewer(clientEFormFavorites, 67588);
        this.tableEFormFavorite.getTable().setHeaderVisible(false);
        this.tableEFormFavorite.getTable().setLinesVisible(false);
        this.tableEFormFavorite.getTable().setFont(ResourceGetter.getFontNormal());
        this.tableEFormFavorite.setContentProvider((IContentProvider)new GenericListToArrayContentProvider());
        this.tableEFormFavorite.setFilters(new ViewerFilter[]{filter});
        this.tableEFormFavorite.setLabelProvider((IBaseLabelProvider)new GenericLabelProvider((ProviderAR)new ProviderAR<XBaseEform, String>(){

            public String get(XBaseEform form) {
                String text = String.format("%s (%s) ", form.getName(), form.getLanguage());
                if (Application.get().getGlobalInstances().inDebugMode()) {
                    return form.getId() + " " + text;
                }
                return text;
            }
        }));
        this.tableEFormFavorite.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (!UI.rightClick((MouseEvent)e)) {
                    ISelection selection = EFormView.this.tableEFormFavorite.getSelection();
                    if (EFormView.this.usingTabletPerspective && !selection.isEmpty()) {
                        try {
                            XBaseEform form = (XBaseEform)((IStructuredSelection)selection).getFirstElement();
                            EFormView.this.newFormData(form);
                        }
                        catch (Exception e2) {
                            logger.log(Level.SEVERE, "Failed to create new form data", e2);
                            MessageUtil.show((Shell)EFormView.this.getSite().getShell(), (Exception)e2);
                        }
                    }
                }
            }
        });
        this.tableEFormFavorite.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                ISelection selection;
                if (!EFormView.this.usingTabletPerspective && !(selection = e.getSelection()).isEmpty()) {
                    try {
                        XBaseEform form = (XBaseEform)((IStructuredSelection)selection).getFirstElement();
                        EFormView.this.newFormData(form);
                    }
                    catch (Exception e2) {
                        logger.log(Level.SEVERE, "Failed to create new form data", e2);
                        MessageUtil.show((Shell)EFormView.this.getSite().getShell(), (Exception)e2);
                    }
                }
            }
        });
        MenuManager popManagerFav = new MenuManager();
        RetirerDesFavoriesSelection menuActionRetirerDesFavories = new RetirerDesFavoriesSelection(this.tableEFormFavorite);
        popManagerFav.add((IAction)menuActionRetirerDesFavories);
        VoirEFormSelection menuActionVoirEForm = new VoirEFormSelection(this.tableEFormFavorite);
        popManagerFav.add((IAction)menuActionVoirEForm);
        Menu menuFav = popManagerFav.createContextMenu((Control)this.tableEFormFavorite.getTable());
        this.tableEFormFavorite.getTable().setMenu(menuFav);
        this.txtSearch.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EFormView.this.filterForms();
            }
        });
        FontAwareSection sectionEForms = new FontAwareSection((Composite)this.bodySash, 256, toolkit);
        Composite clientEForms = toolkit.createComposite((Composite)sectionEForms);
        clientEForms.setLayout((Layout)fillLayout);
        sectionEForms.setClient((Control)clientEForms);
        sectionEForms.setText(DISPONIBLES);
        this.createMaximizeListener((Section)sectionEForms, toolkit, 3);
        this.tableEForm = new TableViewer(clientEForms, 67588);
        this.tableEForm.getTable().setHeaderVisible(false);
        this.tableEForm.getTable().setLinesVisible(false);
        this.tableEForm.getTable().setFont(ResourceGetter.getFontNormal());
        this.tableEForm.setContentProvider((IContentProvider)new GenericListToArrayContentProvider());
        this.tableEForm.setFilters(new ViewerFilter[]{filter});
        this.tableEForm.setLabelProvider((IBaseLabelProvider)new GenericLabelProvider((ProviderAR)new ProviderAR<XBaseEform, String>(){

            public String get(XBaseEform form) {
                String text = String.format("%s (%s) ", form.getName(), form.getLanguage());
                if (Application.get().getGlobalInstances().inDebugMode()) {
                    return form.getId() + " " + text;
                }
                return text;
            }
        }));
        this.tableEForm.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (!UI.rightClick((MouseEvent)e)) {
                    ISelection selection = EFormView.this.tableEForm.getSelection();
                    if (EFormView.this.usingTabletPerspective && !selection.isEmpty()) {
                        try {
                            XBaseEform form = (XBaseEform)((IStructuredSelection)selection).getFirstElement();
                            EFormView.this.newFormData(form);
                        }
                        catch (Exception e2) {
                            logger.log(Level.SEVERE, "Failed to create new form data", e2);
                            MessageUtil.show((Shell)EFormView.this.getSite().getShell(), (Exception)e2);
                        }
                    }
                }
            }
        });
        this.tableEForm.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                ISelection selection;
                if (!EFormView.this.usingTabletPerspective && !(selection = e.getSelection()).isEmpty()) {
                    try {
                        XBaseEform form = (XBaseEform)((IStructuredSelection)selection).getFirstElement();
                        EFormView.this.newFormData(form);
                    }
                    catch (Exception e2) {
                        logger.log(Level.SEVERE, "Failed to create new form data", e2);
                        MessageUtil.show((Shell)EFormView.this.getSite().getShell(), (Exception)e2);
                    }
                }
            }
        });
        MenuManager popManager = new MenuManager();
        AddToFavoriesSelection menuActionVoirAddToFavories = new AddToFavoriesSelection(this.tableEForm);
        popManager.add((IAction)menuActionVoirAddToFavories);
        VoirEFormSelection menuActionVoirEForm2 = new VoirEFormSelection(this.tableEForm);
        popManager.add((IAction)menuActionVoirEForm2);
        Menu menu = popManager.createContextMenu((Control)this.tableEForm.getTable());
        this.tableEForm.getTable().setMenu(menu);
        this.refreshFavoritesSync();
        this.refreshEFormsSync();
        this.controller.setPatient((IPatient)PersonUiPlugin.getDefault().getCurrentPatient());
        this.fullPatient = null;
        this.loadEFormData();
        PropertyListenerManager.addListener((Object)PersonUiPlugin.getDefault(), (IPropertyListener)this);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PropertyListenerManager.removeListener((IPropertyListener)EFormView.this);
                EFormView.this.fullPatient = null;
                ResourceGetter.dispose((Object)EFormView.this.CURSOR_MOVE);
            }
        });
        this.bodySash.addListener(11, new Listener(){

            public void handleEvent(Event arg0) {
                EFormView.this.maximizeBodyPart(EFormView.this.lastMaxItem);
            }
        });
        this.time = new Timer();
        this.task = new TimerTask(){

            @Override
            public void run() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        EFormView.this.maximizeBodyPart(1);
                    }
                });
            }
        };
        this.time.schedule(this.task, 1000L);
        MyButton btnSetClients = null;
        if (manage) {
            btnSetClients = new MyButton(parent, 8);
            btnSetClients.setText("...");
            btnSetClients.setToolTipText(Messages.getString((String)"GESTION_EFORMS_DU_CLIENT", (String[])new String[0]));
            btnSetClients.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EformManageDialog dialog = new EformManageDialog(new EformController());
                    if (dialog.open() == 0) {
                        EFormView.this.refreshEFormsSync();
                        EFormView.this.refreshFavoritesSync();
                    }
                }
            });
            fd = new FormData();
            fd.top = new FormAttachment(0);
            fd.left = new FormAttachment(this.btnRefresh.getControl());
            fd.right = new FormAttachment(100);
            fd.bottom = new FormAttachment(this.txtSearch.getControl(), 3, 1024);
            btnSetClients.setLayoutData((Object)fd);
        }
        ResourceGetter.addListener((IRefreshFont)this);
    }

    private void filterForms() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (!EFormView.this.tableEFormFavorite.getControl().isDisposed()) {
                    EFormView.this.tableEFormFavorite.setInput((Object)EFormView.this.getFilteredEformFavorite());
                }
                if (!EFormView.this.tableEForm.getControl().isDisposed()) {
                    EFormView.this.tableEForm.setInput((Object)EFormView.this.getFilteredEform());
                }
                if (!EFormView.this.treeEFormData.getControl().isDisposed()) {
                    EFormView.this.treeEFormData.setInput((Object)EFormView.this.getFilteredEformData());
                    EFormView.this.treeEFormData.refresh(true);
                }
            }
        });
    }

    private List<XBaseEform> getFilteredEform() {
        String txt = this.txtSearch.getText();
        ArrayList<XBaseEform> eforms = new ArrayList<XBaseEform>();
        if (txt == null || txt.length() == 0) {
            eforms.addAll(this.controller.getForms());
        } else {
            txt = StringUtils.NormalizeToLowercase((String)txt);
            for (XBaseEform ef : this.controller.getForms()) {
                if (!StringUtils.NormalizeToLowercase((String)ef.getName()).contains(txt)) continue;
                eforms.add(ef);
            }
        }
        this.sortEForms(eforms);
        return eforms;
    }

    private List<XBaseEform> getFilteredEformFavorite() {
        String txt = this.txtSearch.getText();
        ArrayList<XBaseEform> eforms = new ArrayList<XBaseEform>();
        if (txt == null || txt.length() == 0) {
            eforms.addAll(this.controller.getFavorites());
        } else {
            txt = StringUtils.NormalizeToLowercase((String)txt);
            for (XBaseEform ef : this.controller.getFavorites()) {
                if (!StringUtils.NormalizeToLowercase((String)ef.getName()).contains(txt)) continue;
                eforms.add(ef);
            }
        }
        this.sortEForms(eforms);
        return eforms;
    }

    private List<XBaseEformData> getFilteredEformData() {
        String txt = this.txtSearch.getText();
        ArrayList<XBaseEformData> eforms = new ArrayList<XBaseEformData>();
        if (txt == null || txt.length() == 0) {
            eforms.addAll(this.controller.getFormDatas());
        } else {
            txt = StringUtils.NormalizeToLowercase((String)txt);
            for (XBaseEformData efd : this.controller.getFormDatas()) {
                if (!StringUtils.NormalizeToLowercase((String)efd.getForm().getName()).contains(txt)) continue;
                eforms.add(efd);
            }
        }
        return eforms;
    }

    public void loadEFormData() {
        logger.info("EFormView.loadEFormData()");
        Job job2 = new Job("Chargement des formulaires compl\u00e9t\u00e9s"){

            protected IStatus run(IProgressMonitor monitor) {
                EFormView.this.controller.loadFormDatas();
                EFormView.this.refreshDatasSync();
                return Status.OK_STATUS;
            }
        };
        job2.schedule();
    }

    private void sortEForms(List<XBaseEform> list) {
        final Collator collator = Collator.getInstance(Locale.CANADA_FRENCH);
        collator.setStrength(2);
        Collections.sort(list, new Comparator<XBaseEform>(){

            @Override
            public int compare(XBaseEform o1, XBaseEform o2) {
                return collator.compare(o1.getName(), o2.getName());
            }
        });
    }

    protected void removeFromFavorites(final XBaseEform form) {
        Job job2 = new Job(String.valueOf(RETRAIT_DE_) + form.getName() + DES_FAVORIS){

            protected IStatus run(IProgressMonitor monitor) {
                boolean done = EFormView.this.controller.removeFromFavorites(form);
                if (done) {
                    EFormView.this.refreshFavorites();
                }
                return Status.OK_STATUS;
            }
        };
        job2.schedule();
    }

    protected void addToFavorites(final XBaseEform form) {
        Job job2 = new Job(String.valueOf(AJOUT_DE) + form.getName() + AUX_FAVORIS){

            protected IStatus run(IProgressMonitor monitor) {
                boolean done = EFormView.this.controller.addToFavorites(form);
                if (done) {
                    EFormView.this.refreshFavorites();
                }
                return Status.OK_STATUS;
            }
        };
        job2.schedule();
    }

    public void setFocus() {
        this.tableEForm.getControl().setFocus();
    }

    private void refreshFavorites() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!EFormView.this.tableEFormFavorite.getControl().isDisposed()) {
                    EFormView.this.tableEFormFavorite.setInput((Object)EFormView.this.getFilteredEformFavorite());
                }
            }
        });
    }

    private void refreshFavoritesSync() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (!EFormView.this.tableEFormFavorite.getControl().isDisposed()) {
                    EFormView.this.tableEFormFavorite.setInput((Object)EFormView.this.getFilteredEformFavorite());
                }
            }
        });
    }

    private void refreshDatasSync() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (!EFormView.this.treeEFormData.getControl().isDisposed()) {
                    EFormView.this.treeEFormData.setInput((Object)EFormView.this.getFilteredEformData());
                }
            }
        });
    }

    private void refreshEFormsSync() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (!EFormView.this.tableEForm.getControl().isDisposed()) {
                    EFormView.this.tableEForm.setInput((Object)EFormView.this.getFilteredEform());
                    EFormView.this.tableEFormFavorite.setInput((Object)EFormView.this.getFilteredEformFavorite());
                }
            }
        });
    }

    protected void modifyFormData(XBaseEformData data) throws Exception {
        if (this.controller.isEditAllowed(data)) {
            XEformData data2 = this.controller.modifyFormData(data);
            this.openEFormData(data2, false);
        }
    }

    protected void newFormData(XBaseEformData data) throws Exception {
        if (this.controller.isNewAllowed(data)) {
            XEformData data2 = this.controller.newFormData(data);
            this.openEFormData(data2, false);
        }
    }

    protected void newFormData(XBaseEform form) throws Exception {
        if (this.controller.getPatient() != null && this.controller.getPatient().getId() != null) {
            if (this.controller.isNewAllowed(form)) {
                XEformData data = this.controller.newFormData(form);
                this.openEFormData(data, false);
            } else {
                this.openEForm(form);
            }
        }
    }

    protected void openEFormData(XEformData data, boolean readonly) {
        SimpleEFormInput input = new SimpleEFormInput(data, this.getFullPatient(), readonly);
        BaseEditor.openEditorSafe((IEditorInput)input, (String)SimpleEFormEditor.class.getName());
    }

    public void openEForm(XBaseEform form) throws Exception {
        XEform form2 = this.controller.viewEForm(form.getId());
        XPatient patient = this.getFullPatient();
        if (patient == null) {
            BaseEditor.openEditorSafe((IEditorInput)new SimpleEFormInput(form2), (String)SimpleEFormEditor.class.getName());
        } else {
            BaseEditor.openEditorSafe((IEditorInput)new SimpleEFormInput(form2, patient), (String)SimpleEFormEditor.class.getName());
        }
    }

    private XPatient getFullPatient() {
        XPatient patient = this.controller.getPatient();
        this.fullPatient = patient == null ? null : (patient.getId() == null ? patient : (this.fullPatient == null ? PatientUtil.getXPatient((Object)patient) : (patient.getId().equals(this.fullPatient.getId()) ? PatientUtil.getXPatient((Object)this.fullPatient) : PatientUtil.getXPatient((Object)patient))));
        return this.fullPatient;
    }

    public void propertyChanged(int propertyId) {
        if (propertyId == 1) {
            EFormPlugin.getDefault().getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    XPatient patient = PersonUiPlugin.getDefault().getCurrentPatient();
                    if (EFormView.this.controller.setPatient((IPatient)patient)) {
                        EFormView.this.fullPatient = null;
                        EFormView.this.loadEFormData();
                        if (patient == null || patient.getId() == null) {
                            EFormView.this.setPartName(FORMS);
                        } else {
                            EFormView.this.setPartName(String.valueOf(FORMS) + " ( " + patient.getNameBirthdateSex() + " )");
                        }
                    }
                }
            });
        } else if (propertyId == 2) {
            EFormPlugin.getDefault().getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    EFormView.this.loadEFormData();
                }
            });
        }
    }

    private Label createMaximizeListener(Section parent, FormToolkit toolkit, final int bodyPart) {
        Label label = null;
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c instanceof Label) {
                label = (Label)c;
                break;
            }
            ++n2;
        }
        label.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
                EFormView.this.bodySash.setCursor(EFormView.this.CURSOR_MOVE);
            }

            public void mouseExit(MouseEvent e) {
                EFormView.this.bodySash.setCursor(null);
            }

            public void mouseHover(MouseEvent e) {
                EFormView.this.bodySash.setCursor(EFormView.this.CURSOR_MOVE);
            }
        });
        label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (e.button == 1) {
                    if (EFormView.this.lastMaxItem == bodyPart) {
                        EFormView.this.restoreInitialBodyWeight();
                    } else {
                        EFormView.this.maximizeBodyPart(bodyPart);
                    }
                }
            }
        });
        return label;
    }

    protected void restoreInitialBodyWeight() {
        int y = this.bodySash.getSize().y;
        double ratio = ((double)y - 300.0) / (double)y;
        double min = (double)this.minHeight - (double)this.minHeight * ratio;
        double max = 100.0 - 2.0 * min;
        int iMin = (int)min;
        int iMax = (int)max;
        if (iMax > 0 && iMax < 100 && iMin > 0 && iMin < 35) {
            this.bodySash.setWeights(new int[]{iMax, iMin, iMin});
            this.lastMaxItem = 1;
        }
    }

    protected void maximizeBodyPart(int i) {
        if (!this.bodySash.isDisposed()) {
            int y = this.bodySash.getSize().y;
            double ratio = ((double)y - 300.0) / (double)y;
            double min = (double)this.minHeight - (double)this.minHeight * ratio;
            double max = 100.0 - 2.0 * min;
            int iMin = (int)min;
            int iMax = (int)max;
            if (iMax > 0 && iMax < 100 && iMin > 0 && iMin < 35) {
                switch (i) {
                    case 1: {
                        this.bodySash.setWeights(new int[]{iMax, iMin, iMin});
                        break;
                    }
                    case 2: {
                        this.bodySash.setWeights(new int[]{iMin, iMax, iMin});
                        break;
                    }
                    case 3: {
                        this.bodySash.setWeights(new int[]{iMin, iMin, iMax});
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("i must be in [1..3]");
                    }
                }
            }
            this.lastMaxItem = i;
        }
    }

    public void dispose() {
        if (this.task != null) {
            this.task.cancel();
        }
        if (this.time != null) {
            this.time.cancel();
        }
        ResourceGetter.removeListener((IRefreshFont)this);
        Application.get().getGlobalInstances().getNotificationSystem().removeDataObjectNotificationHandler(this.handler);
        PropertyListenerManager.removeListener((Object)((Object)this), (IPropertyListener)this);
        super.dispose();
    }

    public void refreshFont() {
        FontAwareComposite.refreshFont((Control)this.parent);
        this.parent.layout(true, true);
    }

    private class AddToFavoriesSelection
    extends Action {
        final TableViewer viewer;

        public AddToFavoriesSelection(TableViewer viewer) {
            super(Messages.getString((String)"AJOUTER_AUX_FAVORIS", (String[])new String[0]));
            this.viewer = viewer;
        }

        public XBaseEform getSelection() {
            ISelection selection;
            XBaseEform form = null;
            if (this.viewer != null && !(selection = this.viewer.getSelection()).isEmpty()) {
                form = (XBaseEform)((IStructuredSelection)selection).getFirstElement();
            }
            return form;
        }

        public void run() {
            XBaseEform selection = this.getSelection();
            if (selection != null && !EFormView.this.controller.getFavorites().contains(selection)) {
                EFormView.this.addToFavorites(selection);
            }
        }
    }

    private class ModifyCopyEFormSelection
    extends Action {
        final TreeViewer viewer;

        public ModifyCopyEFormSelection(TreeViewer r) {
            super(Messages.getString((String)"MODIFIER_COPIE_DU_FORM", (String[])new String[0]));
            this.viewer = r;
        }

        public void run() {
            if (this.viewer != null) {
                ISelection selection = this.viewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                XBaseEformData data = (XBaseEformData)((IStructuredSelection)selection).getFirstElement();
                if (EFormView.this.controller.isNewAllowed(data)) {
                    try {
                        EFormView.this.newFormData(data);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Failed to get eform data for copy", e);
                    }
                } else {
                    try {
                        EFormView.this.openEForm(data.getForm());
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Failed to open selected eform " + selection, e);
                    }
                }
            }
        }
    }

    private class ModifyEFormSelection
    extends Action {
        final TreeViewer viewer;

        public ModifyEFormSelection(TreeViewer r) {
            super(Messages.getString((String)"MODIFIER_LE_FORM", (String[])new String[0]));
            this.viewer = r;
        }

        public void run() {
            if (this.viewer != null) {
                ISelection selection = this.viewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                XBaseEformData data = (XBaseEformData)((IStructuredSelection)selection).getFirstElement();
                if (EFormView.this.controller.isEditAllowed(data)) {
                    boolean modifiable;
                    boolean bl = modifiable = data.getIsModifiable() == null ? true : data.getIsModifiable();
                    if (data.getId() != null && EFormView.this.treeEFormDataContentProvider.isLastVersion(data) && modifiable) {
                        try {
                            EFormView.this.modifyFormData(data);
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "Failed to get eform data for modify", e);
                        }
                    }
                } else {
                    try {
                        EFormView.this.openEForm(data.getForm());
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Failed to open selected eform " + selection, e);
                    }
                }
            }
        }
    }

    private class RetirerDesFavoriesSelection
    extends Action {
        final TableViewer viewer;

        public RetirerDesFavoriesSelection(TableViewer viewer) {
            super(Messages.getString((String)"RETIRER_DES_FAV", (String[])new String[0]));
            this.viewer = viewer;
        }

        public XBaseEform getSelection() {
            ISelection selection;
            XBaseEform form = null;
            if (this.viewer != null && !(selection = this.viewer.getSelection()).isEmpty()) {
                form = (XBaseEform)((IStructuredSelection)selection).getFirstElement();
            }
            return form;
        }

        public void run() {
            XBaseEform selection = this.getSelection();
            if (selection != null) {
                EFormView.this.removeFromFavorites(selection);
            }
        }
    }

    private class VoirEFormSelection
    extends Action {
        final TableViewer viewer;

        public VoirEFormSelection(TableViewer viewer) {
            super(Messages.getString((String)"VOIR_LE_FORM", (String[])new String[0]));
            this.viewer = viewer;
        }

        public XBaseEform getSelection() {
            ISelection selection;
            XBaseEform form = null;
            if (this.viewer != null && !(selection = this.viewer.getSelection()).isEmpty()) {
                form = (XBaseEform)((IStructuredSelection)selection).getFirstElement();
            }
            return form;
        }

        public void run() {
            XBaseEform selection = this.getSelection();
            if (selection != null) {
                try {
                    EFormView.this.openEForm(selection);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Failed to open selected eform " + selection, e);
                }
            }
        }
    }
}

