/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dsq.controller;

import ca.infodata.dsq.domain.Code;
import ca.infodata.dsq.domain.DispenseDetails;
import ca.infodata.dsq.domain.DispenseSummary;
import ca.infodata.dsq.domain.DosageInstruction;
import ca.infodata.dsq.domain.Duration;
import ca.infodata.dsq.domain.Ingredient;
import ca.infodata.dsq.domain.NIU_PRESCRIPTION_DM;
import ca.infodata.dsq.domain.Quantity;
import ca.infodata.dsq.domain.ValueWithUnit;
import ca.infodata.dsq.service.dm.DMQRYCSvc.QueryContinuationResult;
import ca.infodata.dsq.signature.Signature;
import ca.infodata.dsq.signature.XmlSignatureI;
import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.modules.dsq.AbortException;
import ca.infodata.ofys.client.modules.dsq.Alias;
import ca.infodata.ofys.client.modules.dsq.CancelException;
import ca.infodata.ofys.client.modules.dsq.DsqCallback;
import ca.infodata.ofys.client.modules.dsq.SqimHtmlFormatter;
import ca.infodata.ofys.data.client.dataaccess.DSQAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.encounter.DIN;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.medication.XChangeDose;
import ca.infodata.ofys.data.middle.dataobjects.medication.XDrugStrength;
import ca.infodata.ofys.data.middle.dataobjects.medication.XDrugType;
import ca.infodata.ofys.data.middle.dataobjects.medication.XMyHumanSubstanceAdministrationSite;
import ca.infodata.ofys.data.middle.dataobjects.medication.XMyOrderableDrugForm;
import ca.infodata.ofys.data.middle.dataobjects.medication.XMyRouteOfAdministration;
import ca.infodata.ofys.data.middle.dataobjects.medication.XPrescription;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.ofys.ui.controls.IProgressMonitorWithLog;
import ca.infodata.ofys.ui.controls.MySubProgressMonitor;
import ca.infodata.ofys.ui.dsq.BaseDSQAction;
import ca.infodata.ofys.ui.dsq.FindCandidateAction;
import ca.infodata.ofys.ui.dsq.controller.DispenseControllerCallback;
import ca.infodata.ofys.ui.dsq.controller.QueryContinuationController;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.rxdrugref.IRxDrugRefAccessor;
import ca.infodata.util1.ConcurrentHashSet;
import ca.infodata.util1.IPair;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.Pair;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class DispenseController
extends QueryContinuationController {
    private static final Logger logger = Logger.getLogger(DispenseController.class.getName());
    private static final String OBTENTION_DE_LA_LISTE_DES_ORDONNANCES_DELIVRES_AU_PATIENT = Messages.getString((String)"ListPatientPrescriptionDispensedAction.OBTENTION_DE_LA_LISTE_DES_ORDONNANCES_DELIVRES_AU_PATIENT", (String[])new String[0]);
    private static final String OBTENTION_DE_LA_LISTE_DES_DELIVRANCES_POUR_UNE_ORDONANCES = Messages.getString((String)"ListPatientPrescriptionDispensedAction.OBTENTION_DE_LA_LISTE_DES_DELIVRANCES_POUR_UNE_ORDONANCES", (String[])new String[0]);
    private static final String OBTENTION_DE_L_ORDONNANCE_DETAILLEE = Messages.getString((String)"GetPrescriptionDispensedDetailsAction.OBTENTION_DE_L_ORDONNANCE_DETAILLEE", (String[])new String[0]);
    private boolean activeProfile = true;
    private LocalDate start = LocalDate.from((int)1, (int)1, (int)2007);
    private LocalDate end = LocalDate.today();
    private boolean mostRecent = true;
    private IPatient patient;
    private int limit = 50;
    private List<DispenseSummary> dispenses;
    private QueryContinuationResult lastQCR;
    private Map<String, DispenseDetails> dispenseIdMapDetail;
    private List<DispenseSummary> dispensesForPrescription;
    private QueryContinuationResult lastQCRForPrescription;
    private NIU_PRESCRIPTION_DM lastQCRForPrescriptionNiuUsed;
    private final DispenseControllerCallback callback;
    private FindCandidateAction findCandidateAction;
    private Job listSummaryJob;
    private JobDsqContextNui listSummaryForPrescriptionJob;
    private JobExtension getDetailJob;
    private ConvertJob convertJob;
    private final ConcurrentHashSet<BatchJob> batchJobs;
    private static final Pattern pat09 = Pattern.compile("[0-9]");

    public DispenseController(DispenseControllerCallback callback, BaseDSQAction action, FindCandidateAction findCandidateAction) {
        super(action);
        if (callback == null) {
            throw new NullPointerException("callback");
        }
        this.findCandidateAction = findCandidateAction;
        this.callback = callback;
        this.dispenseIdMapDetail = new ConcurrentHashMap<String, DispenseDetails>();
        this.batchJobs = new ConcurrentHashSet();
    }

    public void listSummary() {
        if (this.listSummaryJob == null) {
            this.listSummaryJob = new Job("Sommaire des d\u00e9livrances"){

                protected IStatus run(IProgressMonitor monitor) {
                    DispenseController.this.listSummary2(monitor);
                    return Status.OK_STATUS;
                }
            };
        }
        if (this.listSummaryJob.getState() == 4) {
            this.callback.listSummary((DsqCallback<QueryContinuationResult>)new DsqCallback(null, "Op\u00e9ration en cours...", null));
        } else {
            this.listSummaryJob.schedule();
        }
    }

    protected void listSummary2(IProgressMonitor monitor) {
        if (this.dispenses == null) {
            DsqCallback<QueryContinuationResult> r = this.listSummary3(this.patient, this.start, this.end, this.mostRecent, monitor);
            this.lastQCR = (QueryContinuationResult)r.result;
            if (r.result != null) {
                this.dispenses = new ArrayList<DispenseSummary>(((QueryContinuationResult)r.result).dispenses);
            }
            this.callback.listSummary(r);
        } else if (this.lastQCR != null && this.lastQCR.originalTotalQuantity > this.dispenses.size()) {
            DsqCallback<QueryContinuationResult> r = this.continueQuery(this.patient, this.lastQCR, this.limit, monitor);
            if (r.result != null) {
                this.lastQCR = (QueryContinuationResult)r.result;
                this.dispenses.addAll(((QueryContinuationResult)r.result).dispenses);
                QueryContinuationResult r2 = new QueryContinuationResult();
                r2.originalTotalQuantity = this.lastQCR.originalTotalQuantity;
                r2.dispenses = this.dispenses;
                r2.queryId = ((QueryContinuationResult)r.result).queryId;
                r2.resultTotalQuantity = r2.originalTotalQuantity;
                r2.resultCurrentQuantity = r2.dispenses.size();
                r2.resultRemainingQuantity = r2.resultTotalQuantity - r2.resultCurrentQuantity;
                this.callback.listSummary((DsqCallback<QueryContinuationResult>)new DsqCallback((Object)r2));
            } else {
                this.callback.listSummary(r);
            }
        } else {
            QueryContinuationResult r2 = new QueryContinuationResult();
            r2.originalTotalQuantity = this.lastQCR.originalTotalQuantity;
            r2.dispenses = this.dispenses;
            r2.queryId = this.lastQCR.queryId;
            r2.resultTotalQuantity = r2.originalTotalQuantity;
            r2.resultCurrentQuantity = r2.dispenses.size();
            r2.resultRemainingQuantity = r2.resultTotalQuantity - r2.resultCurrentQuantity;
            this.callback.listSummary((DsqCallback<QueryContinuationResult>)new DsqCallback((Object)r2));
        }
    }

    private DsqCallback<QueryContinuationResult> listSummary3(IPatient patient, LocalDate start, LocalDate end, boolean mostRecent, IProgressMonitor monitor) {
        DsqCallback callback = new DsqCallback();
        try {
            if (end.before((IPartialDate)start)) {
                callback.message = "La date de d\u00e9but doit \u00eatre avant la date de fin";
                if (monitor != null) {
                    monitor.done();
                }
                DsqCallback dsqCallback = callback;
                return dsqCallback;
            }
            try {
                if (monitor != null) {
                    monitor.beginTask(OBTENTION_DE_LA_LISTE_DES_ORDONNANCES_DELIVRES_AU_PATIENT, 4);
                }
                XmlSignatureI signature = null;
                XmlSignatureI signatureNiu = null;
                if (!this.dsq.hasSignatures(patient.getId())) {
                    if (!UI.OS_WINDOWS) {
                        throw new AbortException(Messages.getString((String)"ABSENCE_SIGN_DSQ", (String[])new String[0]));
                    }
                    this.dsq.checkIfActionWasCanceled(monitor);
                    Alias alias = this.dsq.getAlias(monitor);
                    this.dsq.checkIfActionWasCanceled(monitor);
                    String niu = this.findCandidateAction.getNiu(patient, (IProgressMonitorWithLog)(monitor == null ? null : new MySubProgressMonitor(monitor, 1)));
                    this.dsq.checkIfActionWasCanceled(monitor);
                    signature = this.dsq.getSignatureI(monitor, alias, null);
                    this.dsq.checkIfActionWasCanceled(monitor);
                    signatureNiu = this.dsq.getXmlSignatureI(monitor, alias, null, niu);
                    this.dsq.checkIfActionWasCanceled(monitor);
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                }
                this.dsq.checkIfActionWasCanceled(monitor);
                if (monitor != null) {
                    monitor.subTask("Recherche");
                }
                XSession session = Application.get().getGlobalInstances().getSession();
                ReturnObject r = DSQAccessorClient.getInstance().getDrugDispensesSummary(session, start, end, mostRecent, patient.getId(), this.limit, (Signature)signature, (Signature)signatureNiu);
                if (r == null) {
                    throw new AbortException("Erreur lors de l'" + OBTENTION_DE_LA_LISTE_DES_ORDONNANCES_DELIVRES_AU_PATIENT.toLowerCase());
                }
                this.dsq.manageDsqStatus(r.getStatus());
                callback.result = (QueryContinuationResult)r.getObj();
                this.dsq.checkIfActionWasCanceled(monitor);
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
                callback.message = MessageUtil.CANNOT_CONNECT_TO_SERVER_MESSAGE;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (AbortException | StatusException e) {
                callback.message = e.getMessage();
            }
            catch (CancelException cancelException) {
            }
            catch (Exception e) {
                callback.exception = e;
                callback.message = e.getMessage();
                logger.log(Level.SEVERE, String.format("Failed to list dispense summary %s, %s, %s, %s", StringUtils.safeToString((Logger)logger, (Object)patient), start, end, mostRecent), e);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
        return callback;
    }

    public void listSummaryForPrescription(NIU_PRESCRIPTION_DM niu, String context) {
        if (this.listSummaryForPrescriptionJob == null) {
            this.listSummaryForPrescriptionJob = new JobDsqContextNui("Sommaire des d\u00e9livrances d'une ordonnance", niu, context);
        } else {
            this.listSummaryForPrescriptionJob.setContext(context);
            this.listSummaryForPrescriptionJob.setNiu(niu);
        }
        if (this.listSummaryForPrescriptionJob.getState() == 4) {
            this.callback.listSummaryForPrescription(niu, context, (DsqCallback<QueryContinuationResult>)new DsqCallback(null, "Op\u00e9ration en cours...", null));
        } else {
            this.listSummaryForPrescriptionJob.schedule();
        }
    }

    protected void listSummaryForPrescription2(NIU_PRESCRIPTION_DM niuPrescriptionDm, String context, IProgressMonitor monitor) {
        if (niuPrescriptionDm == null) {
            this.callback.listSummaryForPrescription(niuPrescriptionDm, context, (DsqCallback<QueryContinuationResult>)new DsqCallback(null, null, (Exception)new NullPointerException("niu")));
            return;
        }
        if (!niuPrescriptionDm.equals((Object)this.lastQCRForPrescriptionNiuUsed)) {
            this.dispensesForPrescription = null;
            this.lastQCRForPrescription = null;
            this.lastQCRForPrescriptionNiuUsed = null;
        }
        if (this.dispensesForPrescription == null) {
            DsqCallback<QueryContinuationResult> r = this.listSummaryForPrescription3(this.patient, niuPrescriptionDm, monitor);
            this.lastQCRForPrescription = (QueryContinuationResult)r.result;
            this.lastQCRForPrescriptionNiuUsed = niuPrescriptionDm;
            if (r.result != null) {
                this.dispensesForPrescription = new ArrayList<DispenseSummary>(((QueryContinuationResult)r.result).dispenses);
            }
            this.callback.listSummaryForPrescription(niuPrescriptionDm, context, r);
        } else if (this.lastQCRForPrescription != null && this.lastQCRForPrescription.originalTotalQuantity > this.dispensesForPrescription.size()) {
            DsqCallback<QueryContinuationResult> r = this.continueQuery(this.patient, this.lastQCRForPrescription, this.limit, monitor);
            if (r.result != null) {
                this.lastQCRForPrescription = (QueryContinuationResult)r.result;
                this.dispensesForPrescription.addAll(((QueryContinuationResult)r.result).dispenses);
                QueryContinuationResult r2 = new QueryContinuationResult();
                r2.originalTotalQuantity = this.lastQCRForPrescription.originalTotalQuantity;
                r2.dispenses = this.dispensesForPrescription;
                r2.queryId = ((QueryContinuationResult)r.result).queryId;
                r2.resultTotalQuantity = r2.originalTotalQuantity;
                r2.resultCurrentQuantity = r2.dispenses.size();
                r2.resultRemainingQuantity = r2.resultTotalQuantity - r2.resultCurrentQuantity;
                this.callback.listSummaryForPrescription(niuPrescriptionDm, context, (DsqCallback<QueryContinuationResult>)new DsqCallback((Object)r2));
            } else {
                this.callback.listSummaryForPrescription(niuPrescriptionDm, context, r);
            }
        } else {
            QueryContinuationResult r2 = new QueryContinuationResult();
            r2.originalTotalQuantity = this.lastQCRForPrescription.originalTotalQuantity;
            r2.dispenses = this.dispensesForPrescription;
            r2.queryId = this.lastQCRForPrescription.queryId;
            r2.resultTotalQuantity = r2.originalTotalQuantity;
            r2.resultCurrentQuantity = r2.dispenses.size();
            r2.resultRemainingQuantity = r2.resultTotalQuantity - r2.resultCurrentQuantity;
            this.callback.listSummaryForPrescription(niuPrescriptionDm, context, (DsqCallback<QueryContinuationResult>)new DsqCallback((Object)r2));
        }
    }

    /*
     * Exception decompiling
     */
    private DsqCallback<QueryContinuationResult> listSummaryForPrescription3(IPatient patient, NIU_PRESCRIPTION_DM niuPrescriptionDM, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void convertDetail(String dispenseId) {
        if (this.convertJob == null) {
            this.convertJob = new ConvertJob("Importer une d\u00e9livrance");
        }
        if (this.convertJob.getState() == 4) {
            this.callback.convertDetail(dispenseId, (DsqCallback<IPair<DispenseDetails, XPrescription>>)new DsqCallback(null, "Op\u00e9ration en cours...", null));
        } else {
            this.convertJob.setDispenseId(dispenseId);
            this.convertJob.schedule();
        }
    }

    private void convertDetail2(String dispenseId, IProgressMonitor monitor) {
        DispenseDetails d = this.dispenseIdMapDetail.get(dispenseId);
        if (d == null) {
            DsqCallback<DispenseDetails> c = this.getDetail3(dispenseId, this.patient, monitor);
            if (c.result != null) {
                this.dispenseIdMapDetail.put(dispenseId, (DispenseDetails)c.result);
            }
            DsqCallback c2 = new DsqCallback();
            c2.result = c.result == null ? new Pair(null, null) : new Pair((Object)((DispenseDetails)c.result), (Object)this.convertDispenseDetailsToXPrescription((DispenseDetails)c.result));
            this.callback.convertDetail(dispenseId, (DsqCallback<IPair<DispenseDetails, XPrescription>>)c2);
        } else {
            DsqCallback c2 = new DsqCallback();
            c2.result = new Pair((Object)d, (Object)this.convertDispenseDetailsToXPrescription(d));
            this.callback.convertDetail(dispenseId, (DsqCallback<IPair<DispenseDetails, XPrescription>>)c2);
        }
    }

    public void getDetail(String dispenseId) {
        if (this.getDetailJob == null) {
            this.getDetailJob = new JobExtension("D\u00e9tail d'une d\u00e9livrance");
        }
        if (this.getDetailJob.getState() == 4) {
            this.callback.getDetail(dispenseId, (DsqCallback<DispenseDetails>)new DsqCallback(null, "Op\u00e9ration en cours...", null));
        } else {
            this.getDetailJob.setDispenseId(dispenseId);
            this.getDetailJob.schedule();
        }
    }

    private void getDetail2(String dispenseId, IProgressMonitor monitor) {
        DispenseDetails d = this.dispenseIdMapDetail.get(dispenseId);
        if (d == null) {
            DsqCallback<DispenseDetails> c = this.getDetail3(dispenseId, this.patient, monitor);
            if (c.result != null) {
                this.dispenseIdMapDetail.put(dispenseId, (DispenseDetails)c.result);
            }
            this.callback.getDetail(dispenseId, c);
        } else {
            this.callback.getDetail(dispenseId, (DsqCallback<DispenseDetails>)new DsqCallback((Object)d));
        }
    }

    public void getDetailForBatch(String dispenseId, String dId, String idRx) {
        BatchJob job = new BatchJob("D\u00e9tail d'une d\u00e9livrance " + dispenseId, dId, idRx);
        job.setDispenseId(dispenseId);
        this.batchJobs.add((Object)job);
        job.schedule();
    }

    private void getDetailForBatch2(String dispenseId, String dId, String idRx, IProgressMonitor monitor) {
        DispenseDetails d = this.dispenseIdMapDetail.get(dispenseId);
        if (d == null) {
            DsqCallback<DispenseDetails> c = this.getDetail3(dispenseId, this.patient, monitor);
            if (c.result != null) {
                this.dispenseIdMapDetail.put(dispenseId, (DispenseDetails)c.result);
            }
            this.callback.getDetailForImport(dispenseId, dId, idRx, c);
        } else {
            this.callback.getDetailForImport(dispenseId, dId, idRx, (DsqCallback<DispenseDetails>)new DsqCallback((Object)d));
        }
    }

    /*
     * Exception decompiling
     */
    private DsqCallback<DispenseDetails> getDetail3(String dispenseNumber, IPatient patient, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setPatient(IPatient patient) {
        this.patient = patient;
        this.dispenses = null;
        this.lastQCR = null;
    }

    public LocalDate getStart() {
        return this.start;
    }

    public void setStart(LocalDate start) {
        this.start = start;
        this.dispenses = null;
        this.lastQCR = null;
    }

    public LocalDate getEnd() {
        return this.end;
    }

    public void setEnd(LocalDate end) {
        this.end = end;
        this.dispenses = null;
        this.lastQCR = null;
    }

    public boolean isMostRecent() {
        return this.mostRecent;
    }

    public void setMostRecent(boolean mostRecent) {
        this.mostRecent = mostRecent;
        this.dispenses = null;
        this.lastQCR = null;
    }

    public boolean getActiveProfile() {
        return this.activeProfile;
    }

    public void setActiveProfile(boolean activeProfile) {
        this.activeProfile = activeProfile;
        this.dispenses = null;
        this.lastQCR = null;
        this.start = LocalDate.from((int)1, (int)1, (int)2007);
        this.end = LocalDate.today();
        this.mostRecent = true;
    }

    public IPatient getPatient() {
        return this.patient;
    }

    public XPrescription convertDetail3Sync(String dispenseId) {
        DispenseDetails d = this.dispenseIdMapDetail.get(dispenseId);
        if (d == null) {
            throw new RuntimeException("Failed to convert dispense " + dispenseId + " to XPrescription because details is not in cache");
        }
        return this.convertDispenseDetailsToXPrescription(d);
    }

    public static XPrescription convertDispenseSummaryToXPrescription(DispenseSummary d) {
        XPrescription prescription = new XPrescription();
        prescription.setId(null);
        prescription.setDsqPrescriptionDispenseId(d.id);
        prescription.setDsqDMPrescriptionId(d.prescriptionId);
        prescription.setDsqDMPrescriptionVersion(d.prescriptionVersion);
        prescription.setToReprescribe(Boolean.valueOf(false));
        prescription.setNoSubstitution(Boolean.valueOf(false));
        prescription.setIsDeleted(Boolean.valueOf(false));
        prescription.setNoSubstitution(Boolean.valueOf(false));
        prescription.setToReprescribe(Boolean.valueOf(true));
        prescription.setEncounter(null);
        prescription.setAllergy(null);
        prescription.setDosageChange(XChangeDose.NO_INFO);
        prescription.setStopReason(null);
        prescription.setSeverity(null);
        prescription.setStopEncounter(null);
        prescription.setStopDate(null);
        ParsedName parseMedicationName = DispenseController.parseMedicationName(d);
        XDrugStrength drug = new XDrugStrength();
        drug.setGenericName(parseMedicationName.generic);
        drug.setCommercialName(parseMedicationName.commercial);
        drug.setDrugType(XDrugType.REGULAR);
        prescription.setStrength(drug);
        Code medicationCode = DispenseController.isMagistralOfOneIngredient(d) ? ((Ingredient)d.drugIngredients.get((int)0)).code : d.drugFormCode;
        DIN din = null;
        if (medicationCode != null) {
            String code = medicationCode.code;
            if (StringUtils.isAnInteger((String)code)) {
                prescription.setDin(Integer.valueOf(Integer.parseInt(code)));
                try {
                    IRxDrugRefAccessor rxDrugRef = Application.get().getDataAccessors().getRxDrugRefAccessor();
                    din = rxDrugRef.getDinByDin(code);
                }
                catch (Exception e) {
                    logger.log(Level.INFO, "Failed to get rxdrug information from din " + code, e);
                }
            }
            if (din == null && StringUtils.isNotBlank((String)medicationCode.text)) {
                drug.setCommercialName(medicationCode.text);
            }
            if (din != null) {
                drug.setCommercialName(din.commercialName);
                drug.setGenericName(din.genericName);
                drug.setDin(din.din);
            }
        }
        XMyOrderableDrugForm format = XMyOrderableDrugForm.getDrugForm((String)parseMedicationName.format);
        prescription.setFormat(format);
        String drugStrenght = din != null && StringUtils.isNotBlank((String)din.strength) ? din.strength : (d.drugIngredients != null && d.drugIngredients.size() > 1 ? "Magistrale" : parseMedicationName.strength);
        if (StringUtils.isBlank((CharSequence)drugStrenght)) {
            drugStrenght = " - ";
        }
        prescription.setPosology(d.dosageInstructions);
        LocalDate startdate = LocalDate.fromTimeInMillisLOCAL((Long)d.prescriptionDate);
        LocalDate enddate = startdate.plusYear(1);
        prescription.setStartDate(startdate);
        prescription.setEndDate(enddate);
        String note = "";
        if (d.drugIngredients != null && d.drugIngredients.size() > 0) {
            if (d.drugIngredients.size() == 1) {
                note = d.drugName;
            }
            StringBuilder ingr = new StringBuilder(d.drugIngredients.size() * 50);
            for (Ingredient i : d.drugIngredients) {
                ingr.append("\n\tIngr\u00e9dient " + SqimHtmlFormatter.formatCode((Code)i.code)).append(", ").append(i.name).append(" " + (i.quantity == null ? "" : i.quantity)).append(i.referenceProtocolId == null ? "" : " " + i.referenceProtocolId);
            }
            note = String.valueOf(note) + ingr;
        }
        if (prescription.getQuantity() != null && prescription.getTreatmentDuration() != null) {
            if (StringUtils.isNotBlank((String)note)) {
                note = String.valueOf(note) + "\n";
            }
            note = String.valueOf(note) + "Dur\u00e9e " + prescription.getTreatmentDuration() + " jour(s)";
            prescription.setTreatmentDuration(null);
        }
        prescription.setNote(note);
        return prescription;
    }

    private XPrescription convertDispenseDetailsToXPrescription(DispenseDetails d) {
        XMyOrderableDrugForm format;
        Code formCode;
        XPrescription prescription = new XPrescription();
        prescription.setId(null);
        prescription.setDsqPrescriptionDispenseId(d.id);
        prescription.setDsqDMPrescriptionId(d.prescriptionId);
        prescription.setDsqDMPrescriptionVersion(d.prescriptionVersion);
        prescription.setToReprescribe(Boolean.valueOf(false));
        prescription.setNoSubstitution(Boolean.valueOf(false));
        prescription.setIsDeleted(Boolean.valueOf(false));
        prescription.setNoSubstitution(Boolean.valueOf(false));
        prescription.setToReprescribe(Boolean.valueOf(true));
        prescription.setEncounter(null);
        prescription.setAllergy(null);
        prescription.setDosageChange(XChangeDose.NO_INFO);
        prescription.setStopReason(null);
        prescription.setSeverity(null);
        prescription.setStopEncounter(null);
        prescription.setStopDate(null);
        ParsedName parseMedicationName = DispenseController.parseMedicationName(d);
        XDrugStrength drug = new XDrugStrength();
        drug.setGenericName(parseMedicationName.generic);
        drug.setCommercialName(parseMedicationName.commercial);
        drug.setDrugType(XDrugType.REGULAR);
        prescription.setStrength(drug);
        Code medicationCode = DispenseController.isMagistralOfOneIngredient(d) ? ((Ingredient)d.medication.ingredients.get((int)0)).code : d.medication.code;
        DIN din = null;
        if (medicationCode != null) {
            String code = medicationCode.code;
            if (StringUtils.isAnInteger((String)code)) {
                prescription.setDin(Integer.valueOf(Integer.parseInt(code)));
                try {
                    IRxDrugRefAccessor rxDrugRef = Application.get().getDataAccessors().getRxDrugRefAccessor();
                    din = rxDrugRef.getDinByDin(code);
                }
                catch (Exception e) {
                    logger.log(Level.INFO, "Failed to get rxdrug information from din " + code, e);
                }
            }
            if (din == null && StringUtils.isNotBlank((String)medicationCode.text)) {
                drug.setCommercialName(medicationCode.text);
            }
            if (din != null) {
                drug.setCommercialName(din.commercialName);
                drug.setGenericName(din.genericName);
                drug.setDin(din.din);
            }
        }
        if ((formCode = d.medication.formCode) != null) {
            format = XMyOrderableDrugForm.getDrugForm((String)formCode.code);
            prescription.setFormat(format);
        } else {
            format = XMyOrderableDrugForm.getDrugForm((String)parseMedicationName.format);
            prescription.setFormat(format);
        }
        String drugStrenght = din != null && StringUtils.isNotBlank((String)din.strength) ? din.strength : (d.medication.ingredients != null && d.medication.ingredients.size() > 1 ? "Magistrale" : parseMedicationName.strength);
        if (StringUtils.isBlank((CharSequence)drugStrenght)) {
            drugStrenght = " - ";
        }
        String posology = "";
        if (d.dosageInstructions != null) {
            ArrayList<Dosage> dosages = new ArrayList<Dosage>();
            for (DosageInstruction di : d.dosageInstructions) {
                Dosage dosage = new Dosage();
                dosage.route = XMyRouteOfAdministration.getRoute(di.routeCode == null ? null : di.routeCode.code);
                dosage.route = dosage.route == null ? XMyRouteOfAdministration.SO_NA : dosage.route;
                dosage.text = di.text;
                dosage.additionnalInstructions = di.additionnalInstructions;
                if (d.quantity != null) {
                    dosage.quantity = d.quantity;
                }
                if (di.duration != null) {
                    int duration = di.duration.value.intValue();
                    if (!"d".equalsIgnoreCase(di.duration.unit) && !"day".equalsIgnoreCase(di.duration.unit)) {
                        if ("a".equalsIgnoreCase(di.duration.unit) || "year".equalsIgnoreCase(di.duration.unit)) {
                            duration *= 365;
                        } else if ("w".equalsIgnoreCase(di.duration.unit) || "wk".equalsIgnoreCase(di.duration.unit) || "week".equalsIgnoreCase(di.duration.unit)) {
                            duration *= 7;
                        } else if ("m".equalsIgnoreCase(di.duration.unit) || "mo".equalsIgnoreCase(di.duration.unit) || "month".equalsIgnoreCase(di.duration.unit)) {
                            duration *= 31;
                        } else {
                            throw new RuntimeException("unsupporded duration unit " + di.duration.unit);
                        }
                    }
                    dosage.duration = di.duration;
                }
                dosage.fromDate = di.fromDate;
                if (di.approachSiteCodes != null) {
                    dosage.sites = new ArrayList<XMyHumanSubstanceAdministrationSite>();
                    for (Code site : di.approachSiteCodes) {
                        dosage.sites.add(XMyHumanSubstanceAdministrationSite.getSite((String)site.code));
                    }
                }
                dosage.frequencies = new ArrayList<String>();
                if (di.maxDoseNumerators != null) {
                    int i = 0;
                    while (i < di.maxDoseNumerators.size()) {
                        ValueWithUnit num = (ValueWithUnit)di.maxDoseNumerators.get(i);
                        ValueWithUnit den = (ValueWithUnit)di.maxDoseDenominators.get(i);
                        dosage.frequencies.add("Dose maximale: " + num + " / " + den);
                        ++i;
                    }
                }
                dosages.add(dosage);
            }
            if (dosages.size() == 0) {
                throw new RuntimeException("no dosages");
            }
            if (dosages.size() == 1) {
                Dosage dosage = (Dosage)dosages.get(0);
                prescription.setRoute(dosage.route);
                if (dosage.sites.size() == 1) {
                    prescription.setSite(dosage.sites.get(0));
                } else {
                    prescription.setSite(XMyHumanSubstanceAdministrationSite.SO_NA);
                }
                ParsedDosage parsedDosage = DispenseController.parseDosageText(d);
                if (StringUtils.isNotBlank((String)parsedDosage.rx) && StringUtils.isNumeric((String)parsedDosage.rx)) {
                    prescription.setRx(Integer.valueOf(Integer.parseInt(parsedDosage.rx)));
                } else {
                    prescription.setRx(Integer.valueOf(0));
                }
                if (StringUtils.isNotBlank((String)parsedDosage.frequency)) {
                    prescription.setFrequency(parsedDosage.frequency);
                } else {
                    prescription.setFrequency("Voir posologie");
                }
                if (dosage.quantity != null && dosage.quantity.value.intValue() != 0) {
                    prescription.setQuantity(Integer.valueOf(dosage.quantity.value.intValue()));
                }
                if (dosage.duration != null && dosage.duration.value.intValue() != 0) {
                    prescription.setTreatmentDuration(Integer.valueOf(dosage.duration.value.intValue()));
                }
                JoinList list = new JoinList("").setTrim(false).setNoDuplicate(true);
                list.setSuffix("\n");
                list.add((CharSequence)dosage.text);
                list.add((CharSequence)dosage.additionnalInstructions);
                list.add((CharSequence)SqimHtmlFormatter.formatDuration((Long)dosage.fromDate, null, (Duration)dosage.duration));
                if (dosage.frequencies.size() > 0) {
                    list.addAll(dosage.frequencies);
                }
                if (dosage.sites.size() > 1) {
                    for (XMyHumanSubstanceAdministrationSite site : dosage.sites) {
                        list.add((CharSequence)site.description());
                    }
                }
                posology = list.toString();
            } else {
                Collections.sort(dosages, new Comparator<Dosage>(){

                    @Override
                    public int compare(Dosage o1, Dosage o2) {
                        if (o1.fromDate == o2.fromDate) {
                            return 0;
                        }
                        if (o1.fromDate == null) {
                            return -1;
                        }
                        if (o2.fromDate == null) {
                            return 1;
                        }
                        return o1.fromDate.compareTo(o2.fromDate);
                    }
                });
                prescription.setRoute(XMyRouteOfAdministration.SO_NA);
                prescription.setSite(XMyHumanSubstanceAdministrationSite.SO_NA);
                prescription.setFrequency("Voir polosogie");
                if (d.quantity != null && d.quantity.value.intValue() != 0) {
                    prescription.setQuantity(Integer.valueOf(d.quantity.value.intValue()));
                }
                if (d.expectedUseTime != null && d.expectedUseTime.value.intValue() != 0) {
                    prescription.setTreatmentDuration(Integer.valueOf(d.expectedUseTime.value.intValue()));
                }
                JoinList list = new JoinList("\n\n");
                int i = 0;
                for (Dosage dosage : dosages) {
                    JoinList list2 = new JoinList("\n");
                    list2.add((CharSequence)("Instruction " + ++i));
                    list2.setPrefix("\t");
                    list2.add((CharSequence)dosage.text);
                    list2.add((CharSequence)dosage.additionnalInstructions);
                    if (dosage.route != null) {
                        list2.add((CharSequence)(String.valueOf(dosage.route.name()) + " - " + dosage.route.description()));
                    }
                    list2.add((CharSequence)SqimHtmlFormatter.formatDuration((Long)dosage.fromDate, null, (Duration)dosage.duration));
                    if (dosage.frequencies.size() > 1) {
                        list2.addAll(dosage.frequencies);
                    }
                    if (dosage.sites.size() > 1) {
                        for (XMyHumanSubstanceAdministrationSite site : dosage.sites) {
                            list2.add((CharSequence)site.description());
                        }
                    }
                    list.add((CharSequence)list2.toString());
                }
                posology = list.toString();
                prescription.setRx(Integer.valueOf(0));
            }
        }
        prescription.setPosology(posology);
        LocalDate startdate = LocalDate.fromTimeInMillisLOCAL((Long)d.prescriptionDate);
        LocalDate enddate = startdate.plusYear(1);
        prescription.setStartDate(startdate);
        prescription.setEndDate(enddate);
        String note = "";
        if (d.medication.ingredients != null && d.medication.ingredients.size() > 0) {
            if (d.medication.ingredients.size() == 1) {
                note = d.medication.name;
            }
            StringBuilder ingr = new StringBuilder(d.medication.ingredients.size() * 50);
            for (Ingredient i : d.medication.ingredients) {
                ingr.append("\n\tIngr\u00e9dient " + SqimHtmlFormatter.formatCode((Code)i.code)).append(", ").append(i.name).append(" " + (i.quantity == null ? "" : i.quantity)).append(i.referenceProtocolId == null ? "" : " " + i.referenceProtocolId);
            }
            note = String.valueOf(note) + ingr;
        }
        if (prescription.getQuantity() != null && prescription.getTreatmentDuration() != null) {
            if (StringUtils.isNotBlank((String)note)) {
                note = String.valueOf(note) + "\n";
            }
            note = String.valueOf(note) + "Dur\u00e9e " + prescription.getTreatmentDuration() + " jour(s)";
            prescription.setTreatmentDuration(null);
        }
        prescription.setNote(note);
        return prescription;
    }

    private static boolean isMagistralOfOneIngredient(DispenseDetails d) {
        return d.medication.ingredients != null && d.medication.ingredients.size() == 1;
    }

    private static boolean isMagistralOfOneIngredient(DispenseSummary d) {
        return d.drugIngredients != null && d.drugIngredients.size() == 1;
    }

    private static ParsedName parseMedicationName(DispenseSummary d) {
        String s;
        int ii;
        String[] nameParts;
        String medicationDescription;
        String medicationName;
        ParsedName parsedName = new ParsedName();
        if (DispenseController.isMagistralOfOneIngredient(d)) {
            medicationName = ((Ingredient)d.drugIngredients.get((int)0)).code.text;
            medicationDescription = ((Ingredient)d.drugIngredients.get((int)0)).name;
        } else {
            medicationName = d.drugName;
            medicationDescription = d.drugDescription;
        }
        String text = medicationName;
        if (StringUtils.isNotBlank((String)text)) {
            nameParts = StringUtils.split((String)text, (char)' ');
            ii = 0;
            while (ii < nameParts.length) {
                s = nameParts[ii];
                if (s.length() == 0 || pat09.matcher(s.substring(0, 1)).matches()) break;
                parsedName.commercial = String.valueOf(parsedName.commercial) + " " + s.trim();
                ++ii;
            }
            parsedName.commercial = parsedName.commercial.trim();
            while (ii < nameParts.length) {
                s = nameParts[ii];
                if (s.length() == 0) break;
                if (pat09.matcher(s.substring(0, 1)).matches()) {
                    parsedName.strength = s.trim();
                } else {
                    parsedName.format = String.valueOf(parsedName.format) + " " + s.trim();
                }
                ++ii;
            }
            parsedName.format = parsedName.format.trim();
        }
        if (StringUtils.isNotBlank((String)(text = medicationDescription))) {
            nameParts = StringUtils.split((String)text, (char)' ');
            ii = 0;
            while (ii < nameParts.length) {
                s = nameParts[ii];
                if (s.length() == 0 || pat09.matcher(s.substring(0, 1)).matches()) break;
                parsedName.generic = String.valueOf(parsedName.generic) + " " + s;
                ++ii;
            }
            parsedName.generic = parsedName.generic.trim();
            if (StringUtils.isBlank((CharSequence)parsedName.format)) {
                while (ii < nameParts.length) {
                    s = nameParts[ii];
                    if (s.length() == 0) break;
                    if (pat09.matcher(s.substring(0, 1)).matches()) {
                        parsedName.strength = s;
                    } else {
                        parsedName.format = String.valueOf(parsedName.format) + " " + s;
                    }
                    ++ii;
                }
                parsedName.format = StringUtils.trim((String)parsedName.format);
            }
        } else {
            parsedName.generic = parsedName.commercial;
        }
        return parsedName;
    }

    private static ParsedName parseMedicationName(DispenseDetails d) {
        String s;
        int ii;
        String[] nameParts;
        String medicationDescription;
        String medicationName;
        ParsedName parsedName = new ParsedName();
        if (DispenseController.isMagistralOfOneIngredient(d)) {
            medicationName = ((Ingredient)d.medication.ingredients.get((int)0)).code.text;
            medicationDescription = ((Ingredient)d.medication.ingredients.get((int)0)).name;
        } else {
            medicationName = d.medication.name;
            medicationDescription = d.medication.description;
        }
        String text = medicationName;
        if (StringUtils.isNotBlank((String)text)) {
            nameParts = StringUtils.split((String)text, (char)' ');
            ii = 0;
            while (ii < nameParts.length) {
                s = nameParts[ii];
                if (s.length() == 0 || pat09.matcher(s.substring(0, 1)).matches()) break;
                parsedName.commercial = String.valueOf(parsedName.commercial) + " " + s.trim();
                ++ii;
            }
            parsedName.commercial = parsedName.commercial.trim();
            while (ii < nameParts.length) {
                s = nameParts[ii];
                if (s.length() == 0) break;
                if (pat09.matcher(s.substring(0, 1)).matches()) {
                    parsedName.strength = s.trim();
                } else {
                    parsedName.format = String.valueOf(parsedName.format) + " " + s.trim();
                }
                ++ii;
            }
            parsedName.format = parsedName.format.trim();
        }
        if (StringUtils.isNotBlank((String)(text = medicationDescription))) {
            nameParts = StringUtils.split((String)text, (char)' ');
            ii = 0;
            while (ii < nameParts.length) {
                s = nameParts[ii];
                if (s.length() == 0 || pat09.matcher(s.substring(0, 1)).matches()) break;
                parsedName.generic = String.valueOf(parsedName.generic) + " " + s;
                ++ii;
            }
            parsedName.generic = parsedName.generic.trim();
            if (StringUtils.isBlank((CharSequence)parsedName.format)) {
                while (ii < nameParts.length) {
                    s = nameParts[ii];
                    if (s.length() == 0) break;
                    if (pat09.matcher(s.substring(0, 1)).matches()) {
                        parsedName.strength = s;
                    } else {
                        parsedName.format = String.valueOf(parsedName.format) + " " + s;
                    }
                    ++ii;
                }
                parsedName.format = StringUtils.trim((String)parsedName.format);
            }
        } else {
            parsedName.generic = parsedName.commercial;
        }
        return parsedName;
    }

    private static ParsedDosage parseDosageText(DispenseDetails d) {
        if (d.dosageInstructions.size() != 1) {
            throw new RuntimeException("cant parse dosage if more or less than 1 dosage instructions");
        }
        ParsedDosage parsedDosage = new ParsedDosage();
        DosageInstruction di = (DosageInstruction)d.dosageInstructions.get(0);
        String text = new JoinList(" ", new Object[]{di.text, di.additionnalInstructions}).setNoDuplicate(true).setTrim(true).toString();
        String[] dosageInstructions = text.split(":::");
        if (dosageInstructions.length > 0) {
            String[] renew = dosageInstructions[0].split("/");
            if (renew.length > 1) {
                parsedDosage.rx = renew[1];
            }
            String[] dosages = StringUtils.split((String)text, (char)' ');
            int k = 0;
            String freq = "";
            while (k < dosages.length) {
                String s = dosages[k];
                if (s.length() == 0) break;
                freq = String.valueOf(freq) + " " + s;
                ++k;
            }
            parsedDosage.frequency = DispenseController.getFrequency(freq);
        }
        return parsedDosage;
    }

    private static String getFrequency(String f) {
        f = f.toUpperCase();
        String s = "Voir posologie";
        String p = "";
        String h = "";
        if (f.contains("BESOIN") || f.contains("NEEDED") || f.contains("PRN")) {
            p = "PRN";
        }
        if (f.contains("COUCHER") || f.contains("BEDTIME")) {
            h = "HS";
        }
        if ((f = f.replaceAll("\\bUN\\b|\\bUNE\\b|\\bONE\\b", "1").replaceAll("\\bDEUX\\b|\\bTWO\\b", "2").replaceAll("\\bTROIS\\b|\\bTHREE\\b", "3").replaceAll("\\bQUATRE\\b|\\bFOUR\\b", "4").replaceAll("\\bCINQ\\b|\\bFIVE\\b", "5").replaceAll("\\bSIX\\b|\\bSIX\\b", "6").replaceAll("\\bSEPT\\b|\\bSEVEN\\b", "7").replaceAll("\\bHUIT\\b|\\bEIGHT\\b", "8").replaceAll("\\bNEUF\\b|\\bNINE\\b", "9").replaceAll("\\bDIX\\b|\\bTEN\\b", "10").replaceAll("\\bONZE\\b|\\bELEVEN\\b", "11").replaceAll("\\bDOUZE\\b|\\bTWELVE\\b", "12")).contains("1 FOIS PAR JOUR") || f.contains("ONCE A DAY")) {
            s = "ID";
        } else if (f.contains("2 FOIS PAR JOUR") || f.contains("TWICE A DAY")) {
            s = "BID";
        } else if (f.contains("AUX 12 HEURES") || f.contains("EVERY 12 HOURS")) {
            s = "q 12 H";
        } else if (f.contains("3 FOIS PAR JOUR") || f.contains("3 TIMES A DAY")) {
            s = "TID";
        } else if (f.contains("4 FOIS PAR JOUR") || f.contains("4 TIMES A DAY")) {
            s = "QID";
        } else if (f.contains("3") && f.contains("4") && f.contains("HEURES") || f.contains("HOURS")) {
            s = "q 3-4 H";
        } else if (f.contains("4") && f.contains("6") && f.contains("HEURES") || f.contains("HOURS")) {
            s = "q 4-6 H";
        } else if (f.contains("6") && f.contains("8") && f.contains("HEURES") || f.contains("HOURS")) {
            s = "q 6-8 H";
        } else if (f.contains("4 HEURES") || f.contains("4 HOURS")) {
            s = "q 4 H";
        } else if (f.contains("6 HEURES") || f.contains("6 HOURS")) {
            s = "q 6 H";
        } else if (f.contains("8 HEURES") || f.contains("8 HOURS")) {
            s = "q 8 H";
        } else if (f.contains("AVANT") && f.contains("REPAS") || f.contains("BEFORE") && f.contains("MEAL")) {
            s = "AC";
        } else if (f.contains("APRES") && f.contains("REPAS") || f.contains("AFTER") && f.contains("MEAL")) {
            s = "PC";
        } else if (f.contains("PAR JOUR") || f.contains("PER DAY")) {
            s = "ID";
        }
        if (p.length() > 0) {
            s = s.length() > 0 ? String.valueOf(s) + " " + p : p;
        }
        if (h.length() > 0) {
            s = s.length() > 0 ? String.valueOf(s) + " " + h : h;
        }
        return s;
    }

    public DispenseControllerCallback getCallback() {
        return this.callback;
    }

    final class BatchJob
    extends Job {
        private String dispenseId;
        private String dId;
        private String idRx;

        public void setDispenseId(String dispenseId) {
            this.dispenseId = dispenseId;
        }

        private BatchJob(String name, String dId, String idRx) {
            super(name);
            this.dId = dId;
            this.idRx = idRx;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                try {
                    DispenseController.this.getDetailForBatch2(this.dispenseId, this.dId, this.idRx, monitor);
                }
                catch (Exception e) {
                    DispenseController.this.callback.getDetailForImport(this.dispenseId, this.dId, this.idRx, (DsqCallback<DispenseDetails>)new DsqCallback(null, null, e));
                    DispenseController.this.batchJobs.remove((Object)this);
                }
            }
            finally {
                DispenseController.this.batchJobs.remove((Object)this);
            }
            return Status.OK_STATUS;
        }
    }

    final class ConvertJob
    extends Job {
        private String dispenseId;

        public void setDispenseId(String dispenseId) {
            this.dispenseId = dispenseId;
        }

        private ConvertJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            DispenseController.this.convertDetail2(this.dispenseId, monitor);
            return Status.OK_STATUS;
        }
    }

    private static class Dosage {
        String text;
        String additionnalInstructions;
        XMyRouteOfAdministration route;
        List<XMyHumanSubstanceAdministrationSite> sites;
        List<String> frequencies;
        Quantity quantity;
        Duration duration;
        Long fromDate;

        private Dosage() {
        }
    }

    private final class JobDsqContextNui
    extends Job {
        private NIU_PRESCRIPTION_DM niu;
        private String context;

        private JobDsqContextNui(String name, NIU_PRESCRIPTION_DM niu, String context) {
            super(name);
            this.niu = niu;
            this.context = context;
        }

        protected IStatus run(IProgressMonitor monitor) {
            DispenseController.this.listSummaryForPrescription2(this.niu, this.context, monitor);
            return Status.OK_STATUS;
        }

        public void setNiu(NIU_PRESCRIPTION_DM niu) {
            this.niu = niu;
        }

        public void setContext(String context) {
            this.context = context;
        }
    }

    final class JobExtension
    extends Job {
        private String dispenseId;

        public void setDispenseId(String dispenseId) {
            this.dispenseId = dispenseId;
        }

        private JobExtension(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            DispenseController.this.getDetail2(this.dispenseId, monitor);
            return Status.OK_STATUS;
        }
    }

    private static class ParsedDosage {
        String rx;
        String frequency;

        private ParsedDosage() {
        }
    }

    private static class ParsedName {
        String commercial = "";
        String generic = "";
        String strength = "";
        String format = "";

        private ParsedName() {
        }
    }
}

