/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dsq;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.modules.dsq.IDSQPluginController;
import ca.infodata.ofys.data.dataaccess.util.GlobalInstancesAdapter;
import ca.infodata.ofys.data.dataaccess.util.GlobalInstancesListener;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.ui.dsq.BaseDSQAction;
import ca.infodata.ofys.ui.dsq.DSQPluginController;
import ca.infodata.ofys.ui.dsq.DsqSourceProvider;
import ca.infodata.ofys.util.MiscUtil;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.services.ISourceProviderService;
import org.osgi.framework.BundleContext;

public class DSQPlugin
extends AbstractUIPlugin {
    private static final Logger logger = Logger.getLogger("ca.infodata.ofys.ui.dsq");
    public static final String PLUGIN_ID = "ca.infodata.ofys.ui.dsq";
    private static DSQPlugin plugin;
    private boolean dsqSessionEnabled = true;
    private GlobalInstancesListener sessionListener;
    private WeakReference<XSession> sessionRef;
    private DSQPluginController dsqPluginController;

    public void start(BundleContext context) throws Exception {
        System.out.println("DSQPlugin.start()");
        super.start(context);
        plugin = this;
        this.sessionListener = new GlobalInstancesAdapter(){

            public void sessionChanged() {
                XSession session = Application.get().getGlobalInstances().getSession();
                boolean doit = false;
                doit = doit || DSQPlugin.this.sessionRef == null || DSQPlugin.this.sessionRef.get() == null;
                doit = doit || session == null;
                boolean bl = doit = doit || !MiscUtil.areObjectsEquals((Object)session.getId(), (Object)((XSession)DSQPlugin.this.sessionRef.get()).getId());
                if (doit) {
                    Application.get().getDsqPluginController().clearDSQSession();
                    Application.get().getDsqPluginController().setDsqEnabledForSession(true);
                }
                DSQPlugin.this.sessionRef = new WeakReference<XSession>(session);
            }
        };
        this.dsqPluginController = new DSQPluginController(this);
        Application.get().setDsqPluginController((IDSQPluginController)this.dsqPluginController);
        Application.get().getGlobalInstances().addGlobalInstancesListener(this.sessionListener);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
        Application.get().getGlobalInstances().removeGlobalInstancesListener(this.sessionListener);
    }

    public BaseDSQAction getBaseDSQAction() {
        return this.dsqPluginController.getDsq();
    }

    public static DSQPlugin getDefault() {
        return plugin;
    }

    public boolean isDsqEnabledForSession() {
        return this.dsqSessionEnabled;
    }

    public void setDsqEnabledForSession(boolean enabled) {
        this.dsqSessionEnabled = enabled;
        ISourceProviderService service = (ISourceProviderService)this.getWorkbench().getService(ISourceProviderService.class);
        final DsqSourceProvider dsqSourceProvider = (DsqSourceProvider)service.getSourceProvider("ca.infodata.ofys.ui.encounter.dsq.state");
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                dsqSourceProvider.refresh();
            }
        });
    }

    public boolean isDsqEnabled() {
        return this.isDsqEnabledForSession() && this.isDsqEnabledForClient();
    }

    public boolean isDsqEnabledForClient() {
        boolean enabled = false;
        try {
            XSession session = Application.get().getGlobalInstances().getSession();
            if (session != null) {
                enabled = session.getClientPreferences().getIsDsqEnabled();
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to get isDsqActive value. default to false.", e);
        }
        return enabled;
    }
}

