/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import org.apache.lucene.util.packed.BulkOperationPacked;

final class BulkOperationPacked16
extends BulkOperationPacked {
    public BulkOperationPacked16() {
        super(16);
    }

    @Override
    public void decode(long[] blocks, int blocksOffset, int[] values, int valuesOffset, int iterations) {
        int i = 0;
        while (i < iterations) {
            long block = blocks[blocksOffset++];
            int shift = 48;
            while (shift >= 0) {
                values[valuesOffset++] = (int)(block >>> shift & 0xFFFFL);
                shift -= 16;
            }
            ++i;
        }
    }

    @Override
    public void decode(byte[] blocks, int blocksOffset, int[] values, int valuesOffset, int iterations) {
        int j = 0;
        while (j < iterations) {
            values[valuesOffset++] = (blocks[blocksOffset++] & 0xFF) << 8 | blocks[blocksOffset++] & 0xFF;
            ++j;
        }
    }

    @Override
    public void decode(long[] blocks, int blocksOffset, long[] values, int valuesOffset, int iterations) {
        int i = 0;
        while (i < iterations) {
            long block = blocks[blocksOffset++];
            int shift = 48;
            while (shift >= 0) {
                values[valuesOffset++] = block >>> shift & 0xFFFFL;
                shift -= 16;
            }
            ++i;
        }
    }

    @Override
    public void decode(byte[] blocks, int blocksOffset, long[] values, int valuesOffset, int iterations) {
        int j = 0;
        while (j < iterations) {
            values[valuesOffset++] = ((long)blocks[blocksOffset++] & 0xFFL) << 8 | (long)blocks[blocksOffset++] & 0xFFL;
            ++j;
        }
    }
}

