/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.search.spell.TermFreqIterator;
import org.apache.lucene.search.suggest.BufferingTermFreqIteratorWrapper;
import org.apache.lucene.util.BytesRef;

public class UnsortedTermFreqIteratorWrapper
extends BufferingTermFreqIteratorWrapper {
    private final int[] ords;
    private int currentOrd = -1;
    private final BytesRef spare = new BytesRef();

    public UnsortedTermFreqIteratorWrapper(TermFreqIterator source) throws IOException {
        super(source);
        this.ords = new int[this.entries.size()];
        Random random = new Random();
        int i = 0;
        while (i < this.ords.length) {
            this.ords[i] = i;
            ++i;
        }
        i = 0;
        while (i < this.ords.length) {
            int randomPosition = random.nextInt(this.ords.length);
            int temp = this.ords[i];
            this.ords[i] = this.ords[randomPosition];
            this.ords[randomPosition] = temp;
            ++i;
        }
    }

    @Override
    public long weight() {
        return this.freqs[this.currentOrd];
    }

    @Override
    public BytesRef next() throws IOException {
        if (++this.curPos < this.entries.size()) {
            this.currentOrd = this.ords[this.curPos];
            return this.entries.get(this.spare, this.currentOrd);
        }
        return null;
    }
}

